/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task.ssh;

import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigUtils;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.location.Location;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.ManagementContext;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.util.ResourceUtils;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.net.Urls;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.ssh.SshFetchTaskFactory;
import brooklyn.util.task.ssh.SshPutTaskFactory;
import brooklyn.util.task.ssh.internal.PlainSshExecTaskFactory;
import brooklyn.util.task.system.ProcessTaskFactory;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SshTasks {
    private static final Logger log = LoggerFactory.getLogger(SshTasks.class);

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(SshMachineLocation machine, String ... commands) {
        return SshTasks.newSshExecTaskFactory(machine, true, commands);
    }

    public static ProcessTaskFactory<Integer> newSshExecTaskFactory(SshMachineLocation machine, final boolean useMachineConfig, String ... commands) {
        return new PlainSshExecTaskFactory<Integer>(machine, commands){
            {
                super(x0, x1);
                if (useMachineConfig) {
                    this.config.putIfAbsent(SshTasks.getSshFlags(this.machine));
                }
            }
        };
    }

    public static SshPutTaskFactory newSshPutTaskFactory(SshMachineLocation machine, String remoteFile) {
        return SshTasks.newSshPutTaskFactory(machine, true, remoteFile);
    }

    public static SshPutTaskFactory newSshPutTaskFactory(SshMachineLocation machine, final boolean useMachineConfig, String remoteFile) {
        return new SshPutTaskFactory(machine, remoteFile){
            {
                super(x0, x1);
                if (useMachineConfig) {
                    this.config.putIfAbsent(SshTasks.getSshFlags(this.machine));
                }
            }
        };
    }

    public static SshFetchTaskFactory newSshFetchTaskFactory(SshMachineLocation machine, String remoteFile) {
        return SshTasks.newSshFetchTaskFactory(machine, true, remoteFile);
    }

    public static SshFetchTaskFactory newSshFetchTaskFactory(SshMachineLocation machine, final boolean useMachineConfig, String remoteFile) {
        return new SshFetchTaskFactory(machine, remoteFile){
            {
                super(x0, x1);
                if (useMachineConfig) {
                    this.config.putIfAbsent(SshTasks.getSshFlags(this.machine));
                }
            }
        };
    }

    private static Map<String, Object> getSshFlags(Location location) {
        ManagementContext mgmt;
        ConfigBag allConfig = ConfigBag.newInstance();
        if (location instanceof AbstractLocation && (mgmt = ((AbstractLocation)location).getManagementContext()) != null) {
            allConfig.putAll(mgmt.getConfig().getAllConfig());
        }
        allConfig.putAll(((LocationInternal)location).config().getBag());
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (String keyS : allConfig.getAllConfig().keySet()) {
            ConfigKey<Object> key = ConfigKeys.newConfigKey(Object.class, keyS);
            if (!key.getName().startsWith("brooklyn.ssh.config.")) continue;
            result.put(ConfigUtils.unprefixedKey("brooklyn.ssh.config.", key).getName(), allConfig.get(key));
        }
        return result;
    }

    public static ProcessTaskFactory<Boolean> dontRequireTtyForSudo(SshMachineLocation machine, boolean failIfCantSudo) {
        return SshTasks.dontRequireTtyForSudo(machine, failIfCantSudo ? OnFailingTask.FAIL : OnFailingTask.WARN_IN_LOG_ONLY);
    }

    public static ProcessTaskFactory<Boolean> dontRequireTtyForSudo(SshMachineLocation machine, OnFailingTask onFailingTaskRequested) {
        final OnFailingTask onFailingTask = onFailingTaskRequested == OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL ? (DynamicTasks.getTaskQueuingContext() != null ? onFailingTaskRequested : OnFailingTask.WARN_IN_LOG_ONLY) : onFailingTaskRequested;
        final String id = Identifiers.makeRandomId((int)6);
        return SshTasks.newSshExecTaskFactory(machine, BashCommands.dontRequireTtyForSudo(), BashCommands.sudo((String)("echo \"sudo\"-is-working-" + id))).summary("setting up sudo").configure(SshTool.PROP_ALLOCATE_PTY, true).allowingNonZeroExitCode().returning(new Function<ProcessTaskWrapper<?>, Boolean>(){

            public Boolean apply(ProcessTaskWrapper<?> task) {
                if (task.getExitCode() == 0 && task.getStdout().contains("sudo-is-working-" + id)) {
                    return true;
                }
                Entity entity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
                if (onFailingTask != OnFailingTask.IGNORE) {
                    String message = "Error setting up sudo for " + task.getMachine().getUser() + "@" + task.getMachine().getAddress().getHostName() + " " + " (exit code " + task.getExitCode() + (entity != null ? ", entity " + entity : "") + ")";
                    DynamicTasks.queueIfPossible(Tasks.warning(message, null));
                }
                Streams.logStreamTail((Logger)log, (String)"STDERR of sudo setup problem", (ByteArrayOutputStream)Streams.byteArrayOfString((String)task.getStderr()), (int)1024);
                if (onFailingTask == OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL) {
                    Tasks.markInessential();
                }
                if (onFailingTask == OnFailingTask.FAIL || onFailingTask == OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL) {
                    throw new IllegalStateException("Passwordless sudo is required for " + task.getMachine().getUser() + "@" + task.getMachine().getAddress().getHostName() + (entity != null ? " (" + entity + ")" : ""));
                }
                return false;
            }
        });
    }

    public static Function<ProcessTaskWrapper<?>, String> returningStdoutLoggingInfo(final Logger logger, final boolean requireZero) {
        return new Function<ProcessTaskWrapper<?>, String>(){

            public String apply(@Nullable ProcessTaskWrapper<?> input) {
                if (logger != null) {
                    logger.info(input + " COMMANDS:\n" + Strings.join(input.getCommands(), (String)"\n"));
                }
                if (logger != null) {
                    logger.info(input + " STDOUT:\n" + input.getStdout());
                }
                if (logger != null) {
                    logger.info(input + " STDERR:\n" + input.getStderr());
                }
                if (requireZero && input.getExitCode() != 0) {
                    throw new IllegalStateException("non-zero exit code in " + input.getSummary() + ": see log for more details!");
                }
                return input.getStdout();
            }
        };
    }

    public static TaskFactory<?> installFromUrl(SshMachineLocation location, String url, String destPath) {
        return SshTasks.installFromUrl(ResourceUtils.create(SshTasks.class), ImmutableMap.of(), location, url, destPath);
    }

    public static TaskFactory<?> installFromUrl(final ResourceUtils utils, final Map<String, ?> props, final SshMachineLocation location, final String url, final String destPath) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                return Tasks.builder().name("installing " + Urls.getBasename((String)url)).description("installing " + url + " to " + destPath).body(new Runnable(){

                    @Override
                    public void run() {
                        int result = location.installTo(utils, props, url, destPath);
                        if (result != 0) {
                            throw new IllegalStateException("Failed to install '" + url + "' to '" + destPath + "' at " + location + ": exit code " + result);
                        }
                    }
                }).build();
            }
        };
    }

    @Beta
    public static enum OnFailingTask {
        FAIL,
        WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL,
        WARN_IN_LOG_ONLY,
        IGNORE;

    }
}

