/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task.ssh;

import brooklyn.management.Task;
import brooklyn.management.TaskWrapper;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.ssh.SshPutTaskFactory;
import brooklyn.util.task.ssh.SshPutTaskStub;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SshPutTaskWrapper
extends SshPutTaskStub
implements TaskWrapper<Void> {
    private static final Logger log = LoggerFactory.getLogger(SshPutTaskWrapper.class);
    private final Task<Void> task;
    protected Integer exitCodeOfCopy = null;
    protected Exception exception = null;
    protected boolean successful = false;

    SshPutTaskWrapper(SshPutTaskFactory constructor) {
        super(constructor);
        TaskBuilder<Void> tb = TaskBuilder.builder().dynamic(false).name(this.getSummary());
        this.task = tb.body(new SshPutJob()).build();
    }

    public Task<Void> asTask() {
        return this.getTask();
    }

    public Task<Void> getTask() {
        return this.task;
    }

    public String toString() {
        return super.toString() + "[" + this.task + "]";
    }

    public Void get() {
        return (Void)this.getTask().getUnchecked();
    }

    public Integer getExitCode() {
        return this.exitCodeOfCopy;
    }

    public Exception getException() {
        return this.exception;
    }

    public SshPutTaskWrapper block() {
        this.getTask().blockUntilEnded();
        return this;
    }

    public boolean isDone() {
        return this.getTask().isDone();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    private class SshPutJob
    implements Callable<Void> {
        private SshPutJob() {
        }

        @Override
        public Void call() throws Exception {
            try {
                Preconditions.checkNotNull((Object)SshPutTaskWrapper.this.getMachine(), (Object)"machine");
                String remoteFile = SshPutTaskWrapper.this.getRemoteFile();
                if (SshPutTaskWrapper.this.createDirectory) {
                    String remoteDir = remoteFile;
                    int exitCodeOfCreate = -1;
                    try {
                        int li = remoteDir.lastIndexOf("/");
                        if (li >= 0) {
                            remoteDir = remoteDir.substring(0, li + 1);
                            exitCodeOfCreate = SshPutTaskWrapper.this.getMachine().execCommands("creating directory for " + SshPutTaskWrapper.this.getSummary(), Arrays.asList("mkdir -p " + remoteDir));
                        } else {
                            exitCodeOfCreate = 0;
                        }
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("SSH put " + SshPutTaskWrapper.this.getRemoteFile() + " (create dir, in task " + SshPutTaskWrapper.this.getSummary() + ") to " + SshPutTaskWrapper.this.getMachine() + " threw exception: " + e);
                        }
                        SshPutTaskWrapper.this.exception = e;
                    }
                    if (SshPutTaskWrapper.this.exception != null || !Integer.valueOf(0).equals(exitCodeOfCreate)) {
                        if (!SshPutTaskWrapper.this.allowFailure) {
                            if (SshPutTaskWrapper.this.exception != null) {
                                throw new IllegalStateException(SshPutTaskWrapper.this.getSummary() + " (creating dir " + remoteDir + " for SSH put task) ended with exception, in " + Tasks.current() + ": " + SshPutTaskWrapper.this.exception, SshPutTaskWrapper.this.exception);
                            }
                            if (exitCodeOfCreate != 0) {
                                SshPutTaskWrapper.this.exception = new IllegalStateException(SshPutTaskWrapper.this.getSummary() + " (creating dir " + remoteDir + " SSH put task) ended with exit code " + exitCodeOfCreate + ", in " + Tasks.current());
                                throw SshPutTaskWrapper.this.exception;
                            }
                        }
                        return null;
                    }
                }
                ConfigBag config = ConfigBag.newInstanceCopying(SshPutTaskWrapper.this.getConfig());
                if (SshPutTaskWrapper.this.permissions != null) {
                    config.put(SshTool.PROP_PERMISSIONS, SshPutTaskWrapper.this.permissions);
                }
                SshPutTaskWrapper.this.exitCodeOfCopy = SshPutTaskWrapper.this.getMachine().copyTo(config.getAllConfig(), (InputStream)SshPutTaskWrapper.this.contents.get(), remoteFile);
                if (log.isDebugEnabled()) {
                    log.debug("SSH put " + SshPutTaskWrapper.this.getRemoteFile() + " (task " + SshPutTaskWrapper.this.getSummary() + ") to " + SshPutTaskWrapper.this.getMachine() + " completed with exit code " + SshPutTaskWrapper.this.exitCodeOfCopy);
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("SSH put " + SshPutTaskWrapper.this.getRemoteFile() + " (task " + SshPutTaskWrapper.this.getSummary() + ") to " + SshPutTaskWrapper.this.getMachine() + " threw exception: " + e);
                }
                SshPutTaskWrapper.this.exception = e;
            }
            if (SshPutTaskWrapper.this.exception != null || !Integer.valueOf(0).equals(SshPutTaskWrapper.this.exitCodeOfCopy)) {
                if (!SshPutTaskWrapper.this.allowFailure) {
                    if (SshPutTaskWrapper.this.exception != null) {
                        throw new IllegalStateException(SshPutTaskWrapper.this.getSummary() + " (SSH put task) ended with exception, in " + Tasks.current() + ": " + SshPutTaskWrapper.this.exception, SshPutTaskWrapper.this.exception);
                    }
                    if (SshPutTaskWrapper.this.exitCodeOfCopy != 0) {
                        SshPutTaskWrapper.this.exception = new IllegalStateException(SshPutTaskWrapper.this.getSummary() + " (SSH put task) ended with exit code " + SshPutTaskWrapper.this.exitCodeOfCopy + ", in " + Tasks.current());
                        throw SshPutTaskWrapper.this.exception;
                    }
                }
                return null;
            }
            SshPutTaskWrapper.this.successful = SshPutTaskWrapper.this.exception == null && Integer.valueOf(0).equals(SshPutTaskWrapper.this.exitCodeOfCopy);
            return null;
        }
    }
}

