/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task.ssh;

import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.Task;
import brooklyn.management.TaskWrapper;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.os.Os;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.ssh.SshFetchTaskFactory;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

@Beta
public class SshFetchTaskWrapper
implements TaskWrapper<String> {
    private final Task<String> task;
    private final String remoteFile;
    private final SshMachineLocation machine;
    private File backingFile;
    private final ConfigBag config;

    SshFetchTaskWrapper(SshFetchTaskFactory factory) {
        this.remoteFile = (String)Preconditions.checkNotNull((Object)factory.remoteFile, (Object)"remoteFile");
        this.machine = (SshMachineLocation)Preconditions.checkNotNull((Object)factory.machine, (Object)"machine");
        TaskBuilder<String> tb = TaskBuilder.builder().dynamic(false).name("ssh fetch " + factory.remoteFile);
        this.task = tb.body(new SshFetchJob()).build();
        this.config = factory.getConfig();
    }

    public Task<String> asTask() {
        return this.getTask();
    }

    public Task<String> getTask() {
        return this.task;
    }

    public String getRemoteFile() {
        return this.remoteFile;
    }

    public SshMachineLocation getMachine() {
        return this.machine;
    }

    public String toString() {
        return super.toString() + "[" + this.task + "]";
    }

    public String get() {
        return (String)this.getTask().getUnchecked();
    }

    public byte[] getBytes() {
        this.block();
        try {
            return FileUtils.readFileToByteArray((File)this.backingFile);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public SshFetchTaskWrapper block() {
        this.getTask().blockUntilEnded();
        return this;
    }

    public boolean isDone() {
        return this.getTask().isDone();
    }

    private class SshFetchJob
    implements Callable<String> {
        private SshFetchJob() {
        }

        @Override
        public String call() throws Exception {
            int result = -1;
            try {
                Preconditions.checkNotNull((Object)SshFetchTaskWrapper.this.getMachine(), (Object)"machine");
                SshFetchTaskWrapper.this.backingFile = Os.newTempFile((String)"brooklyn-ssh-fetch-", (String)FilenameUtils.getName((String)SshFetchTaskWrapper.this.remoteFile));
                SshFetchTaskWrapper.this.backingFile.deleteOnExit();
                result = SshFetchTaskWrapper.this.getMachine().copyFrom(SshFetchTaskWrapper.this.config.getAllConfig(), SshFetchTaskWrapper.this.remoteFile, SshFetchTaskWrapper.this.backingFile.getPath());
            }
            catch (Exception e) {
                throw new IllegalStateException("SSH fetch " + SshFetchTaskWrapper.this.getRemoteFile() + " from " + SshFetchTaskWrapper.this.getMachine() + " returned threw exception, in " + Tasks.current() + ": " + e, e);
            }
            if (result != 0) {
                throw new IllegalStateException("SSH fetch " + SshFetchTaskWrapper.this.getRemoteFile() + " from " + SshFetchTaskWrapper.this.getMachine() + " returned non-zero exit code  " + result + ", in " + Tasks.current());
            }
            return FileUtils.readFileToString((File)SshFetchTaskWrapper.this.backingFile);
        }
    }
}

