/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.management.ExecutionContext;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.DeferredSupplier;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Durations;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueResolver<T>
implements DeferredSupplier<T> {
    private static final Logger log = LoggerFactory.getLogger(ValueResolver.class);
    final Object value;
    final Class<T> type;
    ExecutionContext exec;
    String description;
    boolean forceDeep;
    Boolean embedResolutionInTask;
    Duration timeout;
    T defaultValue = null;
    boolean returnDefaultOnGet = false;
    boolean swallowExceptions = false;
    final Object parentOriginalValue;
    final CountdownTimer parentTimer;
    AtomicBoolean started = new AtomicBoolean(false);
    boolean expired;

    ValueResolver(Object v, Class<T> type) {
        this.value = v;
        this.type = type;
        this.checkTypeNotNull();
        this.parentOriginalValue = null;
        this.parentTimer = null;
    }

    ValueResolver(Object v, Class<T> type, ValueResolver<?> parent) {
        this.value = v;
        this.type = type;
        this.checkTypeNotNull();
        this.exec = parent.exec;
        this.description = parent.description;
        this.forceDeep = parent.forceDeep;
        this.embedResolutionInTask = parent.embedResolutionInTask;
        this.parentOriginalValue = parent.getOriginalValue();
        this.timeout = parent.timeout;
        this.parentTimer = parent.parentTimer;
        if (this.parentTimer != null && this.parentTimer.isExpired()) {
            this.expired = true;
        }
    }

    public ValueResolver<T> clone() {
        ValueResolver<T> result = new ValueResolver<T>(this.value, this.type).context(this.exec).description(this.description).embedResolutionInTask(this.embedResolutionInTask).deep(this.forceDeep).timeout(this.timeout);
        if (this.returnDefaultOnGet) {
            result.defaultValue(this.defaultValue);
        }
        if (this.swallowExceptions) {
            result.swallowExceptions();
        }
        return result;
    }

    public ValueResolver<T> context(ExecutionContext exec) {
        this.exec = exec;
        return this;
    }

    public ValueResolver<T> description(String description) {
        this.description = description;
        return this;
    }

    public ValueResolver<T> defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        this.returnDefaultOnGet = true;
        return this;
    }

    public ValueResolver<T> noDefaultValue() {
        this.returnDefaultOnGet = false;
        this.defaultValue = null;
        return this;
    }

    public ValueResolver<T> swallowExceptions() {
        this.swallowExceptions = true;
        return this;
    }

    public Maybe<T> getDefault() {
        if (this.returnDefaultOnGet) {
            return Maybe.of(this.defaultValue);
        }
        return Maybe.absent((String)"No default value set");
    }

    public ValueResolver<T> deep(boolean forceDeep) {
        this.forceDeep = forceDeep;
        return this;
    }

    public ValueResolver<T> embedResolutionInTask(Boolean embedResolutionInTask) {
        this.embedResolutionInTask = embedResolutionInTask;
        return this;
    }

    public ValueResolver<T> timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    protected void checkTypeNotNull() {
        if (this.type == null) {
            throw new NullPointerException("type must be set to resolve, for '" + this.value + "'" + (this.description != null ? ", " + this.description : ""));
        }
    }

    @Override
    public T get() {
        Maybe<T> m = this.getMaybe();
        if (m.isPresent()) {
            return (T)m.get();
        }
        if (this.returnDefaultOnGet) {
            return this.defaultValue;
        }
        return (T)m.get();
    }

    public Maybe<T> getMaybe() {
        Object v;
        block31: {
            CountdownTimer timer;
            if (this.started.getAndSet(true)) {
                throw new IllegalStateException("ValueResolver can only be used once");
            }
            if (this.expired) {
                return Maybe.absent((String)("Nested resolution of " + this.getOriginalValue() + " did not complete within " + this.timeout));
            }
            CountdownTimer timerU = this.parentTimer;
            if (timerU == null && this.timeout != null) {
                timerU = this.timeout.countdownTimer();
            }
            if ((timer = timerU) != null && !timer.isRunning()) {
                timer.start();
            }
            this.checkTypeNotNull();
            v = this.value;
            if (v == null || !this.forceDeep && this.type.isInstance(v) && !Future.class.isInstance(v) && !DeferredSupplier.class.isInstance(v)) {
                return Maybe.of((Object)v);
            }
            try {
                if (v instanceof TaskAdaptable && !((TaskAdaptable)v).asTask().isSubmitted()) {
                    if (this.exec == null) {
                        return Maybe.absent((String)("Value for unsubmitted task '" + this.getDescription() + "' requested but no execution context available"));
                    }
                    this.exec.submit((TaskAdaptable)((TaskAdaptable)v).asTask());
                }
                if (v instanceof Future) {
                    final Future vfuture = (Future)v;
                    if (!vfuture.isDone()) {
                        Callable<Maybe> callable = new Callable<Maybe>(){

                            @Override
                            public Maybe call() throws Exception {
                                return Durations.get((Future)vfuture, (CountdownTimer)timer);
                            }
                        };
                        String description = this.getDescription();
                        Maybe vm = Tasks.withBlockingDetails("Waiting for " + description, callable);
                        if (vm.isAbsent()) {
                            return vm;
                        }
                        v = vm.get();
                    } else {
                        v = vfuture.get();
                    }
                    break block31;
                }
                if (v instanceof DeferredSupplier) {
                    final Object vf = v;
                    Callable<Object> callable = new Callable<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws Exception {
                            try {
                                Tasks.setBlockingDetails("Retrieving " + vf);
                                Object t = ((DeferredSupplier)vf).get();
                                return t;
                            }
                            finally {
                                Tasks.resetBlockingDetails();
                            }
                        }
                    };
                    if (Boolean.TRUE.equals(this.embedResolutionInTask) || this.timeout != null) {
                        if (this.exec == null) {
                            return Maybe.absent((String)("Embedding in task needed for '" + this.getDescription() + "' but no execution context available"));
                        }
                        String description = this.getDescription();
                        Task vt = this.exec.submit(Tasks.builder().body(callable).name("Resolving dependent value").description(description).build());
                        Maybe vm = Durations.get((Future)vt, (CountdownTimer)timer);
                        vt.cancel(true);
                        if (vm.isAbsent()) {
                            return vm;
                        }
                        v = vm.get();
                    } else {
                        v = callable.call();
                    }
                    break block31;
                }
                if (v instanceof Map) {
                    LinkedHashMap result = Maps.newLinkedHashMap();
                    for (Map.Entry entry : ((Map)v).entrySet()) {
                        Maybe<T> kk = new ValueResolver<T>(entry.getKey(), this.type, this).description((this.description != null ? this.description + ", " : "") + "map key " + entry.getKey()).getMaybe();
                        if (kk.isAbsent()) {
                            return kk;
                        }
                        Maybe<T> vv = new ValueResolver<T>(entry.getValue(), this.type, this).description((this.description != null ? this.description + ", " : "") + "map value for key " + kk.get()).getMaybe();
                        if (vv.isAbsent()) {
                            return vv;
                        }
                        result.put(kk.get(), vv.get());
                    }
                    return Maybe.of((Object)result);
                }
                if (v instanceof Set) {
                    LinkedHashSet result = Sets.newLinkedHashSet();
                    int count = 0;
                    for (Object it : (Set)v) {
                        Maybe<T> vv = new ValueResolver<T>(it, this.type, this).description((this.description != null ? this.description + ", " : "") + "entry " + count).getMaybe();
                        if (vv.isAbsent()) {
                            return vv;
                        }
                        result.add(vv.get());
                        ++count;
                    }
                    return Maybe.of((Object)result);
                }
                if (v instanceof Iterable) {
                    ArrayList result = Lists.newArrayList();
                    int count = 0;
                    for (Object it : (Iterable)v) {
                        Maybe<T> vv = new ValueResolver<T>(it, this.type, this).description((this.description != null ? this.description + ", " : "") + "entry " + count).getMaybe();
                        if (vv.isAbsent()) {
                            return vv;
                        }
                        result.add(vv.get());
                        ++count;
                    }
                    return Maybe.of((Object)result);
                }
                return TypeCoercions.tryCoerce(v, TypeToken.of(this.type));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                IllegalArgumentException problem = new IllegalArgumentException("Error resolving " + (this.description != null ? this.description + ", " : "") + v + ", in " + this.exec + ": " + e, e);
                if (this.swallowExceptions) {
                    if (log.isDebugEnabled()) {
                        log.debug("Resolution of " + this + " failed, swallowing and returning: " + e);
                    }
                    return Maybe.absent((Throwable)problem);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Resolution of " + this + " failed, throwing: " + e);
                }
                throw problem;
            }
        }
        return new ValueResolver<T>(v, this.type, this).getMaybe();
    }

    protected String getDescription() {
        return this.description != null ? this.description : "" + this.value;
    }

    protected Object getOriginalValue() {
        if (this.parentOriginalValue != null) {
            return this.parentOriginalValue;
        }
        return this.value;
    }

    public static class ResolverBuilderPretype {
        final Object v;

        public ResolverBuilderPretype(Object v) {
            this.v = v;
        }

        public <T> ValueResolver<T> as(Class<T> type) {
            return new ValueResolver<T>(this.v, type);
        }
    }
}

