/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.management.ExecutionContext;
import brooklyn.management.HasTaskChildren;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.management.TaskQueueingContext;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.ReferenceWithError;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.task.BasicExecutionManager;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.ScheduledTask;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.TaskInternal;
import brooklyn.util.task.TaskTags;
import brooklyn.util.task.ValueResolver;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tasks {
    private static final Logger log = LoggerFactory.getLogger(Tasks.class);

    public static String setBlockingDetails(String description) {
        Task current = Tasks.current();
        if (current instanceof TaskInternal) {
            return ((TaskInternal)current).setBlockingDetails(description);
        }
        return null;
    }

    public static void resetBlockingDetails() {
        Task current = Tasks.current();
        if (current instanceof TaskInternal) {
            ((TaskInternal)current).resetBlockingDetails();
        }
    }

    public static Task<?> setBlockingTask(Task<?> blocker) {
        Task current = Tasks.current();
        if (current instanceof TaskInternal) {
            return ((TaskInternal)current).setBlockingTask(blocker);
        }
        return null;
    }

    public static void resetBlockingTask() {
        Task current = Tasks.current();
        if (current instanceof TaskInternal) {
            ((TaskInternal)current).resetBlockingTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withBlockingDetails(String description, Callable<T> code) throws Exception {
        Task current = Tasks.current();
        if (code == null) {
            log.warn("legacy invocation of withBlockingDetails with null code block, ignoring");
            return null;
        }
        String prevBlockingDetails = null;
        if (current instanceof TaskInternal) {
            prevBlockingDetails = ((TaskInternal)current).setBlockingDetails(description);
        }
        try {
            T t = code.call();
            return t;
        }
        finally {
            if (current instanceof TaskInternal) {
                ((TaskInternal)current).setBlockingDetails(prevBlockingDetails);
            }
        }
    }

    public static Task current() {
        return Tasks.getFinalProxyTarget(BasicExecutionManager.getPerThreadCurrentTask().get());
    }

    public static Task<?> getFinalProxyTarget(Task<?> task) {
        if (task == null) {
            return null;
        }
        Task<?> proxy = ((TaskInternal)task).getProxyTarget();
        if (proxy == null || proxy.equals(task)) {
            return task;
        }
        return Tasks.getFinalProxyTarget(proxy);
    }

    public static <T> ValueResolver<T> resolving(Object v, Class<T> type) {
        return new ValueResolver<T>(v, type);
    }

    public static ValueResolver.ResolverBuilderPretype resolving(Object v) {
        return new ValueResolver.ResolverBuilderPretype(v);
    }

    public static <T> T resolveValue(Object v, Class<T> type, @Nullable ExecutionContext exec) throws ExecutionException, InterruptedException {
        return new ValueResolver<T>(v, type).context(exec).get();
    }

    public static <T> T resolveValue(Object v, Class<T> type, @Nullable ExecutionContext exec, String contextMessage) throws ExecutionException, InterruptedException {
        return new ValueResolver<T>(v, type).context(exec).description(contextMessage).get();
    }

    public static Object resolveDeepValue(Object v, Class<?> type, ExecutionContext exec) throws ExecutionException, InterruptedException {
        return Tasks.resolveDeepValue(v, type, exec, null);
    }

    public static <T> T resolveDeepValue(Object v, Class<T> type, ExecutionContext exec, String contextMessage) throws ExecutionException, InterruptedException {
        return new ValueResolver<T>(v, type).context(exec).deep(true).description(contextMessage).get();
    }

    public static void setExtraStatusDetails(String notes) {
        Task current = Tasks.current();
        if (current instanceof TaskInternal) {
            ((TaskInternal)current).setExtraStatusText(notes);
        }
    }

    public static <T> TaskBuilder<T> builder() {
        return TaskBuilder.builder();
    }

    private static Task<?>[] asTasks(TaskAdaptable<?> ... tasks) {
        Task[] result = new Task[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            result[i] = tasks[i].asTask();
        }
        return result;
    }

    public static Task<List<?>> parallel(TaskAdaptable<?> ... tasks) {
        return Tasks.parallelInternal("parallelised tasks", Tasks.asTasks(tasks));
    }

    public static Task<List<?>> parallel(String name, TaskAdaptable<?> ... tasks) {
        return Tasks.parallelInternal(name, Tasks.asTasks(tasks));
    }

    public static Task<List<?>> parallel(Iterable<? extends TaskAdaptable<?>> tasks) {
        return Tasks.parallel(Tasks.asTasks((TaskAdaptable[])Iterables.toArray(tasks, TaskAdaptable.class)));
    }

    public static Task<List<?>> parallel(String name, Iterable<? extends TaskAdaptable<?>> tasks) {
        return Tasks.parallelInternal(name, Tasks.asTasks((TaskAdaptable[])Iterables.toArray(tasks, TaskAdaptable.class)));
    }

    private static Task<List<?>> parallelInternal(String name, Task<?>[] tasks) {
        return Tasks.builder().name(name).parallel(true).add((TaskAdaptable<?>[])tasks).build();
    }

    public static Task<List<?>> sequential(TaskAdaptable<?> ... tasks) {
        return Tasks.sequentialInternal("sequential tasks", Tasks.asTasks(tasks));
    }

    public static Task<List<?>> sequential(String name, TaskAdaptable<?> ... tasks) {
        return Tasks.sequentialInternal(name, Tasks.asTasks(tasks));
    }

    public static TaskFactory<?> sequential(TaskFactory<?> ... taskFactories) {
        return Tasks.sequentialInternal("sequential tasks", taskFactories);
    }

    public static TaskFactory<?> sequential(String name, TaskFactory<?> ... taskFactories) {
        return Tasks.sequentialInternal(name, taskFactories);
    }

    public static Task<List<?>> sequential(List<? extends TaskAdaptable<?>> tasks) {
        return Tasks.sequential(Tasks.asTasks((TaskAdaptable[])Iterables.toArray(tasks, TaskAdaptable.class)));
    }

    public static Task<List<?>> sequential(String name, List<? extends TaskAdaptable<?>> tasks) {
        return Tasks.sequential(name, Tasks.asTasks((TaskAdaptable[])Iterables.toArray(tasks, TaskAdaptable.class)));
    }

    private static Task<List<?>> sequentialInternal(String name, Task<?>[] tasks) {
        return Tasks.builder().name(name).parallel(false).add((TaskAdaptable<?>[])tasks).build();
    }

    private static TaskFactory<?> sequentialInternal(final String name, final TaskFactory<?> ... taskFactories) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                TaskBuilder tb = Tasks.builder().name(name).parallel(false);
                for (TaskFactory tf : taskFactories) {
                    tb.add((TaskAdaptable<?>)tf.newTask().asTask());
                }
                return tb.build();
            }
        };
    }

    public static <T> T tag(@Nullable Task<?> task, Class<T> type, boolean recurseHierarchy) {
        if (task == null) {
            return null;
        }
        for (Object tag : task.getTags()) {
            if (!type.isInstance(tag)) continue;
            return (T)tag;
        }
        if (!recurseHierarchy) {
            return null;
        }
        return Tasks.tag(task.getSubmittedByTask(), type, true);
    }

    public static boolean isAncestorCancelled(Task<?> t) {
        if (t == null) {
            return false;
        }
        if (t.isCancelled()) {
            return true;
        }
        return Tasks.isAncestorCancelled(t.getSubmittedByTask());
    }

    public static boolean isQueued(TaskAdaptable<?> task) {
        return ((TaskInternal)task.asTask()).isQueued();
    }

    public static boolean isSubmitted(TaskAdaptable<?> task) {
        return ((TaskInternal)task.asTask()).isSubmitted();
    }

    public static boolean isQueuedOrSubmitted(TaskAdaptable<?> task) {
        return ((TaskInternal)task.asTask()).isQueuedOrSubmitted();
    }

    public static boolean tryQueueing(TaskQueueingContext adder, TaskAdaptable<?> task) {
        if (task == null || Tasks.isQueued(task)) {
            return false;
        }
        try {
            adder.queue(task.asTask());
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Could not add task " + task + " at " + adder + ": " + e);
            }
            return false;
        }
    }

    public static <T> Supplier<T> supplier(final TaskAdaptable<T> task) {
        return new Supplier<T>(){

            public T get() {
                return task.asTask().getUnchecked();
            }
        };
    }

    public static Iterable<Task<?>> children(Task<?> task) {
        if (task instanceof HasTaskChildren) {
            return ((HasTaskChildren)task).getChildren();
        }
        return Collections.emptyList();
    }

    public static Iterable<Task<?>> failed(Iterable<Task<?>> subtasks) {
        return Iterables.filter(subtasks, (Predicate)new Predicate<Task<?>>(){

            public boolean apply(Task<?> input) {
                return input.isError();
            }
        });
    }

    public static Iterable<Task<?>> descendants(Task<?> root, final boolean parentFirst) {
        Iterable descs = Iterables.concat((Iterable)Iterables.transform(Tasks.children(root), (Function)new Function<Task<?>, Iterable<Task<?>>>(){

            public Iterable<Task<?>> apply(Task<?> input) {
                return Tasks.descendants(input, parentFirst);
            }
        }));
        if (parentFirst) {
            return Iterables.concat(Collections.singleton(root), (Iterable)descs);
        }
        return Iterables.concat((Iterable)descs, Collections.singleton(root));
    }

    public static Throwable getError(Task<?> t) {
        if (t == null) {
            return null;
        }
        if (!t.isDone()) {
            return null;
        }
        if (t.isCancelled()) {
            return new CancellationException();
        }
        try {
            t.get();
            return null;
        }
        catch (Throwable error) {
            return error;
        }
    }

    public static Task<Void> fail(final String name, final Throwable optionalError) {
        return Tasks.builder().dynamic(false).name(name).body(new Runnable(){

            @Override
            public void run() {
                if (optionalError != null) {
                    throw Exceptions.propagate((Throwable)optionalError);
                }
                throw new RuntimeException("Failed: " + name);
            }
        }).build();
    }

    public static Task<Void> warning(String message, Throwable optionalError) {
        log.warn(message);
        return TaskTags.markInessential(Tasks.fail(message, optionalError));
    }

    public static void markInessential() {
        TaskQueueingContext qc;
        Task task = Tasks.current();
        if (task == null && (qc = DynamicTasks.getTaskQueuingContext()) != null) {
            task = qc.asTask();
        }
        if (task != null) {
            TaskTags.markInessential(task);
        }
    }

    @Beta
    public static void swallowChildrenFailures() {
        Preconditions.checkNotNull((Object)DynamicTasks.getTaskQueuingContext(), (Object)"Task queueing context required here");
        TaskQueueingContext qc = DynamicTasks.getTaskQueuingContext();
        if (qc != null) {
            qc.swallowChildrenFailures();
        }
    }

    public static void addTagDynamically(Object tag) {
        Task t = Tasks.current();
        if (t != null) {
            TaskTags.addTagDynamically(t, tag);
        }
    }

    @Beta
    public static boolean blockUntilInternalTasksEnded(Task<?> t, Duration timeout) {
        boolean result;
        CountdownTimer timer = timeout.countdownTimer();
        if (t == null) {
            return true;
        }
        if (t instanceof ScheduledTask && !(result = ((ScheduledTask)t).blockUntilNextRunFinished(timer.getDurationRemaining()))) {
            return false;
        }
        t.blockUntilEnded(timer.getDurationRemaining());
        while (t.getEndTimeUtc() < 0L) {
            Thread tt = t.getThread();
            if (t instanceof ScheduledTask) {
                ((ScheduledTask)t).blockUntilNextRunFinished(timer.getDurationRemaining());
                return true;
            }
            if (tt == null || !tt.isAlive()) {
                if (!t.isCancelled()) {
                    log.warn("Internal task thread is dead or null (" + tt + ") but task not ended: " + t.getEndTimeUtc() + " (" + t + ")");
                }
                return true;
            }
            if (timer.isExpired()) {
                return false;
            }
            Time.sleep((Duration)Duration.millis((Number)10));
        }
        return true;
    }

    public static boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            return true;
        }
        Task t = Tasks.current();
        if (t == null) {
            return false;
        }
        return t.isCancelled();
    }

    public static TaskBuilder<Boolean> testing(Repeater repeater) {
        return Tasks.builder().body(new WaitForRepeaterCallable(repeater, false)).name("waiting for condition").description("Testing whether " + Tasks.getTimeoutString(repeater) + ": " + repeater.getDescription());
    }

    public static TaskBuilder<?> requiring(Repeater repeater) {
        return Tasks.builder().body(new WaitForRepeaterCallable(repeater, true)).name("waiting for condition").description("Requiring " + Tasks.getTimeoutString(repeater) + ": " + repeater.getDescription());
    }

    private static String getTimeoutString(Repeater repeater) {
        Duration timeout = repeater.getTimeLimit();
        if (timeout == null || Duration.PRACTICALLY_FOREVER.equals((Object)timeout)) {
            return "eventually";
        }
        return "in " + timeout;
    }

    private static class WaitForRepeaterCallable
    implements Callable<Boolean> {
        protected Repeater repeater;
        protected boolean requireTrue;

        public WaitForRepeaterCallable(Repeater repeater, boolean requireTrue) {
            this.repeater = repeater;
            this.requireTrue = requireTrue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            ReferenceWithError result;
            Tasks.setBlockingDetails(this.repeater.getDescription());
            try {
                result = this.repeater.runKeepingError();
            }
            finally {
                Tasks.resetBlockingDetails();
            }
            if (Boolean.TRUE.equals(result.getWithoutError())) {
                return true;
            }
            if (result.hasError()) {
                throw Exceptions.propagate((Throwable)result.getError());
            }
            if (this.requireTrue) {
                throw new IllegalStateException("timeout - " + this.repeater.getDescription());
            }
            return false;
        }
    }
}

