/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.util.task.CanSetName;
import brooklyn.util.task.TaskScheduler;
import brooklyn.util.task.Tasks;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadedScheduler
implements TaskScheduler,
CanSetName {
    private static final Logger LOG = LoggerFactory.getLogger(SingleThreadedScheduler.class);
    private final Queue<QueuedSubmission<?>> order = new ConcurrentLinkedQueue();
    private int queueSize = 0;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ExecutorService executor;
    private String name;
    int lastSizeWarn = 0;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name != null ? "SingleThreadedScheduler[" + this.name + "]" : super.toString();
    }

    @Override
    public void injectExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public synchronized <T> Future<T> submit(Callable<T> c) {
        if (this.running.compareAndSet(false, true)) {
            return this.executeNow(c);
        }
        WrappingFuture f = new WrappingFuture();
        this.order.add(new QueuedSubmission<T>(c, f));
        ++this.queueSize;
        if (this.queueSize > 0 && (this.queueSize == 50 || this.queueSize <= 500 && this.queueSize % 100 == 0 || this.queueSize % 1000 == 0) && this.queueSize != this.lastSizeWarn) {
            LOG.warn("{} is backing up, {} tasks queued", (Object)this, (Object)this.queueSize);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Task queue backing up detail, queue " + this + "; task context is " + Tasks.current() + "; latest task is " + c + "; first task is " + this.order.peek());
            }
            this.lastSizeWarn = this.queueSize;
        }
        return f;
    }

    private synchronized void onEnd() {
        boolean done = false;
        while (!done) {
            if (this.order.isEmpty()) {
                this.running.set(false);
                done = true;
                continue;
            }
            QueuedSubmission<?> qs = this.order.remove();
            --this.queueSize;
            if (qs.f.isCancelled()) continue;
            Future future = this.executeNow(qs.c);
            qs.f.setDelegate(future);
            done = true;
        }
    }

    private synchronized <T> Future<T> executeNow(final Callable<T> c) {
        return this.executor.submit(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                try {
                    Object v = c.call();
                    return v;
                }
                finally {
                    SingleThreadedScheduler.this.onEnd();
                }
            }
        });
    }

    private static class WrappingFuture<T>
    implements Future<T> {
        private volatile Future<T> delegate;
        private boolean cancelled;

        private WrappingFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDelegate(Future<T> delegate) {
            WrappingFuture wrappingFuture = this;
            synchronized (wrappingFuture) {
                this.delegate = delegate;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.delegate != null) {
                return this.delegate.cancel(mayInterruptIfRunning);
            }
            this.cancelled = true;
            WrappingFuture wrappingFuture = this;
            synchronized (wrappingFuture) {
                this.notifyAll();
            }
            return true;
        }

        @Override
        public boolean isCancelled() {
            if (this.delegate != null) {
                return this.delegate.isCancelled();
            }
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.delegate != null ? this.delegate.isDone() : this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws CancellationException, ExecutionException, InterruptedException {
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.delegate != null) {
                return this.delegate.get();
            }
            WrappingFuture wrappingFuture = this;
            synchronized (wrappingFuture) {
                while (this.delegate == null && !this.cancelled) {
                    this.wait();
                }
            }
            return this.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
            long endtime = System.currentTimeMillis() + unit.toMillis(timeout);
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.delegate != null) {
                return this.delegate.get(timeout, unit);
            }
            if (System.currentTimeMillis() >= endtime) {
                throw new TimeoutException();
            }
            WrappingFuture wrappingFuture = this;
            synchronized (wrappingFuture) {
                while (this.delegate == null && !this.cancelled && System.currentTimeMillis() < endtime) {
                    long remaining = endtime - System.currentTimeMillis();
                    if (remaining <= 0L) continue;
                    this.wait(remaining);
                }
            }
            long remaining = endtime - System.currentTimeMillis();
            return this.get(remaining, TimeUnit.MILLISECONDS);
        }
    }

    private static class QueuedSubmission<T> {
        final Callable<T> c;
        final WrappingFuture<T> f;

        QueuedSubmission(Callable<T> c, WrappingFuture<T> f) {
            this.c = c;
            this.f = f;
        }

        public String toString() {
            return "QueuedSubmission[" + this.c + "]@" + Integer.toHexString(System.identityHashCode(this));
        }
    }
}

