/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.task.CompoundTask;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class SequentialTask<T>
extends CompoundTask<T> {
    public SequentialTask(Object ... tasks) {
        super(tasks);
    }

    public SequentialTask(Map<String, ?> flags, Collection<? extends Object> tasks) {
        super(flags, tasks);
    }

    public SequentialTask(Collection<? extends Object> tasks) {
        super(tasks);
    }

    public SequentialTask(Map<String, ?> flags, Iterable<? extends Object> tasks) {
        super(flags, (Collection<?>)ImmutableList.copyOf(tasks));
    }

    public SequentialTask(Iterable<? extends Object> tasks) {
        super((Collection<?>)ImmutableList.copyOf(tasks));
    }

    @Override
    protected List<T> runJobs() throws InterruptedException, ExecutionException {
        this.setBlockingDetails("Executing " + (this.children.size() == 1 ? "1 child task" : this.children.size() + " children tasks sequentially"));
        ArrayList<Object> result = new ArrayList<Object>();
        for (Task task : this.children) {
            this.submitIfNecessary((TaskAdaptable<?>)task);
            result.add(task.get());
        }
        return result;
    }
}

