/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.management.Task;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.task.BasicTask;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledTask
extends BasicTask {
    final Callable<Task<?>> taskFactory;
    protected Duration delay;
    protected Duration period = null;
    protected Integer maxIterations = null;
    protected int runCount = 0;
    protected Task<?> recentRun;
    protected Task<?> nextRun;

    public int getRunCount() {
        return this.runCount;
    }

    public ScheduledFuture<?> getNextScheduled() {
        return (ScheduledFuture)this.internalFuture;
    }

    public ScheduledTask(Callable<Task<?>> taskFactory) {
        this((Map)MutableMap.of(), taskFactory);
    }

    public ScheduledTask(Task<?> task) {
        this((Map)MutableMap.of(), task);
    }

    public ScheduledTask(Map flags, final Task<?> task) {
        this(flags, new Callable<Task<?>>(){

            @Override
            public Task<?> call() throws Exception {
                return task;
            }
        });
    }

    public ScheduledTask(Map flags, Callable<Task<?>> taskFactory) {
        super(flags);
        this.taskFactory = taskFactory;
        this.delay = Duration.of((Object)GroovyJavaMethods.elvis(flags.remove("delay"), (Object)0));
        this.period = Duration.of((Object)GroovyJavaMethods.elvis(flags.remove("period"), null));
        this.maxIterations = (Integer)GroovyJavaMethods.elvis(flags.remove("maxIterations"), null);
    }

    public ScheduledTask delay(Duration d) {
        this.delay = d;
        return this;
    }

    public ScheduledTask delay(long val) {
        return this.delay(Duration.millis((Number)val));
    }

    public ScheduledTask period(Duration d) {
        this.period = d;
        return this;
    }

    public ScheduledTask period(long val) {
        return this.period(Duration.millis((Number)val));
    }

    public ScheduledTask maxIterations(int val) {
        this.maxIterations = val;
        return this;
    }

    public Callable<Task<?>> getTaskFactory() {
        return this.taskFactory;
    }

    public Task<?> newTask() {
        try {
            return this.taskFactory.call();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected String getActiveTaskStatusString(int verbosity) {
        StringBuilder rv = new StringBuilder("Scheduler");
        if (this.runCount > 0) {
            rv.append(", iteration " + (this.runCount + 1));
        }
        if (this.recentRun != null) {
            rv.append(", last run " + Duration.sinceUtc((long)this.recentRun.getStartTimeUtc()) + " ms ago");
        }
        if (GroovyJavaMethods.truth(this.getNextScheduled())) {
            Duration untilNext = Duration.millis((Number)this.getNextScheduled().getDelay(TimeUnit.MILLISECONDS));
            if (untilNext.isPositive()) {
                rv.append(", next in " + untilNext);
            } else {
                rv.append(", next imminent");
            }
        }
        return rv.toString();
    }

    @Override
    public boolean isDone() {
        return this.isCancelled() || this.maxIterations != null && this.maxIterations <= this.runCount || this.period == null && this.nextRun != null && this.nextRun.isDone();
    }

    public synchronized void blockUntilFirstScheduleStarted() {
        do {
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            if (this.recentRun != null) continue;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Throwables.propagate((Throwable)e);
            }
        } while (this.recentRun == null);
    }

    @Override
    public void blockUntilEnded() {
        while (!this.isDone()) {
            super.blockUntilEnded();
        }
    }

    public Object get() throws InterruptedException, ExecutionException {
        this.blockUntilStarted();
        this.blockUntilFirstScheduleStarted();
        return GroovyJavaMethods.truth(this.recentRun) ? this.recentRun.get() : this.internalFuture.get();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterrupt) {
        boolean result = super.cancel(mayInterrupt);
        if (this.nextRun != null) {
            this.nextRun.cancel(mayInterrupt);
            this.notifyAll();
        }
        return result;
    }

    @Beta
    public boolean blockUntilNextRunFinished(Duration timeout) {
        return Tasks.blockUntilInternalTasksEnded(this.nextRun, timeout);
    }
}

