/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.management.HasTaskChildren;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.task.BasicExecutionContext;
import brooklyn.util.task.BasicTask;
import brooklyn.util.task.TaskInternal;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompoundTask<T>
extends BasicTask<List<T>>
implements HasTaskChildren {
    private static final Logger log = LoggerFactory.getLogger(CompoundTask.class);
    protected final List<Task<? extends T>> children;
    protected final List<Object> result;

    public CompoundTask(Object ... jobs) {
        this(Arrays.asList(jobs));
    }

    public CompoundTask(Collection<?> jobs) {
        this((Map<String, ?>)MutableMap.of((Object)"tag", (Object)"compound"), jobs);
    }

    public CompoundTask(Map<String, ?> flags, Collection<?> jobs) {
        super(flags);
        this.job = new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                return CompoundTask.this.runJobs();
            }
        };
        this.result = new ArrayList<Object>(jobs.size());
        this.children = new ArrayList<Task<? extends T>>(jobs.size());
        for (Object job : jobs) {
            BasicTask subtask;
            if (job instanceof TaskAdaptable) {
                subtask = ((TaskAdaptable)job).asTask();
            } else if (job instanceof Closure) {
                subtask = new BasicTask((Closure)job);
            } else if (job instanceof Callable) {
                subtask = new BasicTask((Callable)job);
            } else if (job instanceof Runnable) {
                subtask = new BasicTask((Runnable)job);
            } else {
                throw new IllegalArgumentException("Invalid child " + (job == null ? null : job.getClass() + " (" + job + ")") + " passed to compound task; must be Runnable, Callable, Closure or Task");
            }
            BrooklynTaskTags.addTagDynamically(subtask, "SUB-TASK");
            this.children.add(subtask);
        }
        for (Task t : this.getChildren()) {
            ((TaskInternal)t).markQueued();
        }
    }

    protected abstract List<T> runJobs() throws InterruptedException, ExecutionException;

    protected void submitIfNecessary(TaskAdaptable<?> task) {
        if (!task.asTask().isSubmitted()) {
            if (BasicExecutionContext.getCurrentExecutionContext() == null) {
                throw new IllegalStateException("Compound task (" + task + ") launched from " + this + " missing required execution context");
            }
            BasicExecutionContext.getCurrentExecutionContext().submit(task);
        }
    }

    public List<Task<? extends T>> getChildrenTyped() {
        return this.children;
    }

    public List<Task<?>> getChildren() {
        return this.getChildrenTyped();
    }
}

