/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.management.ExecutionManager;
import brooklyn.management.HasTaskChildren;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableList;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.BasicExecutionContext;
import brooklyn.util.task.BasicTask;
import brooklyn.util.task.CanSetName;
import brooklyn.util.task.ExecutionListener;
import brooklyn.util.task.ExecutionUtils;
import brooklyn.util.task.ListenableForwardingFuture;
import brooklyn.util.task.ScheduledTask;
import brooklyn.util.task.TaskInternal;
import brooklyn.util.task.TaskScheduler;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Identifiers;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutionManager
implements ExecutionManager {
    private static final Logger log = LoggerFactory.getLogger(BasicExecutionManager.class);
    private static final boolean RENAME_THREADS = BrooklynFeatureEnablement.isEnabled("brooklyn.executionManager.renameThreads");
    private final ThreadFactory threadFactory;
    private final ThreadFactory daemonThreadFactory;
    private final ExecutorService runner;
    private final ScheduledExecutorService delayedRunner;
    private Map<Object, Set<Task<?>>> tasksByTag = new HashMap();
    private ConcurrentMap<String, Task<?>> tasksById = new ConcurrentHashMap();
    private ConcurrentMap<Object, TaskScheduler> schedulerByTag = new ConcurrentHashMap<Object, TaskScheduler>();
    private final AtomicLong totalTaskCount = new AtomicLong();
    private Map<String, String> incompleteTaskIds = new ConcurrentHashMap<String, String>();
    private final AtomicInteger activeTaskCount = new AtomicInteger();
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private static final ThreadLocal<String> threadOriginalName = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            log.warn("No original name recorded for thread " + Thread.currentThread().getName() + "; task " + Tasks.current());
            return "brooklyn-thread-pool-" + Identifiers.makeRandomId((int)8);
        }
    };

    public static ThreadLocal<Task<?>> getPerThreadCurrentTask() {
        return PerThreadCurrentTaskHolder.perThreadCurrentTask;
    }

    public BasicExecutionManager(String contextid) {
        this.threadFactory = this.newThreadFactory(contextid);
        this.daemonThreadFactory = new ThreadFactoryBuilder().setThreadFactory(this.threadFactory).setDaemon(true).build();
        this.runner = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.daemonThreadFactory);
        this.delayedRunner = new ScheduledThreadPoolExecutor(1, this.daemonThreadFactory);
    }

    protected ThreadFactory newThreadFactory(String contextid) {
        return new ThreadFactoryBuilder().setNameFormat("brooklyn-execmanager-" + contextid + "-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionHandlerImplementation()).build();
    }

    public void shutdownNow() {
        this.runner.shutdownNow();
        this.delayedRunner.shutdownNow();
    }

    public void addListener(ExecutionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ExecutionListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTag(Object tag) {
        Set<Task<?>> tasks;
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            tasks = this.tasksByTag.remove(tag);
        }
        if (tasks != null) {
            for (Task<?> task : tasks) {
                this.deleteTask(task);
            }
        }
    }

    public void deleteTask(Task<?> task) {
        boolean removed = this.deleteTaskNonRecursive(task);
        if (!removed) {
            return;
        }
        if (task instanceof HasTaskChildren) {
            ImmutableList children = ImmutableList.copyOf((Iterable)((HasTaskChildren)task).getChildren());
            for (Task child : children) {
                this.deleteTask(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteTaskNonRecursive(Task<?> task) {
        Set tags = ((Task)Preconditions.checkNotNull(task, (Object)"task")).getTags();
        for (Object tag : tags) {
            Map<Object, Set<Task<?>>> map = this.tasksByTag;
            synchronized (map) {
                Set<Task<?>> tasks = this.tasksWithTagLiveOrNull(tag);
                if (tasks != null) {
                    tasks.remove(task);
                    if (tasks.isEmpty()) {
                        this.tasksByTag.remove(tag);
                    }
                }
            }
        }
        Task removed = (Task)this.tasksById.remove(task.getId());
        this.incompleteTaskIds.remove(task.getId());
        if (removed != null && removed.isSubmitted() && !removed.isDone()) {
            log.warn("Deleting submitted task before completion: " + removed + "; this task will continue to run in the background outwith " + this + ", but perhaps it should have been cancelled?");
        }
        return removed != null;
    }

    public boolean isShutdown() {
        return this.runner.isShutdown();
    }

    public long getTotalTasksSubmitted() {
        return this.totalTaskCount.get();
    }

    public long getNumIncompleteTasks() {
        return this.incompleteTaskIds.size();
    }

    public long getNumActiveTasks() {
        return this.activeTaskCount.get();
    }

    public long getNumInMemoryTasks() {
        return this.tasksById.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Task<?>> tasksWithTagCreating(Object tag) {
        Preconditions.checkNotNull((Object)tag);
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            Set<Object> result = this.tasksWithTagLiveOrNull(tag);
            if (result == null) {
                result = Collections.synchronizedSet(new LinkedHashSet());
                this.tasksByTag.put(tag, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public Set<Task<?>> tasksWithTagLiveOrNull(Object tag) {
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            return this.tasksByTag.get(tag);
        }
    }

    public Task<?> getTask(String id) {
        return (Task)this.tasksById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task<?>> getAllTasks() {
        ConcurrentMap<String, Task<?>> concurrentMap = this.tasksById;
        synchronized (concurrentMap) {
            return MutableList.copyOf(this.tasksById.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Task<?>> getTasksWithTag(Object tag) {
        Set<Task<?>> result = this.tasksWithTagLiveOrNull(tag);
        if (result == null) {
            return Collections.emptySet();
        }
        Set<Task<?>> set = result;
        synchronized (set) {
            return Collections.unmodifiableSet(new LinkedHashSet(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Task<?>> getTasksWithAnyTag(Iterable<?> tags) {
        LinkedHashSet result = new LinkedHashSet();
        Iterator<?> ti = tags.iterator();
        while (ti.hasNext()) {
            Set<Task<?>> tasksForTag = this.tasksWithTagLiveOrNull(ti.next());
            if (tasksForTag == null) continue;
            Set<Task<?>> set = tasksForTag;
            synchronized (set) {
                result.addAll(tasksForTag);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Task<?>> getTasksWithAllTags(Iterable<?> tags) {
        LinkedHashSet result = new LinkedHashSet();
        boolean first = true;
        for (Object tag : tags) {
            if (first) {
                first = false;
                result.addAll(this.getTasksWithTag(tag));
                continue;
            }
            result.retainAll(this.getTasksWithTag(tag));
        }
        return Collections.unmodifiableSet(result);
    }

    @Beta
    public Collection<Task<?>> allTasksLive() {
        return this.tasksById.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getTaskTags() {
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            return Collections.unmodifiableSet(Sets.newLinkedHashSet(this.tasksByTag.keySet()));
        }
    }

    public Task<?> submit(Runnable r) {
        return this.submit(new LinkedHashMap(1), r);
    }

    public Task<?> submit(Map<?, ?> flags, Runnable r) {
        return this.submit(flags, (TaskAdaptable)new BasicTask(flags, r));
    }

    public <T> Task<T> submit(Callable<T> c) {
        return this.submit(new LinkedHashMap(1), c);
    }

    public <T> Task<T> submit(Map<?, ?> flags, Callable<T> c) {
        return this.submit(flags, (TaskAdaptable<T>)new BasicTask<T>(flags, c));
    }

    public <T> Task<T> submit(TaskAdaptable<T> t) {
        return this.submit(new LinkedHashMap(1), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> submit(Map<?, ?> flags, TaskAdaptable<T> task) {
        if (!(task instanceof Task)) {
            task = task.asTask();
        }
        Task task2 = task;
        synchronized (task2) {
            if (((TaskInternal)task).getInternalFuture() != null) {
                return task;
            }
            return this.submitNewTask(flags, task);
        }
    }

    public <T> Task<T> scheduleWith(Task<T> task) {
        return this.scheduleWith(Collections.emptyMap(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> scheduleWith(Map<?, ?> flags, Task<T> task) {
        Task<T> task2 = task;
        synchronized (task2) {
            if (((TaskInternal)task).getInternalFuture() != null) {
                return task;
            }
            return this.submitNewTask(flags, task);
        }
    }

    protected Task<?> submitNewScheduledTask(Map<?, ?> flags, ScheduledTask task) {
        this.tasksById.put(task.getId(), task);
        this.totalTaskCount.incrementAndGet();
        this.beforeSubmitScheduledTaskAllIterations(flags, task);
        return this.submitSubsequentScheduledTask(flags, task);
    }

    protected Task<?> submitSubsequentScheduledTask(Map<?, ?> flags, ScheduledTask task) {
        if (!task.isDone()) {
            task.internalFuture = this.delayedRunner.schedule(new ScheduledTaskCallable(task, flags), task.delay.toNanoseconds(), TimeUnit.NANOSECONDS);
        } else {
            this.afterEndScheduledTaskAllIterations(flags, task);
        }
        return task;
    }

    protected <T> Task<T> submitNewTask(Map<?, ?> flags, Task<T> task) {
        Future future;
        if (task instanceof ScheduledTask) {
            return this.submitNewScheduledTask(flags, (ScheduledTask)task);
        }
        this.tasksById.put(task.getId(), task);
        this.totalTaskCount.incrementAndGet();
        this.beforeSubmitAtomicTask(flags, task);
        if (((TaskInternal)task).getJob() == null) {
            throw new NullPointerException("Task " + task + " submitted with with null job: job must be supplied.");
        }
        SubmissionCallable job = new SubmissionCallable(flags, task);
        LinkedHashSet<TaskScheduler> schedulers = null;
        for (Object tago : task.getTags()) {
            TaskScheduler scheduler = this.getTaskSchedulerForTag(tago);
            if (scheduler == null) continue;
            if (schedulers == null) {
                schedulers = new LinkedHashSet<TaskScheduler>(2);
            }
            schedulers.add(scheduler);
        }
        if (schedulers != null && !schedulers.isEmpty()) {
            if (schedulers.size() > 1) {
                log.warn("multiple schedulers detected, using only the first, for " + task + ": " + schedulers);
            }
            future = ((TaskScheduler)schedulers.iterator().next()).submit(job);
        } else {
            future = this.runner.submit(job);
        }
        ListenableForwardingFutureForTask listenableFuture = new ListenableForwardingFutureForTask(future, ((TaskInternal)task).getListeners(), task);
        ((TaskInternal)task).addListener(new SubmissionListenerToCallOtherListeners(task), this.runner);
        ((TaskInternal)task).initInternalFuture(listenableFuture);
        return task;
    }

    protected void beforeSubmitScheduledTaskAllIterations(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeSubmit(flags, task);
    }

    protected void beforeSubmitAtomicTask(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeSubmit(flags, task);
    }

    protected void internalBeforeSubmit(Map<?, ?> flags, Task<?> task) {
        this.incompleteTaskIds.put(task.getId(), task.getId());
        Task currentTask = Tasks.current();
        if (currentTask != null) {
            ((TaskInternal)task).setSubmittedByTask(currentTask);
        }
        ((TaskInternal)task).setSubmitTimeUtc(System.currentTimeMillis());
        if (flags.get("tag") != null) {
            ((TaskInternal)task).getMutableTags().add(flags.remove("tag"));
        }
        if (flags.get("tags") != null) {
            ((TaskInternal)task).getMutableTags().addAll((Collection)flags.remove("tags"));
        }
        for (Object tag : ((TaskInternal)task).getTags()) {
            this.tasksWithTagCreating(tag).add(task);
        }
    }

    protected void beforeStartScheduledTaskSubmissionIteration(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeStart(flags, task);
    }

    protected void beforeStartAtomicTask(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeStart(flags, task);
    }

    protected void internalBeforeStart(Map<?, ?> flags, Task<?> task) {
        this.activeTaskCount.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("" + this + " beforeStart, task: " + task);
        }
        if (!task.isCancelled()) {
            Thread thread = Thread.currentThread();
            ((TaskInternal)task).setThread(thread);
            if (RENAME_THREADS) {
                threadOriginalName.set(thread.getName());
                String newThreadName = "brooklyn-" + CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, task.getDisplayName().replace(" ", "")) + "-" + task.getId().substring(0, 8);
                thread.setName(newThreadName);
            }
            PerThreadCurrentTaskHolder.perThreadCurrentTask.set(task);
            ((TaskInternal)task).setStartTimeUtc(System.currentTimeMillis());
        }
        ExecutionUtils.invoke(flags.get("newTaskStartCallback"), task);
    }

    protected void afterEndScheduledTaskAllIterations(Map<?, ?> flags, Task<?> task) {
        this.internalAfterEnd(flags, task, false, true);
    }

    protected void afterEndScheduledTaskSubmissionIteration(Map<?, ?> flags, Task<?> scheduledTask, Task<?> taskIteration) {
        this.internalAfterEnd(flags, scheduledTask, true, false);
    }

    protected void afterEndAtomicTask(Map<?, ?> flags, Task<?> task) {
        this.internalAfterEnd(flags, task, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalAfterEnd(Map<?, ?> flags, Task<?> task, boolean startedInThisThread, boolean isEndingAllIterations) {
        if (log.isTraceEnabled()) {
            log.trace(this + " afterEnd, task: " + task);
        }
        if (startedInThisThread) {
            this.activeTaskCount.decrementAndGet();
        }
        if (isEndingAllIterations) {
            this.incompleteTaskIds.remove(task.getId());
            ExecutionUtils.invoke(flags.get("newTaskEndCallback"), task);
            ((TaskInternal)task).setEndTimeUtc(System.currentTimeMillis());
        }
        if (startedInThisThread) {
            PerThreadCurrentTaskHolder.perThreadCurrentTask.remove();
            if (RENAME_THREADS && startedInThisThread) {
                Thread thread = task.getThread();
                if (thread == null) {
                    log.warn("BasicTask.afterEnd invoked without corresponding beforeStart");
                } else {
                    thread.setName(threadOriginalName.get());
                    threadOriginalName.remove();
                }
            }
            ((TaskInternal)task).setThread(null);
        }
        Task<?> task2 = task;
        synchronized (task2) {
            task.notifyAll();
        }
    }

    public TaskScheduler getTaskSchedulerForTag(Object tag) {
        return (TaskScheduler)this.schedulerByTag.get(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskSchedulerForTag(Object tag, Class<? extends TaskScheduler> scheduler) {
        ConcurrentMap<Object, TaskScheduler> concurrentMap = this.schedulerByTag;
        synchronized (concurrentMap) {
            TaskScheduler old = this.getTaskSchedulerForTag(tag);
            if (old != null) {
                if (scheduler.isAssignableFrom(old.getClass())) {
                    return;
                }
                throw new IllegalStateException("Not allowed to set multiple TaskSchedulers on ExecutionManager tag (tag " + tag + ", has " + old + ", setting new " + scheduler + ")");
            }
            try {
                TaskScheduler schedulerI = scheduler.newInstance();
                if (schedulerI instanceof CanSetName) {
                    ((CanSetName)((Object)schedulerI)).setName("" + tag);
                }
                this.setTaskSchedulerForTag(tag, schedulerI);
            }
            catch (InstantiationException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskSchedulerForTag(Object tag, TaskScheduler scheduler) {
        ConcurrentMap<Object, TaskScheduler> concurrentMap = this.schedulerByTag;
        synchronized (concurrentMap) {
            scheduler.injectExecutor(this.runner);
            TaskScheduler old = this.schedulerByTag.put(tag, scheduler);
            if (old != null && old != scheduler) {
                throw new IllegalStateException("Not allowed to set multiple TaskSchedulers on ExecutionManager tag (tag " + tag + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTaskSchedulerForTag(Object tag) {
        ConcurrentMap<Object, TaskScheduler> concurrentMap = this.schedulerByTag;
        synchronized (concurrentMap) {
            Object old = this.schedulerByTag.remove(tag);
            return old != null;
        }
    }

    @VisibleForTesting
    public ConcurrentMap<Object, TaskScheduler> getSchedulerByTag() {
        return this.schedulerByTag;
    }

    private final class SubmissionListenerToCallOtherListeners<T>
    implements Runnable {
        private final Task<T> task;

        private SubmissionListenerToCallOtherListeners(Task<T> task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                ((TaskInternal)this.task).runListeners();
            }
            catch (Exception e) {
                log.warn("Error running task listeners for task " + this.task + " done", (Throwable)e);
            }
            for (ExecutionListener listener : BasicExecutionManager.this.listeners) {
                try {
                    listener.onTaskDone(this.task);
                }
                catch (Exception e) {
                    log.warn("Error running execution listener " + listener + " of task " + this.task + " done", (Throwable)e);
                }
            }
        }
    }

    private static final class ListenableForwardingFutureForTask<T>
    extends ListenableForwardingFuture<T> {
        private final Task<T> task;

        private ListenableForwardingFutureForTask(Future<T> delegate, ExecutionList list, Task<T> task) {
            super(delegate, list);
            this.task = task;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = false;
            if (!this.task.isCancelled()) {
                result |= this.task.cancel(mayInterruptIfRunning);
            }
            ((TaskInternal)this.task).runListeners();
            return result |= super.cancel(mayInterruptIfRunning);
        }
    }

    private final class SubmissionCallable<T>
    implements Callable<T> {
        private final Map<?, ?> flags;
        private final Task<T> task;

        private SubmissionCallable(Map<?, ?> flags, Task<T> task) {
            this.flags = flags;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() {
            try {
                Throwable error;
                T result;
                block14: {
                    result = null;
                    error = null;
                    String oldThreadName = Thread.currentThread().getName();
                    try {
                        if (RENAME_THREADS) {
                            String newThreadName = oldThreadName + "-" + this.task.getDisplayName() + "[" + this.task.getId().substring(0, 8) + "]";
                            Thread.currentThread().setName(newThreadName);
                        }
                        BasicExecutionManager.this.beforeStartAtomicTask(this.flags, this.task);
                        if (!this.task.isCancelled()) {
                            result = ((TaskInternal)this.task).getJob().call();
                            break block14;
                        }
                        throw new CancellationException();
                    }
                    catch (Throwable e) {
                        error = e;
                    }
                    finally {
                        if (RENAME_THREADS) {
                            Thread.currentThread().setName(oldThreadName);
                        }
                        BasicExecutionManager.this.afterEndAtomicTask(this.flags, this.task);
                    }
                }
                if (error != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exception running task " + this.task + " (rethrowing): " + error.getMessage(), error);
                        if (log.isTraceEnabled()) {
                            log.trace("Trace for exception running task " + this.task + " (rethrowing): " + error.getMessage(), error);
                        }
                    }
                    throw Exceptions.propagate((Throwable)error);
                }
                T t = result;
                return t;
            }
            finally {
                ((TaskInternal)this.task).runListeners();
            }
        }

        public String toString() {
            return "BEM.call(" + this.task + "," + this.flags + ")";
        }
    }

    protected class ScheduledTaskCallable
    implements Callable<Object> {
        public ScheduledTask task;
        public Map<?, ?> flags;

        public ScheduledTaskCallable(ScheduledTask task, Map<?, ?> flags) {
            this.task = task;
            this.flags = flags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            if (this.task.startTimeUtc == -1L) {
                this.task.startTimeUtc = System.currentTimeMillis();
            }
            TaskInternal taskScheduled = null;
            try {
                BasicExecutionManager.this.beforeStartScheduledTaskSubmissionIteration(this.flags, this.task);
                taskScheduled = (TaskInternal)this.task.newTask();
                taskScheduled.setSubmittedByTask(this.task);
                final Callable oldJob = taskScheduled.getJob();
                final TaskInternal taskScheduledF = taskScheduled;
                taskScheduled.setJob(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() {
                        boolean resubmitted = false;
                        ScheduledTaskCallable.this.task.recentRun = taskScheduledF;
                        try {
                            Object result;
                            ScheduledTask scheduledTask = ScheduledTaskCallable.this.task;
                            synchronized (scheduledTask) {
                                ScheduledTaskCallable.this.task.notifyAll();
                            }
                            try {
                                result = oldJob.call();
                            }
                            catch (Exception e) {
                                if (!Tasks.isInterrupted()) {
                                    log.warn("Error executing " + oldJob + " (scheduled job of " + ScheduledTaskCallable.this.task + " - " + ScheduledTaskCallable.this.task.getDescription() + "); cancelling scheduled execution", (Throwable)e);
                                } else {
                                    log.debug("Interrupted executing " + oldJob + " (scheduled job of " + ScheduledTaskCallable.this.task + " - " + ScheduledTaskCallable.this.task.getDescription() + "); cancelling scheduled execution: " + e);
                                }
                                throw Exceptions.propagate((Throwable)e);
                            }
                            ++ScheduledTaskCallable.this.task.runCount;
                            if (ScheduledTaskCallable.this.task.period != null && !ScheduledTaskCallable.this.task.isCancelled()) {
                                ScheduledTaskCallable.this.task.delay = ScheduledTaskCallable.this.task.period;
                                BasicExecutionManager.this.submitSubsequentScheduledTask(ScheduledTaskCallable.this.flags, ScheduledTaskCallable.this.task);
                                resubmitted = true;
                            }
                            Object v = result;
                            return v;
                        }
                        finally {
                            if (!resubmitted) {
                                BasicExecutionManager.this.afterEndScheduledTaskAllIterations(ScheduledTaskCallable.this.flags, ScheduledTaskCallable.this.task);
                            }
                        }
                    }
                });
                this.task.nextRun = taskScheduled;
                BasicExecutionContext ec = BasicExecutionContext.getCurrentExecutionContext();
                if (ec != null) {
                    Task task = ec.submit(taskScheduled);
                    return task;
                }
                Task task = BasicExecutionManager.this.submit(taskScheduled);
                return task;
            }
            finally {
                BasicExecutionManager.this.afterEndScheduledTaskSubmissionIteration(this.flags, this.task, taskScheduled);
            }
        }

        public String toString() {
            return "ScheduledTaskCallable[" + this.task + "," + this.flags + "]";
        }
    }

    private static final class UncaughtExceptionHandlerImplementation
    implements Thread.UncaughtExceptionHandler {
        private UncaughtExceptionHandlerImplementation() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Uncaught exception in thread " + t.getName(), e);
        }
    }

    private static class PerThreadCurrentTaskHolder {
        public static final ThreadLocal<Task<?>> perThreadCurrentTask = new ThreadLocal();

        private PerThreadCurrentTaskHolder() {
        }
    }
}

