/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.management.ExecutionContext;
import brooklyn.management.ExecutionManager;
import brooklyn.management.HasTaskChildren;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.entitlement.EntitlementContext;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.util.task.AbstractExecutionContext;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.ExecutionUtils;
import brooklyn.util.task.Tasks;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutionContext
extends AbstractExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(BasicExecutionContext.class);
    static final ThreadLocal<BasicExecutionContext> perThreadExecutionContext = new ThreadLocal();
    final ExecutionManager executionManager;
    final Set<Object> tags = new LinkedHashSet<Object>();

    public static BasicExecutionContext getCurrentExecutionContext() {
        return perThreadExecutionContext.get();
    }

    public BasicExecutionContext(ExecutionManager executionManager) {
        this(Collections.emptyMap(), executionManager);
    }

    public BasicExecutionContext(Map<?, ?> flags, ExecutionManager executionManager) {
        this.executionManager = executionManager;
        if (flags.get("tag") != null) {
            this.tags.add(flags.remove("tag"));
        }
        if (flags.containsKey("tags")) {
            this.tags.addAll((Collection)flags.remove("tags"));
        }
        for (Object tag : this.tags) {
            if (!(tag instanceof BrooklynTaskTags.WrappedEntity) || !Proxy.isProxyClass(((BrooklynTaskTags.WrappedEntity)tag).entity.getClass())) continue;
            log.warn("" + this + " has entity proxy in " + tag);
        }
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public Set<Task<?>> getTasks() {
        return this.executionManager.getTasksWithAllTags(this.tags);
    }

    @Override
    protected <T> Task<T> submitInternal(Map<?, ?> propertiesQ, final Object task) {
        EntitlementContext entitlementContext;
        Entity target;
        if (task instanceof TaskAdaptable && !(task instanceof Task)) {
            return this.submitInternal(propertiesQ, ((TaskAdaptable)task).asTask());
        }
        Map<?, ?> properties = propertiesQ;
        if (properties.get("tags") == null) {
            properties.put("tags", new ArrayList());
        }
        Collection taskTags = (Collection)properties.get("tags");
        if (task instanceof Task) {
            taskTags.addAll(((Task)task).getTags());
        }
        if ((target = BrooklynTaskTags.getWrappedEntityOfType(taskTags, "targetEntity")) != null && !this.tags.contains(BrooklynTaskTags.tagForContextEntity(target))) {
            ExecutionContext tc = ((EntityInternal)target).getExecutionContext();
            if (log.isDebugEnabled()) {
                log.debug("Switching task context on execution of " + task + ": from " + this + " to " + target + " (in " + Tasks.current() + ")");
            }
            if (task instanceof Task) {
                final Task t = (Task)task;
                if (!(Tasks.isQueuedOrSubmitted(t) || Tasks.current() instanceof HasTaskChildren && Iterables.contains((Iterable)((HasTaskChildren)Tasks.current()).getChildren(), (Object)t))) {
                    return this.submit(Tasks.builder().name("Cross-context execution: " + t.getDescription()).dynamic(true).body(new Callable<T>(){

                        @Override
                        public T call() {
                            return DynamicTasks.get(t);
                        }
                    }).build());
                }
                return tc.submit((TaskAdaptable)t);
            }
            this.submit(Tasks.builder().name("Cross-context execution").dynamic(true).body(new Callable<T>(){

                @Override
                public T call() {
                    if (task instanceof Callable) {
                        return DynamicTasks.queue(Tasks.builder().dynamic(false).body((Callable)task).build()).getUnchecked();
                    }
                    if (task instanceof Runnable) {
                        return DynamicTasks.queue(Tasks.builder().dynamic(false).body((Runnable)task).build()).getUnchecked();
                    }
                    throw new IllegalArgumentException("Unhandled task type: " + task + "; type=" + (task != null ? task.getClass() : "null"));
                }
            }).build());
        }
        if ((entitlementContext = BrooklynTaskTags.getEntitlement(taskTags)) == null) {
            entitlementContext = Entitlements.getEntitlementContext();
        }
        if (entitlementContext != null) {
            taskTags.add(BrooklynTaskTags.tagForEntitlement(entitlementContext));
        }
        taskTags.addAll(this.tags);
        final Object startCallback = properties.get("newTaskStartCallback");
        properties.put("newTaskStartCallback", new Function<Object, Void>(){

            public Void apply(Object it) {
                BasicExecutionContext.this.registerPerThreadExecutionContext();
                if (startCallback != null) {
                    ExecutionUtils.invoke(startCallback, it);
                }
                return null;
            }
        });
        final Object endCallback = properties.get("newTaskEndCallback");
        properties.put("newTaskEndCallback", new Function<Object, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void apply(Object it) {
                try {
                    if (endCallback != null) {
                        ExecutionUtils.invoke(endCallback, it);
                    }
                }
                finally {
                    BasicExecutionContext.this.clearPerThreadExecutionContext();
                }
                return null;
            }
        });
        if (task instanceof Task) {
            return this.executionManager.submit(properties, (TaskAdaptable)((Task)task));
        }
        if (task instanceof Callable) {
            return this.executionManager.submit(properties, (Callable)task);
        }
        if (task instanceof Runnable) {
            return this.executionManager.submit(properties, (Runnable)task);
        }
        throw new IllegalArgumentException("Unhandled task type: task=" + task + "; type=" + (task != null ? task.getClass() : "null"));
    }

    private void registerPerThreadExecutionContext() {
        perThreadExecutionContext.set(this);
    }

    private void clearPerThreadExecutionContext() {
        perThreadExecutionContext.remove();
    }

    public boolean isShutdown() {
        return this.getExecutionManager().isShutdown();
    }

    public String toString() {
        return super.toString() + "(" + this.tags + ")";
    }
}

