/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.osgi;

import brooklyn.catalog.CatalogItem;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.ReferenceWithError;
import brooklyn.util.guava.Maybe;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.apache.felix.framework.FrameworkFactory;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class Osgis {
    private static final Logger LOG = LoggerFactory.getLogger(Osgis.class);
    private static final String EXTENSION_PROTOCOL = "system";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final Set<String> SYSTEM_BUNDLES = MutableSet.of();

    public static BundleFinder bundleFinder(Framework framework) {
        return new BundleFinder(framework);
    }

    @Deprecated
    public static List<Bundle> getBundlesByName(Framework framework, String symbolicName, Predicate<Version> versionMatcher) {
        return Osgis.bundleFinder(framework).symbolicName(symbolicName).version(versionMatcher).findAll();
    }

    @Deprecated
    public static List<Bundle> getBundlesByName(Framework framework, String symbolicName) {
        return Osgis.bundleFinder(framework).symbolicName(symbolicName).findAll();
    }

    @Deprecated
    public static Maybe<Bundle> getBundle(Framework framework, String symbolicNameOptionallyWithVersion) {
        return Osgis.bundleFinder(framework).id(symbolicNameOptionallyWithVersion).find();
    }

    @Deprecated
    public static Maybe<Bundle> getBundle(Framework framework, String symbolicName, String version) {
        return Osgis.bundleFinder(framework).symbolicName(symbolicName).version(version).find();
    }

    @Deprecated
    public static Maybe<Bundle> getBundle(Framework framework, String symbolicName, Version version) {
        return Osgis.bundleFinder(framework).symbolicName(symbolicName).version((Predicate<Version>)Predicates.equalTo((Object)version)).findUnique();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FrameworkFactory newFrameworkFactory() {
        URL url = Osgis.class.getClassLoader().getResource("META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        if (url == null) throw new IllegalStateException("Could not find framework factory.");
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String s = br.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
                        FrameworkFactory frameworkFactory = (FrameworkFactory)Class.forName(s).newInstance();
                        return frameworkFactory;
                    }
                    s = br.readLine();
                }
                throw new IllegalStateException("Could not find framework factory.");
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static Framework newFrameworkStarted(String felixCacheDir, boolean clean, Map<?, ?> extraStartupConfig) {
        MutableMap cfg = MutableMap.copyOf(extraStartupConfig);
        if (clean) {
            cfg.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        if (felixCacheDir != null) {
            cfg.put("org.osgi.framework.storage", felixCacheDir);
        }
        cfg.put("org.osgi.framework.bsnversion", "multiple");
        FrameworkFactory factory = Osgis.newFrameworkFactory();
        Stopwatch timer = Stopwatch.createStarted();
        Framework framework = factory.newFramework((Map)cfg);
        try {
            framework.init();
            Osgis.installBootBundles(framework);
            framework.start();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        LOG.debug("System bundles are: " + SYSTEM_BUNDLES);
        LOG.debug("OSGi framework started in " + Duration.of((Object)timer));
        return framework;
    }

    private static void installBootBundles(Framework framework) {
        Enumeration<URL> resources;
        Stopwatch timer = Stopwatch.createStarted();
        LOG.debug("Installing OSGi boot bundles from " + Osgis.class.getClassLoader() + "...");
        try {
            resources = Osgis.class.getClassLoader().getResources(MANIFEST_PATH);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        BundleContext bundleContext = framework.getBundleContext();
        Map<String, Bundle> installedBundles = Osgis.getInstalledBundlesById(bundleContext);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            ReferenceWithError<?> installResult = Osgis.installExtensionBundle(bundleContext, url, installedBundles, Osgis.getVersionedId((Bundle)framework));
            if (installResult.hasError() && !installResult.masksErrorIfPresent()) {
                LOG.warn("Unable to install manifest from " + url + ": " + installResult.getError(), installResult.getError());
                continue;
            }
            Object result = installResult.getWithoutError();
            if (result instanceof Bundle) {
                String v = Osgis.getVersionedId((Bundle)result);
                SYSTEM_BUNDLES.add(v);
                if (installResult.hasError()) {
                    LOG.debug(installResult.getError().getMessage() + (result != null ? " (" + result + "/" + v + ")" : ""));
                    continue;
                }
                LOG.debug("Installed " + v + " from " + url);
                continue;
            }
            if (!installResult.hasError()) continue;
            LOG.debug(installResult.getError().getMessage());
        }
        LOG.debug("Installed OSGi boot bundles in " + Time.makeTimeStringRounded((Stopwatch)timer) + ": " + Arrays.asList(framework.getBundleContext().getBundles()));
    }

    private static Map<String, Bundle> getInstalledBundlesById(BundleContext bundleContext) {
        Bundle[] bundles;
        HashMap<String, Bundle> installedBundles = new HashMap<String, Bundle>();
        for (Bundle b : bundles = bundleContext.getBundles()) {
            installedBundles.put(Osgis.getVersionedId(b), b);
        }
        return installedBundles;
    }

    private static ReferenceWithError<?> installExtensionBundle(BundleContext bundleContext, URL manifestUrl, Map<String, Bundle> installedBundles, String frameworkVersionedId) {
        if ("felix.extensions".equals(manifestUrl.getHost())) {
            return ReferenceWithError.newInstanceMaskingError(null, (Throwable)new IllegalArgumentException("Skipping install of internal extension bundle from " + manifestUrl));
        }
        try {
            Manifest manifest = Osgis.readManifest(manifestUrl);
            if (!Osgis.isValidBundle(manifest)) {
                return ReferenceWithError.newInstanceMaskingError(null, (Throwable)new IllegalArgumentException("Resource at " + manifestUrl + " is not an OSGi bundle: no valid manifest"));
            }
            String versionedId = Osgis.getVersionedId(manifest);
            URL bundleUrl = ResourceUtils.getContainerUrl(manifestUrl, MANIFEST_PATH);
            Bundle existingBundle = installedBundles.get(versionedId);
            if (existingBundle != null) {
                if (!bundleUrl.equals(existingBundle.getLocation()) && !versionedId.equals(frameworkVersionedId)) {
                    return ReferenceWithError.newInstanceMaskingError(null, (Throwable)new IllegalArgumentException("Bundle " + versionedId + " (from manifest " + manifestUrl + ") is already installed, from " + existingBundle.getLocation()));
                }
                return ReferenceWithError.newInstanceMaskingError((Object)existingBundle, (Throwable)new IllegalArgumentException("Bundle " + versionedId + " from manifest " + manifestUrl + " is already installed"));
            }
            byte[] jar = Osgis.buildExtensionBundle(manifest);
            LOG.debug("Installing boot bundle " + bundleUrl);
            Bundle newBundle = bundleContext.installBundle("system:" + bundleUrl.toString(), (InputStream)new ByteArrayInputStream(jar));
            installedBundles.put(versionedId, newBundle);
            return ReferenceWithError.newInstanceWithoutError((Object)newBundle);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return ReferenceWithError.newInstanceThrowingError(null, (Throwable)new IllegalStateException("Problem installing extension bundle " + manifestUrl + ": " + e, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest readManifest(URL manifestUrl) throws IOException {
        Manifest manifest;
        InputStream in = null;
        try {
            in = manifestUrl.openStream();
            manifest = new Manifest(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return manifest;
    }

    private static byte[] buildExtensionBundle(Manifest manifest) throws IOException {
        Attributes atts = manifest.getMainAttributes();
        atts.remove(new Attributes.Name("Import-Package"));
        atts.remove(new Attributes.Name("Require-Bundle"));
        atts.remove(new Attributes.Name("Bundle-NativeCode"));
        atts.remove(new Attributes.Name("DynamicImport-Package"));
        atts.remove(new Attributes.Name("Bundle-Activator"));
        atts.putValue("Fragment-Host", "system.bundle; extension:=framework");
        ByteArrayOutputStream jar = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream((OutputStream)jar, manifest);
        out.close();
        return jar.toByteArray();
    }

    private static boolean isValidBundle(Manifest manifest) {
        Attributes atts = manifest.getMainAttributes();
        return atts.containsKey(new Attributes.Name("Bundle-ManifestVersion"));
    }

    private static String getVersionedId(Bundle b) {
        return b.getSymbolicName() + ":" + b.getVersion();
    }

    private static String getVersionedId(Manifest manifest) {
        Attributes atts = manifest.getMainAttributes();
        return atts.getValue("Bundle-SymbolicName") + ":" + atts.getValue("Bundle-Version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle install(Framework framework, String url) throws BundleException {
        boolean isLocal = Osgis.isLocalUrl(url);
        String localUrl = url;
        if (!isLocal) {
            localUrl = Osgis.cacheFile(url);
        }
        try {
            Bundle installedBundle;
            Bundle bundle = Osgis.getInstalledBundle(framework, localUrl);
            if (bundle != null) {
                Bundle bundle2 = bundle;
                return bundle2;
            }
            LOG.debug("Installing bundle into {} from url: {}", (Object)framework, (Object)url);
            InputStream stream = Osgis.getUrlStream(localUrl);
            Bundle bundle3 = installedBundle = framework.getBundleContext().installBundle(url, stream);
            return bundle3;
        }
        finally {
            if (!isLocal) {
                try {
                    new File(new URI(localUrl)).delete();
                }
                catch (URISyntaxException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
    }

    private static String cacheFile(String url) {
        InputStream in = Osgis.getUrlStream(url);
        File cache = Os.writeToTempFile((InputStream)in, (String)"bundle-cache", (String)"jar");
        return cache.toURI().toString();
    }

    private static boolean isLocalUrl(String url) {
        String protocol = Urls.getProtocol((String)url);
        return "file".equals(protocol) || "classpath".equals(protocol) || "jar".equals(protocol);
    }

    private static Bundle getInstalledBundle(Framework framework, String url) {
        JarInputStream stream;
        Bundle bundle = framework.getBundleContext().getBundle(url);
        if (bundle != null) {
            return bundle;
        }
        try {
            stream = new JarInputStream(Osgis.getUrlStream(url));
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        Manifest manifest = stream.getManifest();
        Streams.closeQuietly((Closeable)stream);
        if (manifest == null) {
            throw new IllegalStateException("Missing manifest file in bundle or not a jar file.");
        }
        String versionedId = Osgis.getVersionedId(manifest);
        for (Bundle installedBundle : framework.getBundleContext().getBundles()) {
            if (!versionedId.equals(Osgis.getVersionedId(installedBundle))) continue;
            if (SYSTEM_BUNDLES.contains(versionedId)) {
                LOG.debug("Already have system bundle " + versionedId + " from " + installedBundle + "/" + installedBundle.getLocation() + " when requested " + url + "; not installing");
                return installedBundle;
            }
            LOG.debug("Already have bundle " + versionedId + " from " + installedBundle + "/" + installedBundle.getLocation() + " when requested " + url + "; but it is not a system bundle so proceeding");
        }
        return null;
    }

    private static InputStream getUrlStream(String url) {
        return ResourceUtils.create(Osgis.class).getResourceFromUrl(url);
    }

    public static boolean isExtensionBundle(Bundle bundle) {
        String location = bundle.getLocation();
        return location != null && EXTENSION_PROTOCOL.equals(Urls.getProtocol((String)location));
    }

    public static Maybe<VersionedName> parseOsgiIdentifier(String symbolicNameOptionalWithVersion) {
        if (Strings.isBlank((CharSequence)symbolicNameOptionalWithVersion)) {
            return Maybe.absent((String)"OSGi identifier is blank");
        }
        String[] parts = symbolicNameOptionalWithVersion.split(":");
        if (parts.length > 2) {
            return Maybe.absent((String)"OSGi identifier has too many parts; max one ':' symbol");
        }
        Version v = null;
        if (parts.length == 2) {
            try {
                v = Version.parseVersion((String)parts[1]);
            }
            catch (IllegalArgumentException e) {
                return Maybe.absent((String)("OSGi identifier has invalid version string (" + e.getMessage() + ")"));
            }
        }
        return Maybe.of((Object)new VersionedName(parts[0], v));
    }

    public static class ManifestHelper {
        private static ManifestParser parse;
        private Manifest manifest;
        private String source;
        private static final String WIRING_PACKAGE = "osgi.wiring.package";

        public static ManifestHelper forManifestContents(String contents) throws IOException, BundleException {
            ManifestHelper result = ManifestHelper.forManifest(Streams.newInputStreamWithContents((String)contents));
            result.source = contents;
            return result;
        }

        public static ManifestHelper forManifest(URL url) throws IOException, BundleException {
            InputStream in = url.openStream();
            ManifestHelper helper = ManifestHelper.forManifest(in);
            in.close();
            return helper;
        }

        public static ManifestHelper forManifest(InputStream in) throws IOException, BundleException {
            return ManifestHelper.forManifest(new Manifest(in));
        }

        public static ManifestHelper forManifest(Manifest manifest) throws BundleException {
            ManifestHelper result = new ManifestHelper();
            result.manifest = manifest;
            parse = new ManifestParser(null, null, null, (Map)new StringMap((Map)manifest.getMainAttributes()));
            return result;
        }

        public String getSymbolicName() {
            return parse.getSymbolicName();
        }

        public Version getVersion() {
            return parse.getBundleVersion();
        }

        public String getSymbolicNameVersion() {
            return this.getSymbolicName() + ":" + this.getVersion();
        }

        public List<String> getExportedPackages() {
            MutableList result = MutableList.of();
            for (BundleCapability c : parse.getCapabilities()) {
                if (!WIRING_PACKAGE.equals(c.getNamespace())) continue;
                result.add((Object)((String)c.getAttributes().get(WIRING_PACKAGE)));
            }
            return result;
        }

        @Nullable
        public String getSource() {
            return this.source;
        }

        public Manifest getManifest() {
            return this.manifest;
        }
    }

    public static class BundleFinder {
        protected final Framework framework;
        protected String symbolicName;
        protected String version;
        protected String url;
        protected boolean urlMandatory = false;
        protected final List<Predicate<? super Bundle>> predicates = MutableList.of();

        protected BundleFinder(Framework framework) {
            this.framework = framework;
        }

        public BundleFinder symbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return this;
        }

        public BundleFinder version(String version) {
            this.version = version;
            return this;
        }

        public BundleFinder id(String symbolicNameOptionallyWithVersion) {
            if (Strings.isBlank((CharSequence)symbolicNameOptionallyWithVersion)) {
                return this;
            }
            Maybe<VersionedName> nv = Osgis.parseOsgiIdentifier(symbolicNameOptionallyWithVersion);
            if (nv.isAbsent()) {
                throw new IllegalArgumentException("Cannot parse symbolic-name:version string '" + symbolicNameOptionallyWithVersion + "'");
            }
            return this.id((VersionedName)nv.get());
        }

        private BundleFinder id(VersionedName nv) {
            this.symbolicName(nv.getSymbolicName());
            if (nv.getVersion() != null) {
                this.version(nv.getVersion().toString());
            }
            return this;
        }

        public BundleFinder bundle(CatalogItem.CatalogBundle bundle) {
            if (bundle.isNamed()) {
                this.symbolicName(bundle.getSymbolicName());
                this.version(bundle.getVersion());
            }
            if (bundle.getUrl() != null) {
                this.requiringFromUrl(bundle.getUrl());
            }
            return this;
        }

        public BundleFinder preferringFromUrl(String url) {
            this.url = url;
            this.urlMandatory = false;
            return this;
        }

        public BundleFinder requiringFromUrl(String url) {
            this.url = url;
            this.urlMandatory = true;
            return this;
        }

        public Maybe<Bundle> find() {
            return this.findOne(false);
        }

        public Maybe<Bundle> findUnique() {
            return this.findOne(true);
        }

        protected Maybe<Bundle> findOne(boolean requireExactlyOne) {
            if (this.symbolicName == null && this.url == null) {
                throw new IllegalStateException(this + " must be given either a symbolic name or a URL");
            }
            List<Bundle> result = this.findAll();
            if (result.isEmpty()) {
                return Maybe.absent((String)("No bundle matching " + this.getConstraintsDescription()));
            }
            if (requireExactlyOne && result.size() > 1) {
                return Maybe.absent((String)("Multiple bundles (" + result.size() + ") matching " + this.getConstraintsDescription()));
            }
            return Maybe.of((Object)result.get(0));
        }

        public List<Bundle> findAll() {
            boolean urlMatched = false;
            MutableList result = MutableList.of();
            for (Bundle b : this.framework.getBundleContext().getBundles()) {
                if (this.symbolicName != null && !this.symbolicName.equals(b.getSymbolicName()) || this.version != null && !Version.parseVersion((String)this.version).equals((Object)b.getVersion())) continue;
                for (Predicate<? super Bundle> predicate : this.predicates) {
                    if (predicate.apply((Object)b)) continue;
                }
                if (this.url != null) {
                    boolean matches = this.url.equals(b.getLocation());
                    if (this.urlMandatory) {
                        if (!matches) continue;
                        urlMatched = true;
                    } else if (matches) {
                        if (!urlMatched) {
                            result.clear();
                            urlMatched = true;
                        }
                    } else if (urlMatched) continue;
                }
                result.add(b);
            }
            if (this.symbolicName == null && this.url != null && !urlMatched) {
                result.clear();
            }
            Collections.sort(result, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle o1, Bundle o2) {
                    return o2.getVersion().compareTo(o1.getVersion());
                }
            });
            return result;
        }

        public String getConstraintsDescription() {
            MutableList parts = MutableList.of();
            if (this.symbolicName != null) {
                parts.add("symbolicName=" + this.symbolicName);
            }
            if (this.version != null) {
                parts.add("version=" + this.version);
            }
            if (this.url != null) {
                parts.add("url[" + (this.urlMandatory ? "required" : "preferred") + "]=" + this.url);
            }
            if (!this.predicates.isEmpty()) {
                parts.add("predicates=" + this.predicates);
            }
            return Joiner.on((String)";").join((Iterable)parts);
        }

        public String toString() {
            return this.getClass().getCanonicalName() + "[" + this.getConstraintsDescription() + "]";
        }

        public BundleFinder version(final Predicate<Version> versionPredicate) {
            return this.satisfying((Predicate<? super Bundle>)new Predicate<Bundle>(){

                public boolean apply(Bundle input) {
                    return versionPredicate.apply((Object)input.getVersion());
                }
            });
        }

        public BundleFinder satisfying(Predicate<? super Bundle> predicate) {
            this.predicates.add(predicate);
            return this;
        }
    }

    public static class VersionedName {
        private final String symbolicName;
        private final Version version;

        public VersionedName(Bundle b) {
            this.symbolicName = b.getSymbolicName();
            this.version = b.getVersion();
        }

        public VersionedName(String symbolicName, Version version) {
            this.symbolicName = symbolicName;
            this.version = version;
        }

        public String toString() {
            return this.symbolicName + ":" + Strings.toString((Object)this.version);
        }

        public boolean equals(String sn, String v) {
            return this.symbolicName.equals(sn) && (this.version == null && v == null || this.version != null && this.version.toString().equals(v));
        }

        public boolean equals(String sn, Version v) {
            return this.symbolicName.equals(sn) && (this.version == null && v == null || this.version != null && this.version.equals((Object)v));
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public Version getVersion() {
            return this.version;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.version});
        }

        public boolean equals(Object other) {
            if (!(other instanceof VersionedName)) {
                return false;
            }
            VersionedName o = (VersionedName)other;
            return Objects.equal((Object)this.symbolicName, (Object)o.symbolicName) && Objects.equal((Object)this.version, (Object)o.version);
        }
    }
}

