/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.mutex;

import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.mutex.SemaphoreWithOwners;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;

public class SemaphoreForTasks
extends SemaphoreWithOwners {
    private static final long serialVersionUID = 7898283056223005952L;
    private final ManagementContext mgmt;
    private final MutableList<Task<?>> owningTasks = new MutableList();
    private final MutableSet<Task<?>> requestingTasks = new MutableSet();

    public SemaphoreForTasks(String name, ManagementContext mgmt) {
        super(name);
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt);
    }

    public SemaphoreForTasks(String name, int permits, boolean fair, ManagementContext mgmt) {
        super(name, permits, fair);
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt);
    }

    public synchronized Set<Task<?>> getRequestingTasks() {
        return ImmutableSet.copyOf(this.requestingTasks);
    }

    public synchronized List<Task<?>> getOwningTasks() {
        return ImmutableList.copyOf(this.owningTasks);
    }

    @Override
    protected synchronized void onRequesting() {
        if (!this.owningTasks.isEmpty() || !this.requestingTasks.isEmpty()) {
            Tasks.setBlockingTask(!this.requestingTasks.isEmpty() ? (Task)Iterables.getLast(this.requestingTasks) : (Task)Iterables.getFirst(this.owningTasks, null));
            Tasks.setBlockingDetails("Waiting on semaphore " + this.getName() + " (" + this.getDescription() + "); " + "queued at " + Time.makeDateString() + " when " + this.getRequestingThreads().size() + " ahead in queue");
        }
        this.requestingTasks.addIfNotNull((Object)Tasks.current());
        super.onRequesting();
    }

    @Override
    protected synchronized void onRequestFinished() {
        super.onRequestFinished();
        this.requestingTasks.removeIfNotNull((Object)Tasks.current());
        Tasks.resetBlockingDetails();
        Tasks.resetBlockingTask();
    }

    @Override
    protected synchronized void onAcquired(int permits) {
        super.onAcquired(permits);
        for (int i = 0; i < permits; ++i) {
            this.owningTasks.appendIfNotNull((Object)Tasks.current());
        }
    }

    @Override
    protected synchronized void onReleased(int permits) {
        super.onReleased(permits);
        for (int i = 0; i < permits; ++i) {
            this.owningTasks.removeIfNotNull((Object)Tasks.current());
        }
    }

    @Override
    public synchronized String toString() {
        return super.toString() + "[" + "owningTasks=" + this.owningTasks + "; requestingTasks=" + this.requestingTasks + "]";
    }
}

