/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import brooklyn.util.ResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;

public class UrlClassLoader
extends URLClassLoader {
    private URL[] urls;

    public UrlClassLoader(URL ... urls) {
        super(UrlClassLoader.tidy(urls));
        this.urls = urls;
    }

    public UrlClassLoader(String ... urls) {
        this(UrlClassLoader.asUrls(urls));
    }

    private static URL[] asUrls(String[] urls) {
        URL[] urlo = new URL[urls.length];
        try {
            for (int i = 0; i < urls.length; ++i) {
                urlo[i] = new URL(urls[i]);
            }
        }
        catch (MalformedURLException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return urlo;
    }

    private static URL[] tidy(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = ResourceUtils.tidy(urls[i]);
        }
        return urls;
    }

    public String toString() {
        return "UrlClassLoader" + Arrays.asList(this.urls);
    }
}

