/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.internal.ssh;

import brooklyn.util.internal.ssh.ShellAbstractTool;
import brooklyn.util.internal.ssh.ShellTool;
import brooklyn.util.internal.ssh.SshException;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Map;
import java.util.Set;

public abstract class SshAbstractTool
extends ShellAbstractTool
implements SshTool {
    protected final String toString;
    protected final String host;
    protected final String user;
    protected final String password;
    protected final int port;
    protected String privateKeyPassphrase;
    protected String privateKeyData;
    protected File privateKeyFile;
    protected boolean strictHostKeyChecking;
    protected boolean allocatePTY;

    protected SshAbstractTool(AbstractSshToolBuilder<?, ?> builder) {
        super(builder.localTempDir);
        this.host = (String)Preconditions.checkNotNull((Object)builder.host, (Object)"host");
        this.port = builder.port;
        this.user = builder.user;
        this.password = builder.password;
        this.strictHostKeyChecking = builder.strictHostKeyChecking;
        this.allocatePTY = builder.allocatePTY;
        this.privateKeyPassphrase = builder.privateKeyPassphrase;
        this.privateKeyData = builder.privateKeyData;
        if (builder.privateKeyFiles.size() > 1) {
            throw new IllegalArgumentException("sshj supports only a single private key-file; for defaults of ~/.ssh/id_rsa and ~/.ssh/id_dsa leave blank");
        }
        if (builder.privateKeyFiles.size() == 1) {
            String privateKeyFileStr = (String)Iterables.get(builder.privateKeyFiles, (int)0);
            String amendedKeyFile = privateKeyFileStr.startsWith("~") ? System.getProperty("user.home") + privateKeyFileStr.substring(1) : privateKeyFileStr;
            this.privateKeyFile = new File(amendedKeyFile);
        } else {
            this.privateKeyFile = null;
        }
        Preconditions.checkArgument((this.host.length() > 0 ? 1 : 0) != 0, (Object)"host value must not be an empty string");
        Networking.checkPortValid((Integer)this.port, (String)"ssh port");
        this.toString = String.format("%s@%s:%d", this.user, this.host, this.port);
    }

    public String toString() {
        return this.toString;
    }

    public String getHostAddress() {
        return this.host;
    }

    public String getUsername() {
        return this.user;
    }

    protected SshException propagate(Exception e, String message) throws SshException {
        throw new SshException("(" + this.toString() + ") " + message + ": " + e.getMessage(), e);
    }

    public static abstract class AbstractSshToolBuilder<T extends SshTool, B extends AbstractSshToolBuilder<T, B>> {
        protected String host;
        protected int port = 22;
        protected String user = System.getProperty("user.name");
        protected String password;
        protected String privateKeyData;
        protected String privateKeyPassphrase;
        protected Set<String> privateKeyFiles = Sets.newLinkedHashSet();
        protected boolean strictHostKeyChecking = false;
        protected boolean allocatePTY = false;
        protected File localTempDir = null;

        protected B self() {
            return (B)this;
        }

        public B from(Map<String, ?> props) {
            this.host = ShellAbstractTool.getMandatoryVal(props, SshTool.PROP_HOST);
            this.port = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PORT);
            this.user = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_USER);
            this.password = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PASSWORD);
            ShellAbstractTool.warnOnDeprecated(props, "privateKey", "privateKeyData");
            this.privateKeyData = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PRIVATE_KEY_DATA);
            this.privateKeyPassphrase = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PRIVATE_KEY_PASSPHRASE);
            ShellAbstractTool.warnOnDeprecated(props, "keyFiles", null);
            String privateKeyFile = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PRIVATE_KEY_FILE);
            if (privateKeyFile != null) {
                this.privateKeyFiles.add(privateKeyFile);
            }
            this.strictHostKeyChecking = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_STRICT_HOST_KEY_CHECKING);
            this.allocatePTY = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_ALLOCATE_PTY);
            String localTempDirPath = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_LOCAL_TEMP_DIR);
            this.localTempDir = localTempDirPath == null ? null : new File(Os.tidyPath((String)localTempDirPath));
            return this.self();
        }

        public B host(String val) {
            this.host = val;
            return this.self();
        }

        public B user(String val) {
            this.user = val;
            return this.self();
        }

        public B password(String val) {
            this.password = val;
            return this.self();
        }

        public B port(int val) {
            this.port = val;
            return this.self();
        }

        public B privateKeyPassphrase(String val) {
            this.privateKeyPassphrase = val;
            return this.self();
        }

        public B privateKey(String val) {
            this.privateKeyData = val;
            return this.self();
        }

        public B privateKeyData(String val) {
            this.privateKeyData = val;
            return this.self();
        }

        public B privateKeyFile(String val) {
            this.privateKeyFiles.add(val);
            return this.self();
        }

        public B localTempDir(File val) {
            this.localTempDir = val;
            return this.self();
        }

        public abstract T build();
    }

    public static interface SshAction<T> {
        public void clear() throws Exception;

        public T create() throws Exception;
    }
}

