/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.internal.ssh;

import brooklyn.config.ConfigKey;
import brooklyn.util.collections.MutableList;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.internal.ssh.ShellTool;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.StringEscapes;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShellAbstractTool
implements ShellTool {
    private static final Logger LOG = LoggerFactory.getLogger(ShellAbstractTool.class);
    protected final File localTempDir;

    public ShellAbstractTool(String localTempDir) {
        this(localTempDir == null ? null : new File(Os.tidyPath((String)localTempDir)));
    }

    public ShellAbstractTool(File localTempDir) {
        if (localTempDir == null) {
            localTempDir = new File(Os.tmp(), "tmpssh-" + Os.user());
            if (!localTempDir.exists()) {
                localTempDir.mkdir();
            }
            Os.deleteOnExitEmptyParentsUpTo((File)localTempDir, (File)new File(Os.tmp()));
        }
        this.localTempDir = localTempDir;
    }

    public ShellAbstractTool() {
        this((File)null);
    }

    protected static void warnOnDeprecated(Map<String, ?> props, String deprecatedKey, String correctKey) {
        if (props.containsKey(deprecatedKey)) {
            if (correctKey != null && props.containsKey(correctKey)) {
                Object dv = props.get(deprecatedKey);
                Object cv = props.get(correctKey);
                if (!Objects.equal(cv, dv)) {
                    LOG.warn("SshTool detected deprecated key '" + deprecatedKey + "' with different value (" + dv + ") " + "than new key '" + correctKey + "' (" + cv + "); ambiguous which will be used");
                }
            } else {
                Object dv = props.get(deprecatedKey);
                LOG.warn("SshTool detected deprecated key '" + deprecatedKey + "' used, with value (" + dv + ")");
            }
        }
    }

    protected static Boolean hasVal(Map<String, ?> map, ConfigKey<?> keyC) {
        String key = keyC.getName();
        return map.containsKey(key);
    }

    protected static <T> T getMandatoryVal(Map<String, ?> map, ConfigKey<T> keyC) {
        String key = keyC.getName();
        Preconditions.checkArgument((boolean)map.containsKey(key), (Object)("must contain key '" + keyC + "'"));
        return TypeCoercions.coerce(map.get(key), keyC.getTypeToken());
    }

    public static <T> T getOptionalVal(Map<String, ?> map, ConfigKey<T> keyC) {
        if (keyC == null) {
            return null;
        }
        String key = keyC.getName();
        if (map != null && map.containsKey(key)) {
            return TypeCoercions.coerce(map.get(key), keyC.getTypeToken());
        }
        return (T)keyC.getDefaultValue();
    }

    protected static <T> T getOptionalVal(Map<String, ?> map, ConfigKey<T> keyC, T defaultValue) {
        String key = keyC.getName();
        if (map.containsKey(key)) {
            return TypeCoercions.coerce(map.get(key), keyC.getTypeToken());
        }
        return defaultValue;
    }

    protected void closeWhispering(Closeable closeable, Object context) {
        ShellAbstractTool.closeWhispering(closeable, this, context);
    }

    protected static void closeWhispering(Closeable closeable, Object context1, Object context2) {
        block4: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    String msg = String.format("<< exception during close, for %s -> %s (%s); continuing.", context1, context2, closeable);
                    if (LOG.isTraceEnabled()) {
                        LOG.debug(msg + ": " + e);
                    }
                    LOG.trace(msg, (Throwable)e);
                }
            }
        }
    }

    protected File writeTempFile(InputStream contents) {
        File tempFile = Os.writeToTempFile((InputStream)contents, (File)this.localTempDir, (String)"sshcopy", (String)"data");
        tempFile.setReadable(false, false);
        tempFile.setReadable(true, true);
        tempFile.setWritable(false);
        tempFile.setExecutable(false);
        return tempFile;
    }

    protected File writeTempFile(String contents) {
        return this.writeTempFile(contents.getBytes());
    }

    protected File writeTempFile(byte[] contents) {
        return this.writeTempFile(new ByteArrayInputStream(contents));
    }

    protected String toScript(Map<String, ?> props, List<String> commands, Map<String, ?> env) {
        List<String> allcmds = this.toCommandSequence(commands, env);
        StringBuilder result = new StringBuilder();
        result.append((String)ShellAbstractTool.getOptionalVal(props, PROP_SCRIPT_HEADER)).append('\n');
        for (String cmd : allcmds) {
            result.append(cmd).append('\n');
        }
        return result.toString();
    }

    protected List<String> toCommandSequence(List<String> commands, Map<String, ?> env) {
        ArrayList<String> result = new ArrayList<String>((env != null ? env.size() : 0) + commands.size());
        if (env != null) {
            for (Map.Entry entry : env.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) {
                    LOG.warn("env key-values must not be null; ignoring: key=" + (String)entry.getKey() + "; value=" + entry.getValue());
                    continue;
                }
                String escapedVal = StringEscapes.BashStringEscapes.escapeLiteralForDoubleQuotedBash((String)entry.getValue().toString());
                result.add("export " + (String)entry.getKey() + "=\"" + escapedVal + "\"");
            }
        }
        for (CharSequence charSequence : commands) {
            result.add(charSequence.toString());
        }
        return result;
    }

    @Override
    public int execScript(Map<String, ?> props, List<String> commands) {
        return this.execScript(props, commands, Collections.emptyMap());
    }

    @Override
    public int execCommands(Map<String, ?> props, List<String> commands) {
        return this.execCommands(props, commands, Collections.emptyMap());
    }

    protected static int asInt(Integer input, int valueIfInputNull) {
        return input != null ? input : valueIfInputNull;
    }

    protected abstract class ToolAbstractAsyncExecScript
    extends ToolAbstractExecScript {
        protected final String stdoutPath;
        protected final String stderrPath;
        protected final String exitStatusPath;
        protected final String pidPath;

        public ToolAbstractAsyncExecScript(Map<String, ?> props) {
            super(props);
            this.stdoutPath = Os.mergePathsUnix((String[])new String[]{this.scriptDir, this.scriptNameWithoutExtension + ".stdout"});
            this.stderrPath = Os.mergePathsUnix((String[])new String[]{this.scriptDir, this.scriptNameWithoutExtension + ".stderr"});
            this.exitStatusPath = Os.mergePathsUnix((String[])new String[]{this.scriptDir, this.scriptNameWithoutExtension + ".exitstatus"});
            this.pidPath = Os.mergePathsUnix((String[])new String[]{this.scriptDir, this.scriptNameWithoutExtension + ".pid"});
        }

        @Override
        protected List<String> buildRunScriptCommand() {
            String touchCmd = String.format("touch %s %s %s %s", this.stdoutPath, this.stderrPath, this.exitStatusPath, this.pidPath);
            String cmd = String.format("( %s > %s 2> %s < /dev/null ; echo $? > %s ) & disown", this.scriptPath, this.stdoutPath, this.stderrPath, this.exitStatusPath);
            MutableList.Builder cmds = MutableList.builder().add((Object)(this.runAsRoot != false ? BashCommands.sudo((String)touchCmd) : touchCmd)).add((Object)(this.runAsRoot != false ? BashCommands.sudo((String)cmd) : cmd)).add((Object)("echo $! > " + this.pidPath)).add((Object)"RESULT=$?");
            if (this.noExtraOutput == null || !this.noExtraOutput.booleanValue()) {
                cmds.add((Object)("echo Executing async " + this.scriptPath));
            }
            cmds.add((Object)"exit $RESULT");
            return cmds.build();
        }

        protected List<String> buildRetrieveStatusCommand() {
            ImmutableList cmdParts = ImmutableList.of((Object)"# Retrieve status", (Object)("if test -s " + this.exitStatusPath + "; then"), (Object)("    cat " + this.exitStatusPath), (Object)("elif test -s " + this.pidPath + "; then"), (Object)("    pid=`cat " + this.pidPath + "`"), (Object)"    if ! ps -p $pid > /dev/null < /dev/null; then", (Object)"        # no exit status, and not executing; give a few seconds grace in case just about to write exit status", (Object)"        sleep 3", (Object)("        if test -s " + this.exitStatusPath + "; then"), (Object)("            cat " + this.exitStatusPath + ""), (Object)"        else", (Object)("            echo \"No exit status in " + this.exitStatusPath + ", and pid in " + this.pidPath + " ($pid) not executing\""), (Object[])new String[]{"            exit 1", "        fi", "    fi", "else", "    echo \"No exit status in " + this.exitStatusPath + ", and " + this.pidPath + " is empty\"", "    exit 1", "fi\n"});
            String cmd = Joiner.on((String)"\n").join((Iterable)cmdParts);
            MutableList.Builder cmds = MutableList.builder().add((Object)(this.runAsRoot != false ? BashCommands.sudo((String)cmd) : cmd)).add((Object)"RESULT=$?");
            cmds.add((Object)"exit $RESULT");
            return cmds.build();
        }

        protected List<String> buildRetrieveStdoutAndStderrCommand(int stdoutPosition, int stderrPosition) {
            String catStdoutCmd = "tail -c +" + (stdoutPosition + 1) + " " + this.stdoutPath;
            String catStderrCmd = "tail -c +" + (stderrPosition + 1) + " " + this.stderrPath + " 1>&2";
            MutableList.Builder cmds = MutableList.builder().add((Object)(this.runAsRoot != false ? BashCommands.sudo((String)catStdoutCmd) : catStdoutCmd)).add((Object)(this.runAsRoot != false ? BashCommands.sudo((String)catStderrCmd) : catStderrCmd)).add((Object)"RESULT=$?");
            cmds.add((Object)"exit $RESULT");
            return cmds.build();
        }

        protected List<String> buildLongPollCommand(int stdoutPosition, int stderrPosition, Duration timeout) {
            long maxTime = Math.max(1L, timeout.toSeconds());
            ImmutableList waitForExitStatusParts = ImmutableList.of((Object)"# Long poll", (Object)("tail -c +" + (stdoutPosition + 1) + " -f " + this.stdoutPath + " & export TAIL_STDOUT_PID=$!"), (Object)("tail -c +" + (stderrPosition + 1) + " -f " + this.stderrPath + " 1>&2 & export TAIL_STDERR_PID=$!"), (Object)("EXIT_STATUS_PATH=" + this.exitStatusPath), (Object)("PID_PATH=" + this.pidPath), (Object)("MAX_TIME=" + maxTime), (Object)"COUNTER=0", (Object)"while [ \"$COUNTER\" -lt $MAX_TIME ]; do", (Object)"    if test -s $EXIT_STATUS_PATH; then", (Object)"        EXIT_STATUS=`cat $EXIT_STATUS_PATH`", (Object)"        exit $EXIT_STATUS", (Object)"    elif test -s $PID_PATH; then", (Object[])new String[]{"        PID=`cat $PID_PATH`", "        if ! ps -p $PID > /dev/null < /dev/null; then", "            # no exit status, and not executing; give a few seconds grace in case just about to write exit status", "            sleep 3", "            if test -s $EXIT_STATUS_PATH; then", "                EXIT_STATUS=`cat $EXIT_STATUS_PATH`", "                kill ${TAIL_STDERR_PID} ${TAIL_STDOUT_PID}", "                exit $EXIT_STATUS", "            else", "                echo \"No exit status in $EXIT_STATUS_PATH, and pid in $PID_PATH ($PID) not executing\"", "                kill ${TAIL_STDERR_PID} ${TAIL_STDOUT_PID}", "                exit 126", "            fi", "        fi", "    fi", "    # No exit status in $EXIT_STATUS_PATH; keep waiting", "    sleep 1", "    COUNTER+=1", "done", "kill ${TAIL_STDERR_PID} ${TAIL_STDOUT_PID}", "exit 125\n"});
            String waitForExitStatus = Joiner.on((String)"\n").join((Iterable)waitForExitStatusParts);
            return ImmutableList.of((Object)(this.runAsRoot != false ? BashCommands.sudo((String)waitForExitStatus) : waitForExitStatus));
        }

        protected List<String> deleteTemporaryFilesCommand() {
            ImmutableList.Builder cmdParts = ImmutableList.builder();
            if (!Boolean.TRUE.equals(this.noDeleteAfterExec)) {
                cmdParts.add((Object)("rm -f " + this.scriptPath + " " + this.stdoutPath + " " + this.stderrPath + " " + this.exitStatusPath + " " + this.pidPath + " < /dev/null"));
            }
            cmdParts.add((Object[])new String[]{"ps aux | grep \"tail -c\" | grep \"" + this.stdoutPath + "\" | grep -v grep | awk '{ printf $2 }' | xargs kill", "ps aux | grep \"tail -c\" | grep \"" + this.stderrPath + "\" | grep -v grep | awk '{ printf $2 }' | xargs kill"});
            String cmd = Joiner.on((String)"\n").join((Iterable)cmdParts.build());
            return ImmutableList.of((Object)(this.runAsRoot != false ? BashCommands.sudo((String)cmd) : cmd));
        }

        @Override
        public abstract int run();
    }

    protected abstract class ToolAbstractExecScript {
        protected final Map<String, ?> props;
        protected final String separator;
        protected final OutputStream out;
        protected final OutputStream err;
        protected final String scriptDir;
        protected final Boolean runAsRoot;
        protected final Boolean noExtraOutput;
        protected final Boolean noDeleteAfterExec;
        protected final String scriptNameWithoutExtension;
        protected final String scriptPath;
        protected final Duration execTimeout;

        public ToolAbstractExecScript(Map<String, ?> props) {
            this.props = props;
            this.separator = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_SEPARATOR);
            this.out = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_OUT_STREAM);
            this.err = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_ERR_STREAM);
            this.scriptDir = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_SCRIPT_DIR);
            this.runAsRoot = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_RUN_AS_ROOT);
            this.noExtraOutput = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_NO_EXTRA_OUTPUT);
            this.noDeleteAfterExec = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_NO_DELETE_SCRIPT);
            this.execTimeout = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_EXEC_TIMEOUT);
            String summary = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_SUMMARY);
            if (summary != null && (summary = Strings.makeValidFilename((String)summary)).length() > 30) {
                summary = summary.substring(0, 30);
            }
            this.scriptNameWithoutExtension = "brooklyn-" + Time.makeDateStampString() + "-" + Identifiers.makeRandomId((int)4) + (Strings.isBlank((CharSequence)summary) ? "" : "-" + summary);
            this.scriptPath = Os.mergePathsUnix((String[])new String[]{this.scriptDir, this.scriptNameWithoutExtension + ".sh"});
        }

        protected List<String> buildRunScriptCommand() {
            MutableList.Builder cmds = MutableList.builder().add((Object)((this.runAsRoot != false ? BashCommands.sudo((String)this.scriptPath) : this.scriptPath) + " < /dev/null")).add((Object)"RESULT=$?");
            if (this.noExtraOutput == null || !this.noExtraOutput.booleanValue()) {
                cmds.add((Object)("echo Executed " + this.scriptPath + ", result $RESULT"));
            }
            if (this.noDeleteAfterExec != Boolean.TRUE) {
                cmds.add((Object)("rm -f " + this.scriptPath + " < /dev/null"));
            }
            cmds.add((Object)"exit $RESULT");
            return cmds.build();
        }

        protected String getSummary() {
            String summary = ShellAbstractTool.getOptionalVal(this.props, ShellTool.PROP_SUMMARY);
            return summary != null ? summary : this.scriptPath;
        }

        public abstract int run();
    }
}

