/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.internal.ssh;

import brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffLimitedRetryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BackoffLimitedRetryHandler.class);
    private final int retryCountLimit;
    private final long delayStart;

    public BackoffLimitedRetryHandler() {
        this(5, 50L);
    }

    public BackoffLimitedRetryHandler(int retryCountLimit, long delayStart) {
        this.retryCountLimit = retryCountLimit;
        this.delayStart = delayStart;
    }

    public void imposeBackoffExponentialDelay(int failureCount, String commandDescription) {
        this.imposeBackoffExponentialDelay(this.delayStart, 2, failureCount, this.retryCountLimit, commandDescription);
    }

    public void imposeBackoffExponentialDelay(long period, int pow, int failureCount, int max, String commandDescription) {
        this.imposeBackoffExponentialDelay(period, period * 10L, pow, failureCount, max, commandDescription);
    }

    public void imposeBackoffExponentialDelay(long period, long maxPeriod, int pow, int failureCount, int max, String commandDescription) {
        long delayMs = (long)((double)period * Math.pow(failureCount, pow));
        long l = delayMs = delayMs > maxPeriod ? maxPeriod : delayMs;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retry {}/{}: delaying for {} ms: {}", new Object[]{failureCount, max, delayMs, commandDescription});
        }
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            Exceptions.propagate((Throwable)e);
        }
    }
}

