/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.internal;

import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.internal.TimeExtras;
import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Callables;
import groovy.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Repeater {
    private static final Logger log = LoggerFactory.getLogger(Repeater.class);
    @SetFromFlag
    private final String description;
    private Callable<?> body = Callables.returning(null);
    private Callable<Boolean> exitCondition;
    @SetFromFlag
    private Long period = null;
    @SetFromFlag(value="timeout")
    private Long durationLimit = null;
    private int iterationLimit = 0;
    private boolean rethrowException = false;
    private boolean rethrowExceptionImmediately = false;
    private boolean warnOnUnRethrownException = true;

    public Repeater() {
        this((Map<?, ?>)MutableMap.of(), null);
    }

    public Repeater(Map<?, ?> flags) {
        this(flags, null);
    }

    public Repeater(String description) {
        this((Map<?, ?>)MutableMap.of(), description);
    }

    public Repeater(Map<?, ?> flags, String description) {
        this.setFromFlags(flags);
        this.description = (String)JavaGroovyEquivalents.elvis((Object[])new Object[]{description, this.description, "Repeater"});
    }

    public void setFromFlags(Map<?, ?> flags) {
        FlagUtils.setFieldsFromFlags(flags, this);
    }

    public static Repeater create() {
        return Repeater.create(MutableMap.of());
    }

    public static Repeater create(Map<?, ?> flags) {
        return Repeater.create(flags, null);
    }

    public static Repeater create(String description) {
        return Repeater.create(MutableMap.of(), description);
    }

    public static Repeater create(Map<?, ?> flags, String description) {
        return new Repeater(flags, description);
    }

    public Repeater repeat() {
        return this.repeat(Callables.returning(null));
    }

    public Repeater repeat(Runnable body) {
        Preconditions.checkNotNull((Object)body, (Object)"body must not be null");
        this.body = body instanceof Callable ? (Callable<Object>)((Object)body) : Executors.callable(body);
        return this;
    }

    public Repeater repeat(Callable<?> body) {
        Preconditions.checkNotNull(body, (Object)"body must not be null");
        this.body = body;
        return this;
    }

    public Repeater every(long period, TimeUnit unit) {
        Preconditions.checkArgument((period > 0L ? 1 : 0) != 0, (String)"period must be positive: %s", (Object[])new Object[]{period});
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null");
        this.period = unit.toMillis(period);
        return this;
    }

    public Repeater every(brooklyn.util.time.Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration must not be null");
        Preconditions.checkArgument((duration.toMilliseconds() > 0L ? 1 : 0) != 0, (String)"period must be positive: %s", (Object[])new Object[]{duration});
        this.period = duration.toMilliseconds();
        return this;
    }

    public Repeater every(Duration duration) {
        return this.every(brooklyn.util.time.Duration.of((Object)duration));
    }

    public Repeater every(long duration) {
        return this.every(duration, TimeUnit.MILLISECONDS);
    }

    public Repeater until(Callable<Boolean> exitCondition) {
        Preconditions.checkNotNull(exitCondition, (Object)"exitCondition must not be null");
        this.exitCondition = exitCondition;
        return this;
    }

    public Repeater rethrowException() {
        this.rethrowException = true;
        return this;
    }

    public Repeater rethrowExceptionImmediately() {
        this.rethrowExceptionImmediately = true;
        return this;
    }

    public Repeater suppressWarnings() {
        this.warnOnUnRethrownException = false;
        return this;
    }

    public Repeater limitIterationsTo(int iterationLimit) {
        Preconditions.checkArgument((iterationLimit > 0 ? 1 : 0) != 0, (String)"iterationLimit must be positive: %s", (Object[])new Object[]{iterationLimit});
        this.iterationLimit = iterationLimit;
        return this;
    }

    public Repeater limitTimeTo(long deadline, TimeUnit unit) {
        Preconditions.checkArgument((deadline > 0L ? 1 : 0) != 0, (String)"deadline must be positive: %s", (Object[])new Object[]{deadline});
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null");
        this.durationLimit = unit.toMillis(deadline);
        return this;
    }

    public Repeater limitTimeTo(brooklyn.util.time.Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration must not be null");
        Preconditions.checkArgument((duration.toMilliseconds() > 0L ? 1 : 0) != 0, (String)"deadline must be positive: %s", (Object[])new Object[]{duration});
        this.durationLimit = duration.toMilliseconds();
        return this;
    }

    public boolean run() {
        Preconditions.checkState((this.body != null ? 1 : 0) != 0, (Object)"repeat() method has not been called to set the body");
        Preconditions.checkState((this.exitCondition != null ? 1 : 0) != 0, (Object)"until() method has not been called to set the exit condition");
        Preconditions.checkState((this.period != null ? 1 : 0) != 0, (Object)"every() method has not been called to set the loop period time units");
        Exception lastError = null;
        int iterations = 0;
        long endTime = -1L;
        if (this.durationLimit != null) {
            endTime = System.currentTimeMillis() + this.durationLimit;
        }
        while (true) {
            boolean done;
            block20: {
                block19: {
                    ++iterations;
                    try {
                        this.body.call();
                    }
                    catch (Exception e) {
                        log.warn(this.description, (Throwable)e);
                        if (!this.rethrowExceptionImmediately) break block19;
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
                done = false;
                try {
                    lastError = null;
                    done = this.exitCondition.call();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug(this.description, (Throwable)e);
                    }
                    lastError = e;
                    if (!this.rethrowExceptionImmediately) break block20;
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            if (done) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: condition satisfied", (Object)this.description);
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                String msg = String.format("%s: unsatisfied during iteration %s %s", this.description, iterations, (this.iterationLimit > 0 ? "(max " + this.iterationLimit + " attempts)" : "") + (endTime > 0L ? "(" + Time.makeTimeStringRounded((long)(endTime - System.currentTimeMillis())) + " remaining)" : ""));
                if (iterations == 1) {
                    log.debug(msg);
                } else {
                    log.trace(msg);
                }
            }
            if (this.iterationLimit > 0 && iterations == this.iterationLimit) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: condition not satisfied and exceeded iteration limit", (Object)this.description);
                }
                if (this.rethrowException && lastError != null) {
                    log.warn("{}: error caught checking condition (rethrowing): {}", (Object)this.description, (Object)lastError.getMessage());
                    throw Exceptions.propagate((Throwable)lastError);
                }
                if (this.warnOnUnRethrownException && lastError != null) {
                    log.warn("{}: error caught checking condition: {}", (Object)this.description, (Object)lastError.getMessage());
                }
                return false;
            }
            if (endTime > 0L && System.currentTimeMillis() > endTime) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: condition not satisfied and deadline {} passed", (Object)this.description, (Object)Time.makeTimeStringRounded((long)(endTime - System.currentTimeMillis())));
                }
                if (this.rethrowException && lastError != null) {
                    log.error("{}: error caught checking condition: {}", (Object)this.description, (Object)lastError.getMessage());
                    throw Exceptions.propagate((Throwable)lastError);
                }
                return false;
            }
            Time.sleep((long)this.period);
        }
    }

    static {
        TimeExtras.init();
    }
}

