/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.http;

import brooklyn.event.feed.http.HttpPollValue;
import brooklyn.util.guava.Maybe;
import brooklyn.util.stream.Streams;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpToolResponse
implements HttpPollValue {
    private static final Logger log = LoggerFactory.getLogger(HttpToolResponse.class);
    private final Object mutex = new Object();
    private final HttpResponse response;
    private final long startTime;
    private final long durationMillisOfFirstResponse;
    private final long durationMillisOfFullContent;
    private int responseCode;
    private String reasonPhrase;
    private Map<String, List<String>> headerLists;
    private byte[] content;

    public HttpToolResponse(HttpResponse response, long startTime) {
        this.response = response;
        this.startTime = startTime;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                entity.getContentLength();
                this.durationMillisOfFirstResponse = Duration.sinceUtc((long)startTime).toMilliseconds();
                ByteStreams.copy((InputStream)entity.getContent(), (OutputStream)out);
                this.content = out.toByteArray();
                entity.getContentLength();
            } else {
                this.durationMillisOfFirstResponse = Duration.sinceUtc((long)startTime).toMilliseconds();
                this.content = new byte[0];
            }
            this.durationMillisOfFullContent = Duration.sinceUtc((long)startTime).toMilliseconds();
            if (log.isTraceEnabled()) {
                log.trace("HttpPollValue latency " + Time.makeTimeStringRounded((long)this.durationMillisOfFirstResponse) + " / " + Time.makeTimeStringRounded((long)this.durationMillisOfFullContent) + ", content size " + this.content.length);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HttpToolResponse(int responseCode, Map<String, List<String>> headers, byte[] content, long startTime, long durationMillisOfFirstResponse, long durationMillisOfFullContent) {
        this.response = null;
        this.responseCode = responseCode;
        this.headerLists = ImmutableMap.copyOf(headers);
        this.content = content;
        this.startTime = startTime;
        this.durationMillisOfFirstResponse = durationMillisOfFirstResponse;
        this.durationMillisOfFullContent = durationMillisOfFullContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResponseCode() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.responseCode == 0) {
                this.responseCode = this.response.getStatusLine().getStatusCode();
            }
        }
        return this.responseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getReasonPhrase() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.reasonPhrase == null) {
                this.reasonPhrase = this.response.getStatusLine().getReasonPhrase();
            }
        }
        return this.reasonPhrase;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getLatencyFullContent() {
        return this.durationMillisOfFullContent;
    }

    @Override
    public long getLatencyFirstResponse() {
        return this.durationMillisOfFirstResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getHeaderLists() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.headerLists == null) {
                LinkedHashMap headerListsMutable = Maps.newLinkedHashMap();
                for (Header header : this.response.getAllHeaders()) {
                    ArrayList<String> vals = (ArrayList<String>)headerListsMutable.get(header.getName());
                    if (vals == null) {
                        vals = new ArrayList<String>();
                        headerListsMutable.put(header.getName(), vals);
                    }
                    vals.add(header.getValue());
                }
                this.headerLists = Collections.unmodifiableMap(headerListsMutable);
            }
        }
        return this.headerLists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getContent() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.content == null) {
                InputStream in = null;
                try {
                    in = this.response.getEntity().getContent();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                    this.content = out.toByteArray();
                }
                catch (IOException e) {
                    try {
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        Streams.closeQuietly(in);
                        throw throwable;
                    }
                }
                Streams.closeQuietly((Closeable)in);
            }
        }
        return this.content;
    }

    public String getContentAsString() {
        return new String(this.getContent());
    }

    public Maybe<HttpResponse> getResponse() {
        return Maybe.fromNullable((Object)this.response);
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("responseCode", this.responseCode).toString();
    }
}

