/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.http;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.http.HttpToolResponse;
import brooklyn.util.net.URLParamEncoder;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTool {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTool.class);

    public static HttpClientBuilder httpClientBuilder() {
        return new HttpClientBuilder();
    }

    public static HttpToolResponse httpGet(HttpClient httpClient, URI uri, Map<String, String> headers) {
        HttpGet req = (HttpGet)((HttpGetBuilder)new HttpGetBuilder(uri).headers(headers)).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPost(HttpClient httpClient, URI uri, Map<String, String> headers, byte[] body) {
        HttpPost req = (HttpPost)((HttpPostBuilder)((HttpPostBuilder)new HttpPostBuilder(uri).headers(headers)).body(body)).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPut(HttpClient httpClient, URI uri, Map<String, String> headers, byte[] body) {
        HttpPut req = (HttpPut)((HttpPutBuilder)((HttpPutBuilder)new HttpPutBuilder(uri).headers(headers)).body(body)).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPost(HttpClient httpClient, URI uri, Map<String, String> headers, Map<String, String> params) {
        HttpPost req = (HttpPost)((HttpFormPostBuilder)new HttpFormPostBuilder(uri).headers(headers)).params(params).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpDelete(HttpClient httpClient, URI uri, Map<String, String> headers) {
        HttpDelete req = (HttpDelete)((HttpDeleteBuilder)new HttpDeleteBuilder(uri).headers(headers)).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpHead(HttpClient httpClient, URI uri, Map<String, String> headers) {
        HttpHead req = (HttpHead)((HttpHeadBuilder)new HttpHeadBuilder(uri).headers(headers)).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpToolResponse execAndConsume(HttpClient httpClient, HttpUriRequest req) {
        HttpToolResponse httpToolResponse;
        long startTime = System.currentTimeMillis();
        HttpResponse httpResponse = httpClient.execute(req);
        try {
            httpToolResponse = new HttpToolResponse(httpResponse, startTime);
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw throwable;
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        return httpToolResponse;
    }

    public static boolean isStatusCodeHealthy(int code) {
        return code >= 200 && code <= 299;
    }

    public static String toBasicAuthorizationValue(UsernamePasswordCredentials credentials) {
        return "Basic " + Base64.encodeBase64String((byte[])(credentials.getUserName() + ":" + credentials.getPassword()).getBytes());
    }

    public static String encodeUrlParams(Map<?, ?> data) {
        if (data == null) {
            return "";
        }
        Iterable args = Iterables.transform(data.entrySet(), (Function)new Function<Map.Entry<?, ?>, String>(){

            public String apply(Map.Entry<?, ?> entry) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                return URLParamEncoder.encode((String)Strings.toString(k)) + (v != null ? "=" + URLParamEncoder.encode((String)Strings.toString(v)) : "");
            }
        });
        return Joiner.on((String)"&").join(args);
    }

    public static class HttpPutBuilder
    extends HttpEntityEnclosingRequestBaseBuilder<HttpPutBuilder, HttpPut> {
        public HttpPutBuilder(URI uri) {
            super(new HttpPut(uri));
        }
    }

    public static class HttpFormPostBuilder
    extends HttpRequestBuilder<HttpFormPostBuilder, HttpPost> {
        HttpFormPostBuilder(URI uri) {
            super(new HttpPost(uri));
        }

        public HttpFormPostBuilder params(Map<String, String> params) {
            if (params != null) {
                ArrayList<BasicNameValuePair> httpParams = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> param : params.entrySet()) {
                    httpParams.add(new BasicNameValuePair(param.getKey(), param.getValue()));
                }
                ((HttpPost)this.req).setEntity((HttpEntity)new UrlEncodedFormEntity(httpParams));
            }
            return (HttpFormPostBuilder)this.self();
        }
    }

    public static class HttpPostBuilder
    extends HttpEntityEnclosingRequestBaseBuilder<HttpPostBuilder, HttpPost> {
        HttpPostBuilder(URI uri) {
            super(new HttpPost(uri));
        }
    }

    public static class HttpDeleteBuilder
    extends HttpRequestBuilder<HttpDeleteBuilder, HttpDelete> {
        public HttpDeleteBuilder(URI uri) {
            super(new HttpDelete(uri));
        }
    }

    public static class HttpHeadBuilder
    extends HttpRequestBuilder<HttpHeadBuilder, HttpHead> {
        public HttpHeadBuilder(URI uri) {
            super(new HttpHead(uri));
        }
    }

    public static class HttpGetBuilder
    extends HttpRequestBuilder<HttpGetBuilder, HttpGet> {
        public HttpGetBuilder(URI uri) {
            super(new HttpGet(uri));
        }
    }

    protected static abstract class HttpEntityEnclosingRequestBaseBuilder<B extends HttpEntityEnclosingRequestBaseBuilder<B, R>, R extends HttpEntityEnclosingRequestBase>
    extends HttpRequestBuilder<B, R> {
        protected HttpEntityEnclosingRequestBaseBuilder(R req) {
            super(req);
        }

        public B body(byte[] body) {
            if (body != null) {
                ByteArrayEntity httpEntity = new ByteArrayEntity(body);
                ((HttpEntityEnclosingRequestBase)this.req).setEntity((HttpEntity)httpEntity);
            }
            return (B)((HttpEntityEnclosingRequestBaseBuilder)this.self());
        }
    }

    protected static abstract class HttpRequestBuilder<B extends HttpRequestBuilder<B, R>, R extends HttpRequest> {
        protected R req;

        protected HttpRequestBuilder(R req) {
            this.req = req;
        }

        protected B self() {
            return (B)this;
        }

        public B headers(Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    this.req.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return this.self();
        }

        public B headers(Multimap<String, String> headers) {
            if (headers != null) {
                for (Map.Entry entry : headers.entries()) {
                    this.req.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return this.self();
        }

        public R build() {
            return this.req;
        }
    }

    public static class HttpClientBuilder {
        private ClientConnectionManager clientConnectionManager;
        private HttpParams httpParams;
        private URI uri;
        private Integer port;
        private Credentials credentials;
        private boolean laxRedirect;
        private Boolean https;
        private SchemeSocketFactory socketFactory;
        private ConnectionReuseStrategy reuseStrategy;
        private boolean trustAll;
        private boolean trustSelfSigned;

        public HttpClientBuilder clientConnectionManager(ClientConnectionManager val) {
            this.clientConnectionManager = (ClientConnectionManager)Preconditions.checkNotNull((Object)val, (Object)"clientConnectionManager");
            return this;
        }

        public HttpClientBuilder httpParams(HttpParams val) {
            Preconditions.checkState((this.httpParams == null ? 1 : 0) != 0, (Object)"Must not call httpParams multiple times, or after other methods like connectionTimeout");
            this.httpParams = (HttpParams)Preconditions.checkNotNull((Object)val, (Object)"httpParams");
            return this;
        }

        public HttpClientBuilder connectionTimeout(Duration val) {
            long millis;
            if (this.httpParams == null) {
                this.httpParams = new BasicHttpParams();
            }
            if ((millis = ((Duration)Preconditions.checkNotNull((Object)val, (Object)"connectionTimeout")).toMilliseconds()) > Integer.MAX_VALUE) {
                throw new IllegalStateException("HttpClient only accepts upto max-int millis for connectionTimeout, but given " + val);
            }
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpParams, (int)((int)millis));
            return this;
        }

        public HttpClientBuilder socketTimeout(Duration val) {
            long millis;
            if (this.httpParams == null) {
                this.httpParams = new BasicHttpParams();
            }
            if ((millis = ((Duration)Preconditions.checkNotNull((Object)val, (Object)"socketTimeout")).toMilliseconds()) > Integer.MAX_VALUE) {
                throw new IllegalStateException("HttpClient only accepts upto max-int millis for socketTimeout, but given " + val);
            }
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams, (int)((int)millis));
            return this;
        }

        public HttpClientBuilder reuseStrategy(ConnectionReuseStrategy val) {
            this.reuseStrategy = (ConnectionReuseStrategy)Preconditions.checkNotNull((Object)val, (Object)"reuseStrategy");
            return this;
        }

        public HttpClientBuilder uri(String val) {
            return this.uri(URI.create((String)Preconditions.checkNotNull((Object)val, (Object)"uri")));
        }

        public HttpClientBuilder uri(URI val) {
            this.uri = (URI)Preconditions.checkNotNull((Object)val, (Object)"uri");
            if (this.https == null) {
                this.https = "https".equalsIgnoreCase(this.uri.getScheme());
            }
            return this;
        }

        public HttpClientBuilder port(int val) {
            this.port = val;
            return this;
        }

        public HttpClientBuilder credentials(Credentials val) {
            this.credentials = (Credentials)Preconditions.checkNotNull((Object)val, (Object)"credentials");
            return this;
        }

        public void credential(Optional<Credentials> val) {
            if (val.isPresent()) {
                this.credentials = (Credentials)val.get();
            }
        }

        public HttpClientBuilder laxRedirect(boolean val) {
            this.laxRedirect = val;
            return this;
        }

        public HttpClientBuilder https(boolean val) {
            this.https = val;
            return this;
        }

        public HttpClientBuilder socketFactory(SchemeSocketFactory val) {
            this.socketFactory = (SchemeSocketFactory)Preconditions.checkNotNull((Object)val, (Object)"socketFactory");
            return this;
        }

        public HttpClientBuilder trustAll() {
            this.trustAll = true;
            return this;
        }

        public HttpClientBuilder trustSelfSigned() {
            this.trustSelfSigned = true;
            return this;
        }

        public HttpClient build() {
            DefaultHttpClient httpClient = new DefaultHttpClient(this.clientConnectionManager);
            httpClient.setParams(this.httpParams);
            if (this.laxRedirect) {
                httpClient.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            }
            if (this.reuseStrategy != null) {
                httpClient.setReuseStrategy(this.reuseStrategy);
            }
            if (this.https == Boolean.TRUE || this.uri != null && this.uri.toString().startsWith("https:")) {
                try {
                    if (this.port == null) {
                        this.port = this.uri != null && this.uri.getPort() >= 0 ? this.uri.getPort() : 443;
                    }
                    if (this.socketFactory == null) {
                        X509HostnameVerifier hostnameVerifier;
                        TrustAllStrategy trustStrategy;
                        if (this.trustAll) {
                            trustStrategy = new TrustAllStrategy();
                            hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                            this.socketFactory = new SSLSocketFactory((TrustStrategy)trustStrategy, hostnameVerifier);
                        } else if (this.trustSelfSigned) {
                            trustStrategy = new TrustSelfSignedStrategy();
                            hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                            this.socketFactory = new SSLSocketFactory((TrustStrategy)trustStrategy, hostnameVerifier);
                        }
                    }
                    if (this.socketFactory != null) {
                        Scheme sch = new Scheme("https", this.port.intValue(), this.socketFactory);
                        httpClient.getConnectionManager().getSchemeRegistry().register(sch);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error setting trust for uri {}", (Object)this.uri);
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            if (this.uri != null && this.credentials != null) {
                String hostname = this.uri.getHost();
                int port = this.uri.getPort();
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(hostname, port), this.credentials);
            }
            if (this.uri == null && this.credentials != null) {
                LOG.warn("credentials have no effect in builder unless URI for host is specified");
            }
            return httpClient;
        }
    }

    public static class TrustAllStrategy
    implements TrustStrategy {
        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

