/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.flags;

import brooklyn.entity.basic.ClosureEntityFactory;
import brooklyn.entity.basic.ConfigurableEntityFactory;
import brooklyn.entity.basic.ConfigurableEntityFactoryFromEntityFactory;
import brooklyn.entity.basic.EntityFactory;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.internal.BrooklynInitialization;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.ClassCoercionException;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.Enums;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Networking;
import brooklyn.util.net.UserAndHostAndPort;
import brooklyn.util.text.StringEscapes;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.yaml.Yamls;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import groovy.lang.Closure;
import groovy.time.TimeDuration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCoercions {
    private static final Logger log = LoggerFactory.getLogger(TypeCoercions.class);
    @GuardedBy(value="TypeCoercions.class")
    private static Table<Class, Class, Function> registry = HashBasedTable.create();
    public static final Map<Class, Class> BOXED_TO_UNBOXED_TYPES = ImmutableMap.builder().put(Integer.class, Integer.TYPE).put(Long.class, Long.TYPE).put(Boolean.class, Boolean.TYPE).put(Byte.class, Byte.TYPE).put(Double.class, Double.TYPE).put(Float.class, Float.TYPE).put(Character.class, Character.TYPE).put(Short.class, Short.TYPE).build();
    public static final Map<Class, Class> UNBOXED_TO_BOXED_TYPES = ImmutableMap.builder().put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Character.TYPE, Character.class).put(Short.TYPE, Short.class).build();

    private TypeCoercions() {
    }

    public static <T> T coerce(Object value, Class<T> targetType) {
        return TypeCoercions.coerce(value, TypeToken.of(targetType));
    }

    public static <T> Maybe<T> tryCoerce(Object value, TypeToken<T> targetTypeToken) {
        try {
            return Maybe.of(TypeCoercions.coerce(value, targetTypeToken));
        }
        catch (Throwable t) {
            Exceptions.propagateIfFatal((Throwable)t);
            return Maybe.absent((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T coerce(Object value, TypeToken<T> targetTypeToken) {
        Object result;
        if (value == null) {
            return null;
        }
        Class targetType = targetTypeToken.getRawType();
        if (targetTypeToken.getType() instanceof ParameterizedType) {
            if (value instanceof Collection && Collection.class.isAssignableFrom(targetType)) {
                Type[] arguments = ((ParameterizedType)targetTypeToken.getType()).getActualTypeArguments();
                if (arguments.length != 1) {
                    throw new IllegalStateException("Unexpected number of parameters in collection type: " + arguments);
                }
                LinkedList coerced = Lists.newLinkedList();
                TypeToken listEntryType = TypeToken.of((Type)arguments[0]);
                for (Object entry : (Iterable)value) {
                    coerced.add(TypeCoercions.coerce(entry, listEntryType));
                }
                if (Set.class.isAssignableFrom(targetType)) {
                    return (T)Sets.newLinkedHashSet((Iterable)coerced);
                }
                return (T)Lists.newArrayList((Iterable)coerced);
            }
            if (value instanceof Map && Map.class.isAssignableFrom(targetType)) {
                Type[] arguments = ((ParameterizedType)targetTypeToken.getType()).getActualTypeArguments();
                if (arguments.length != 2) {
                    throw new IllegalStateException("Unexpected number of parameters in map type: " + arguments);
                }
                LinkedHashMap coerced = Maps.newLinkedHashMap();
                TypeToken mapKeyType = TypeToken.of((Type)arguments[0]);
                TypeToken mapValueType = TypeToken.of((Type)arguments[1]);
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    coerced.put(TypeCoercions.coerce(entry.getKey(), mapKeyType), TypeCoercions.coerce(entry.getValue(), mapValueType));
                }
                return (T)Maps.newLinkedHashMap((Map)coerced);
            }
        }
        if (targetType.isInstance(value)) {
            return (T)value;
        }
        if (TypeCoercions.isPrimitiveOrBoxer(targetType) && TypeCoercions.isPrimitiveOrBoxer(value.getClass())) {
            return TypeCoercions.castPrimitive(value, targetType);
        }
        if (value instanceof String && TypeCoercions.isPrimitiveOrBoxer(targetType)) {
            return TypeCoercions.stringToPrimitive((String)value, targetType);
        }
        if (TypeCoercions.isPrimitiveOrBoxer(value.getClass()) && targetType.equals(String.class)) {
            return (T)value.toString();
        }
        String targetTypeSimpleName = TypeCoercions.getVerySimpleName(targetType);
        if (targetTypeSimpleName != null && targetTypeSimpleName.length() > 0) {
            for (Method m : value.getClass().getMethods()) {
                if (!m.getName().startsWith("as") || m.getParameterTypes().length != 0 || !targetType.isAssignableFrom(m.getReturnType()) || !m.getName().equals("as" + TypeCoercions.getVerySimpleName(m.getReturnType()))) continue;
                try {
                    return (T)m.invoke(value, new Object[0]);
                }
                catch (Exception e) {
                    throw new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): " + m.getName() + " adapting failed, " + e);
                }
            }
        }
        for (Method m : targetType.getMethods()) {
            if ((m.getModifiers() & 8) != 8 || !m.getName().startsWith("from") || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isInstance(value) || !m.getName().equals("from" + TypeCoercions.getVerySimpleName(m.getParameterTypes()[0]))) continue;
            try {
                return (T)m.invoke(null, value);
            }
            catch (Exception e) {
                throw new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): " + m.getName() + " adapting failed, " + e);
            }
        }
        Class boxedT = UNBOXED_TO_BOXED_TYPES.get(targetType);
        Class boxedVT = UNBOXED_TO_BOXED_TYPES.get(value.getClass());
        if (boxedT != null || boxedVT != null) {
            try {
                if (boxedT == null) {
                    boxedT = targetType;
                }
                Object boxedV = boxedVT == null ? value : boxedVT.getConstructor(value.getClass()).newInstance(value);
                return TypeCoercions.coerce(boxedV, boxedT);
            }
            catch (Exception e) {
                throw new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): unboxing failed, " + e);
            }
        }
        if (targetType.isEnum() && (result = TypeCoercions.stringToEnum(targetType, null).apply((Object)String.valueOf(value))) != null) {
            return (T)result;
        }
        Class<TypeCoercions> clazz = TypeCoercions.class;
        synchronized (TypeCoercions.class) {
            Map adapters = registry.row((Object)targetType);
            for (Map.Entry entry : adapters.entrySet()) {
                if (!((Class)entry.getKey()).isInstance(value)) continue;
                Object result2 = ((Function)entry.getValue()).apply(value);
                if (!Objects.equal((Object)value, (Object)result2) && targetTypeToken.getType() instanceof ParameterizedType) {
                    // ** MonitorExit[var6_19] (shouldn't be in output)
                    return TypeCoercions.coerce(result2, targetTypeToken);
                }
                // ** MonitorExit[var6_19] (shouldn't be in output)
                return (T)result2;
            }
            // ** MonitorExit[var6_19] (shouldn't be in output)
            throw new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): no adapter known");
        }
    }

    public static <E extends Enum<E>> Function<String, E> stringToEnum(final Class<E> type, final @Nullable E defaultValue) {
        return new Function<String, E>(){

            public E apply(String input) {
                Preconditions.checkNotNull((Object)input, (Object)"input");
                ImmutableList options = ImmutableList.of((Object)input, (Object)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, input), (Object)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, input), (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, input), (Object)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, input));
                for (String value : options) {
                    try {
                        return Enum.valueOf(type, value);
                    }
                    catch (IllegalArgumentException iae) {
                    }
                }
                Maybe result = Enums.valueOfIgnoreCase((Class)type, (String)input);
                return result.isPresent() ? (Enum)result.get() : defaultValue;
            }
        };
    }

    public static <T> T castPrimitive(Object value, Class<T> targetType) {
        Class targetWrapType;
        if (value == null) {
            return null;
        }
        assert (TypeCoercions.isPrimitiveOrBoxer(targetType)) : "targetType=" + targetType;
        assert (TypeCoercions.isPrimitiveOrBoxer(value.getClass())) : "value=" + targetType + "; valueType=" + value.getClass();
        Class sourceWrapType = Primitives.wrap(value.getClass());
        if (sourceWrapType == (targetWrapType = Primitives.wrap(targetType))) {
            return (T)value;
        }
        if (targetWrapType == Boolean.class) {
            if (sourceWrapType == Character.class) {
                return TypeCoercions.stringToPrimitive(value.toString(), targetType);
            }
            throw new ClassCoercionException("Cannot cast " + sourceWrapType + " (" + value + ") to " + targetType);
        }
        if (sourceWrapType == Boolean.class) {
            throw new ClassCoercionException("Cannot cast " + sourceWrapType + " (" + value + ") to " + targetType);
        }
        long v = 0L;
        boolean islong = true;
        if (sourceWrapType == Character.class) {
            v = ((Character)value).charValue();
        } else if (sourceWrapType == Byte.class) {
            v = ((Byte)value).byteValue();
        } else if (sourceWrapType == Short.class) {
            v = ((Short)value).shortValue();
        } else if (sourceWrapType == Integer.class) {
            v = ((Integer)value).intValue();
        } else if (sourceWrapType == Long.class) {
            v = (Long)value;
        } else {
            islong = false;
        }
        if (islong) {
            if (targetWrapType == Character.class) {
                return (T)Character.valueOf((char)v);
            }
            if (targetWrapType == Byte.class) {
                return (T)Byte.valueOf((byte)v);
            }
            if (targetWrapType == Short.class) {
                return (T)Short.valueOf((short)v);
            }
            if (targetWrapType == Integer.class) {
                return (T)Integer.valueOf((int)v);
            }
            if (targetWrapType == Long.class) {
                return (T)Long.valueOf(v);
            }
            if (targetWrapType == Float.class) {
                return (T)Float.valueOf(v);
            }
            if (targetWrapType == Double.class) {
                return (T)Double.valueOf(v);
            }
            throw new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType);
        }
        double d = 0.0;
        boolean isdouble = true;
        if (sourceWrapType == Float.class) {
            d = ((Float)value).floatValue();
        } else if (sourceWrapType == Double.class) {
            d = (Double)value;
        } else {
            isdouble = false;
        }
        if (isdouble) {
            if (targetWrapType == Character.class) {
                return (T)Character.valueOf((char)d);
            }
            if (targetWrapType == Byte.class) {
                return (T)Byte.valueOf((byte)d);
            }
            if (targetWrapType == Short.class) {
                return (T)Short.valueOf((short)d);
            }
            if (targetWrapType == Integer.class) {
                return (T)Integer.valueOf((int)d);
            }
            if (targetWrapType == Long.class) {
                return (T)Long.valueOf((long)d);
            }
            if (targetWrapType == Float.class) {
                return (T)Float.valueOf((float)d);
            }
            if (targetWrapType == Double.class) {
                return (T)Double.valueOf(d);
            }
            throw new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType);
        }
        throw new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType);
    }

    public static boolean isPrimitiveOrBoxer(Class<?> type) {
        return Primitives.allPrimitiveTypes().contains(type) || Primitives.allWrapperTypes().contains(type);
    }

    public static <T> T stringToPrimitive(String value, Class<T> targetType) {
        assert (Primitives.allPrimitiveTypes().contains(targetType) || Primitives.allWrapperTypes().contains(targetType)) : "targetType=" + targetType;
        if (targetType == Character.class || targetType == Character.TYPE) {
            if (value.length() == 1) {
                return (T)Character.valueOf(value.charAt(0));
            }
            if (value.length() != 1) {
                throw new ClassCoercionException("Cannot coerce type String to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
            }
        }
        value = value.trim();
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            if ("true".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            if ("yes".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("no".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            if ("t".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("f".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            if ("y".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("n".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            throw new ClassCoercionException("Cannot coerce type String to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
        }
        Class wrappedType = Primitives.allPrimitiveTypes().contains(targetType) ? Primitives.wrap(targetType) : targetType;
        try {
            return (T)wrappedType.getMethod("valueOf", String.class).invoke(null, value);
        }
        catch (Exception e) {
            ClassCoercionException tothrow = new ClassCoercionException("Cannot coerce type String to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
            tothrow.initCause(e);
            throw tothrow;
        }
    }

    public static String getVerySimpleName(Class c) {
        String s = c.getSimpleName();
        if (s.indexOf(36) >= 0) {
            s = s.substring(s.lastIndexOf(36) + 1);
        }
        return s;
    }

    public static Object getMatchingConstructor(Class target, Object ... arguments) {
        Constructor<?>[] cc;
        for (Constructor<?> c : cc = target.getConstructors()) {
            if (c.getParameterTypes().length != arguments.length) continue;
            boolean matches = true;
            Class<?>[] tt = c.getParameterTypes();
            for (int i = 0; i < tt.length; ++i) {
                if (arguments[i] == null || tt[i].isInstance(arguments[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return c;
        }
        return null;
    }

    public static synchronized <A, B> Function registerAdapter(Class<A> sourceType, Class<B> targetType, Function<? super A, B> fn) {
        return (Function)registry.put(targetType, sourceType, fn);
    }

    public static void initStandardAdapters() {
        TypeCoercions.registerAdapter(CharSequence.class, String.class, new Function<CharSequence, String>(){

            public String apply(CharSequence input) {
                return input.toString();
            }
        });
        TypeCoercions.registerAdapter(byte[].class, String.class, new Function<byte[], String>(){

            public String apply(byte[] input) {
                return new String(input);
            }
        });
        TypeCoercions.registerAdapter(Collection.class, Set.class, new Function<Collection, Set>(){

            public Set apply(Collection input) {
                return Sets.newLinkedHashSet((Iterable)input);
            }
        });
        TypeCoercions.registerAdapter(Collection.class, List.class, new Function<Collection, List>(){

            public List apply(Collection input) {
                return Lists.newArrayList((Iterable)input);
            }
        });
        TypeCoercions.registerAdapter(String.class, InetAddress.class, new Function<String, InetAddress>(){

            public InetAddress apply(String input) {
                return Networking.getInetAddressWithFixedName((String)input);
            }
        });
        TypeCoercions.registerAdapter(String.class, HostAndPort.class, new Function<String, HostAndPort>(){

            public HostAndPort apply(String input) {
                return HostAndPort.fromString((String)input);
            }
        });
        TypeCoercions.registerAdapter(String.class, UserAndHostAndPort.class, new Function<String, UserAndHostAndPort>(){

            public UserAndHostAndPort apply(String input) {
                return UserAndHostAndPort.fromString((String)input);
            }
        });
        TypeCoercions.registerAdapter(String.class, Cidr.class, new Function<String, Cidr>(){

            public Cidr apply(String input) {
                return new Cidr(input);
            }
        });
        TypeCoercions.registerAdapter(String.class, URL.class, new Function<String, URL>(){

            public URL apply(String input) {
                try {
                    return new URL(input);
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
        TypeCoercions.registerAdapter(String.class, URI.class, new Function<String, URI>(){

            public URI apply(String input) {
                return URI.create(input);
            }
        });
        TypeCoercions.registerAdapter(Closure.class, ConfigurableEntityFactory.class, new Function<Closure, ConfigurableEntityFactory>(){

            public ConfigurableEntityFactory apply(Closure input) {
                return new ClosureEntityFactory(input);
            }
        });
        Function ignoredVarHereToAllowSuppressDeprecationWarning1 = TypeCoercions.registerAdapter(EntityFactory.class, ConfigurableEntityFactory.class, new Function<EntityFactory, ConfigurableEntityFactory>(){

            public ConfigurableEntityFactory apply(EntityFactory input) {
                if (input instanceof ConfigurableEntityFactory) {
                    return (ConfigurableEntityFactory)input;
                }
                return new ConfigurableEntityFactoryFromEntityFactory(input);
            }
        });
        Function ignoredVarHereToAllowSuppressDeprecationWarning2 = TypeCoercions.registerAdapter(Closure.class, EntityFactory.class, new Function<Closure, EntityFactory>(){

            public EntityFactory apply(Closure input) {
                return new ClosureEntityFactory(input);
            }
        });
        TypeCoercions.registerAdapter(Closure.class, Predicate.class, new Function<Closure, Predicate>(){

            public Predicate<?> apply(final Closure closure) {
                return new Predicate<Object>(){

                    public boolean apply(Object input) {
                        return (Boolean)closure.call(input);
                    }
                };
            }
        });
        TypeCoercions.registerAdapter(Closure.class, Function.class, new Function<Closure, Function>(){

            public Function apply(final Closure closure) {
                return new Function(){

                    public Object apply(Object input) {
                        return closure.call(input);
                    }
                };
            }
        });
        TypeCoercions.registerAdapter(Object.class, Duration.class, new Function<Object, Duration>(){

            public Duration apply(Object input) {
                return Duration.of((Object)input);
            }
        });
        TypeCoercions.registerAdapter(Object.class, TimeDuration.class, new Function<Object, TimeDuration>(){

            public TimeDuration apply(Object input) {
                log.warn("deprecated automatic coercion of Object to TimeDuration (set breakpoint in TypeCoercions to inspect, convert to Duration)");
                return JavaGroovyEquivalents.toTimeDuration((Object)input);
            }
        });
        TypeCoercions.registerAdapter(TimeDuration.class, Long.class, new Function<TimeDuration, Long>(){

            public Long apply(TimeDuration input) {
                log.warn("deprecated automatic coercion of TimeDuration to Long (set breakpoint in TypeCoercions to inspect, use Duration instead of Long!)");
                return input.toMilliseconds();
            }
        });
        TypeCoercions.registerAdapter(Integer.class, AtomicLong.class, new Function<Integer, AtomicLong>(){

            public AtomicLong apply(Integer input) {
                return new AtomicLong(input.intValue());
            }
        });
        TypeCoercions.registerAdapter(Long.class, AtomicLong.class, new Function<Long, AtomicLong>(){

            public AtomicLong apply(Long input) {
                return new AtomicLong(input);
            }
        });
        TypeCoercions.registerAdapter(String.class, AtomicLong.class, new Function<String, AtomicLong>(){

            public AtomicLong apply(String input) {
                return new AtomicLong(Long.parseLong(input.trim()));
            }
        });
        TypeCoercions.registerAdapter(Integer.class, AtomicInteger.class, new Function<Integer, AtomicInteger>(){

            public AtomicInteger apply(Integer input) {
                return new AtomicInteger(input);
            }
        });
        TypeCoercions.registerAdapter(String.class, AtomicInteger.class, new Function<String, AtomicInteger>(){

            public AtomicInteger apply(String input) {
                return new AtomicInteger(Integer.parseInt(input.trim()));
            }
        });
        TypeCoercions.registerAdapter(String.class, Number.class, new Function<String, Number>(){

            public Number apply(String input) {
                return Double.valueOf(input);
            }
        });
        TypeCoercions.registerAdapter(BigDecimal.class, Double.class, new Function<BigDecimal, Double>(){

            public Double apply(BigDecimal input) {
                return input.doubleValue();
            }
        });
        TypeCoercions.registerAdapter(BigInteger.class, Long.class, new Function<BigInteger, Long>(){

            public Long apply(BigInteger input) {
                return input.longValue();
            }
        });
        TypeCoercions.registerAdapter(BigInteger.class, Integer.class, new Function<BigInteger, Integer>(){

            public Integer apply(BigInteger input) {
                return input.intValue();
            }
        });
        TypeCoercions.registerAdapter(String.class, BigDecimal.class, new Function<String, BigDecimal>(){

            public BigDecimal apply(String input) {
                return new BigDecimal(input);
            }
        });
        TypeCoercions.registerAdapter(Double.class, BigDecimal.class, new Function<Double, BigDecimal>(){

            public BigDecimal apply(Double input) {
                return BigDecimal.valueOf(input);
            }
        });
        TypeCoercions.registerAdapter(String.class, BigInteger.class, new Function<String, BigInteger>(){

            public BigInteger apply(String input) {
                return new BigInteger(input);
            }
        });
        TypeCoercions.registerAdapter(Long.class, BigInteger.class, new Function<Long, BigInteger>(){

            public BigInteger apply(Long input) {
                return BigInteger.valueOf(input);
            }
        });
        TypeCoercions.registerAdapter(Integer.class, BigInteger.class, new Function<Integer, BigInteger>(){

            public BigInteger apply(Integer input) {
                return BigInteger.valueOf(input.intValue());
            }
        });
        TypeCoercions.registerAdapter(String.class, Class.class, new Function<String, Class>(){

            public Class apply(String input) {
                try {
                    return Class.forName(input);
                }
                catch (ClassNotFoundException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
        TypeCoercions.registerAdapter(String.class, AttributeSensor.class, new Function<String, AttributeSensor>(){

            public AttributeSensor apply(String input) {
                return new BasicAttributeSensor<Object>(Object.class, input);
            }
        });
        TypeCoercions.registerAdapter(String.class, List.class, new Function<String, List>(){

            public List<String> apply(String input) {
                return StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible((String)input);
            }
        });
        TypeCoercions.registerAdapter(String.class, Set.class, new Function<String, Set>(){

            public Set<String> apply(String input) {
                return MutableSet.copyOf((Iterable)StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible((String)input)).asUnmodifiable();
            }
        });
        TypeCoercions.registerAdapter(String.class, QuorumCheck.class, new Function<String, QuorumCheck>(){

            public QuorumCheck apply(String input) {
                return QuorumCheck.QuorumChecks.of((String)input);
            }
        });
        TypeCoercions.registerAdapter(Iterable.class, String[].class, new Function<Iterable, String[]>(){

            @Nullable
            public String[] apply(@Nullable Iterable list) {
                if (list == null) {
                    return null;
                }
                String[] result = new String[Iterables.size((Iterable)list)];
                int count = 0;
                for (Object element : list) {
                    result[count++] = TypeCoercions.coerce(element, String.class);
                }
                return result;
            }
        });
        TypeCoercions.registerAdapter(Iterable.class, Integer[].class, new Function<Iterable, Integer[]>(){

            @Nullable
            public Integer[] apply(@Nullable Iterable list) {
                if (list == null) {
                    return null;
                }
                Integer[] result = new Integer[Iterables.size((Iterable)list)];
                int count = 0;
                for (Object element : list) {
                    result[count++] = TypeCoercions.coerce(element, Integer.class);
                }
                return result;
            }
        });
        TypeCoercions.registerAdapter(Iterable.class, int[].class, new Function<Iterable, int[]>(){

            @Nullable
            public int[] apply(@Nullable Iterable list) {
                if (list == null) {
                    return null;
                }
                int[] result = new int[Iterables.size((Iterable)list)];
                int count = 0;
                for (Object element : list) {
                    result[count++] = TypeCoercions.coerce(element, Integer.TYPE);
                }
                return result;
            }
        });
        TypeCoercions.registerAdapter(String.class, Map.class, new Function<String, Map>(){

            public Map apply(String input) {
                Exception error = null;
                if (!input.trim().startsWith("{")) {
                    try {
                        return this.apply("{ " + input + " }");
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        error = e;
                    }
                }
                try {
                    return (Map)Yamls.getAs((Object)Yamls.parseAll((String)input), Map.class);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (error != null && input.indexOf(10) == -1) {
                        e = error;
                    }
                    throw new IllegalArgumentException("Cannot parse string as map with flexible YAML parsing; " + (e instanceof ClassCastException ? "yaml treats it as a string" : (e instanceof IllegalArgumentException && Strings.isNonEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "" + e)));
                }
            }
        });
    }

    static {
        BrooklynInitialization.initTypeCoercionStandardAdapters();
    }
}

