/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.file;

import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.util.ResourceUtils;
import brooklyn.util.file.ArchiveUtils;
import brooklyn.util.net.Urls;
import brooklyn.util.task.Tasks;
import java.util.Map;

public class ArchiveTasks {
    public static TaskFactory<?> deploy(ResourceUtils optionalResolver, String archiveUrl, SshMachineLocation machine, String destDir) {
        return ArchiveTasks.deploy(optionalResolver, null, archiveUrl, machine, destDir, false, null, null);
    }

    public static TaskFactory<?> deploy(final ResourceUtils resolver, final Map<String, ?> props, final String archiveUrl, final SshMachineLocation machine, final String destDir, final boolean allowNonarchivesOrKeepArchiveAfterDeploy, final String optionalTmpDir, final String optionalDestFile) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                return Tasks.builder().name("deploying " + Urls.getBasename((String)archiveUrl)).description("installing " + archiveUrl + " and unpacking to " + destDir).body(new Runnable(){

                    @Override
                    public void run() {
                        boolean unpacked = ArchiveUtils.deploy(resolver, props, archiveUrl, machine, destDir, allowNonarchivesOrKeepArchiveAfterDeploy, optionalTmpDir, optionalDestFile);
                        if (!unpacked && !allowNonarchivesOrKeepArchiveAfterDeploy) {
                            throw new IllegalStateException("Unable to unpack archive from " + archiveUrl + "; not able to infer archive type");
                        }
                    }
                }).build();
            }
        };
    }
}

