/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.config;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.JavaClassNames;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBag {
    private static final Logger log = LoggerFactory.getLogger(ConfigBag.class);
    public static final ConfigBag EMPTY = new ConfigBag().setDescription("immutable empty config bag").seal();
    protected String description;
    private Map<String, Object> config;
    private final Map<String, Object> unusedConfig;
    private final boolean live;
    private boolean sealed = false;

    public static ConfigBag newInstance() {
        return new ConfigBag();
    }

    public static ConfigBag newLiveInstance(Map<String, Object> storage) {
        return new ConfigBag((Map)Preconditions.checkNotNull(storage, (Object)"storage map must be specified"));
    }

    public static ConfigBag newInstance(Map<?, ?> config) {
        ConfigBag result = new ConfigBag();
        result.putAll(config);
        return result;
    }

    public static ConfigBag newInstanceCopying(ConfigBag configBag) {
        return new ConfigBag().copy(configBag).setDescription(configBag.getDescription());
    }

    @Beta
    public static ConfigBag newInstanceExtending(ConfigBag parentBag) {
        return new ConfigBagExtendingParent(parentBag);
    }

    @Beta
    public static ConfigBag newInstanceExtending(ConfigBag configBag, Map<?, ?> optionalAdditionalValues) {
        return ConfigBag.newInstanceExtending(configBag).putAll(optionalAdditionalValues);
    }

    @Deprecated
    @Beta
    public static ConfigBag newInstanceWithInnerClass(final ConfigBag configBag, Map<?, ?> optionalAdditionalValues) {
        return new ConfigBag(){

            @Override
            public void markUsed(String key) {
                super.markUsed(key);
                configBag.markUsed(key);
            }
        }.copy(configBag).putAll(optionalAdditionalValues);
    }

    public ConfigBag() {
        this.config = new LinkedHashMap<String, Object>();
        this.unusedConfig = new LinkedHashMap<String, Object>();
        this.live = false;
    }

    private ConfigBag(Map<String, Object> storage) {
        this.config = storage;
        this.unusedConfig = new LinkedHashMap<String, Object>();
        this.live = true;
    }

    public ConfigBag setDescription(String description) {
        if (this.sealed) {
            throw new IllegalStateException("Cannot set description to '" + description + "': this config bag has been sealed and is now immutable.");
        }
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized Map<String, Object> getAllConfig() {
        return MutableMap.copyOf(this.config).asUnmodifiable();
    }

    public synchronized Map<ConfigKey<?>, ?> getAllConfigAsConfigKeyMap() {
        MutableMap result = MutableMap.of();
        for (Map.Entry<String, Object> entry : this.config.entrySet()) {
            result.put(ConfigKeys.newConfigKey(Object.class, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public Map<String, Object> getAllConfigMutable() {
        if (this.live) {
            return this.sealed ? MutableMap.copyOf(this.config).asUnmodifiable() : this.config;
        }
        return this.config;
    }

    public synchronized Map<String, Object> getUnusedConfig() {
        return MutableMap.copyOf(this.unusedConfig).asUnmodifiable();
    }

    public Map<String, Object> getUnusedConfigMutable() {
        return this.unusedConfig;
    }

    public ConfigBag putAll(Map<?, ?> addlConfig) {
        if (addlConfig == null) {
            return this;
        }
        for (Map.Entry<?, ?> e : addlConfig.entrySet()) {
            this.putAsStringKey(e.getKey(), e.getValue());
        }
        return this;
    }

    public ConfigBag putAll(ConfigBag addlConfig) {
        return this.putAll(addlConfig.getAllConfig());
    }

    public <T> ConfigBag putIfAbsent(ConfigKey<T> key, T value) {
        return this.putIfAbsent((Map<?, ?>)MutableMap.of(key, value));
    }

    public ConfigBag putAsStringKeyIfAbsent(Object key, Object value) {
        return this.putIfAbsent((Map<?, ?>)MutableMap.of((Object)key, (Object)value));
    }

    public synchronized ConfigBag putIfAbsent(Map<?, ?> propertiesToSet) {
        if (propertiesToSet == null) {
            return this;
        }
        for (Map.Entry<?, ?> entry : propertiesToSet.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof ConfigKey.HasConfigKey) {
                key = ((ConfigKey.HasConfigKey)key).getConfigKey();
            }
            if (key instanceof ConfigKey) {
                if (this.containsKey((ConfigKey)key)) continue;
                this.putAsStringKey(key, entry.getValue());
                continue;
            }
            if (key instanceof String) {
                if (this.containsKey((String)key)) continue;
                this.putAsStringKey(key, entry.getValue());
                continue;
            }
            this.logInvalidKey(key);
        }
        return this;
    }

    public ConfigBag putIfAbsent(ConfigBag addlConfig) {
        return this.putIfAbsent(addlConfig.getAllConfig());
    }

    public <T> T put(ConfigKey<T> key, T value) {
        return (T)this.putStringKey(key.getName(), value);
    }

    public <T> ConfigBag putIfNotNull(ConfigKey<T> key, T value) {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public <T> ConfigBag putIfAbsentAndNotNull(ConfigKey<T> key, T value) {
        if (value != null) {
            this.putIfAbsent(key, value);
        }
        return this;
    }

    public <T> ConfigBag configure(ConfigKey<T> key, T value) {
        this.putStringKey(key.getName(), value);
        return this;
    }

    public <T> ConfigBag configureStringKey(String key, T value) {
        this.putStringKey(key, value);
        return this;
    }

    protected synchronized void putAsStringKey(Object key, Object value) {
        if (key instanceof ConfigKey.HasConfigKey) {
            key = ((ConfigKey.HasConfigKey)key).getConfigKey();
        }
        if (key instanceof ConfigKey) {
            key = ((ConfigKey)key).getName();
        }
        if (key instanceof String) {
            this.putStringKey((String)key, value);
        } else {
            this.logInvalidKey(key);
        }
    }

    protected void logInvalidKey(Object key) {
        String message = (key == null ? "Invalid key 'null'" : "Invalid key type " + key.getClass().getCanonicalName() + " (" + key + ")") + " being used for configuration, ignoring";
        log.debug(message, new Throwable("Source of " + message));
        log.warn(message);
    }

    public synchronized Object putStringKey(String key, Object value) {
        if (this.sealed) {
            throw new IllegalStateException("Cannot insert " + key + "=" + value + ": this config bag has been sealed and is now immutable.");
        }
        boolean isNew = !this.config.containsKey(key);
        boolean isUsed = !isNew && !this.unusedConfig.containsKey(key);
        Object old = this.config.put(key, value);
        if (!isUsed) {
            this.unusedConfig.put(key, value);
        }
        return old;
    }

    public Object putStringKeyIfHasValue(String key, Maybe<?> value) {
        if (value.isPresent()) {
            return this.putStringKey(key, value.get());
        }
        return null;
    }

    public Object putStringKeyIfNotNull(String key, Object value) {
        if (value != null) {
            return this.putStringKey(key, value);
        }
        return null;
    }

    public boolean containsKey(ConfigKey.HasConfigKey<?> key) {
        return this.containsKey(key.getConfigKey());
    }

    public boolean containsKey(ConfigKey<?> key) {
        return this.containsKey(key.getName());
    }

    public synchronized boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public <T> T get(ConfigKey<T> key) {
        return this.get(key, true);
    }

    public Object getStringKey(String key) {
        return this.getStringKeyMaybe(key).orNull();
    }

    @Nonnull
    public Maybe<Object> getStringKeyMaybe(String key) {
        return this.getStringKeyMaybe(key, true);
    }

    public <T> T peek(ConfigKey<T> key) {
        return this.get(key, false);
    }

    public synchronized <T> T getFirst(ConfigKey<T> preferredKey, ConfigKey<T> ... otherCurrentKeysInOrderOfPreference) {
        if (this.containsKey(preferredKey)) {
            return this.get(preferredKey);
        }
        for (ConfigKey<T> key : otherCurrentKeysInOrderOfPreference) {
            if (!this.containsKey(key)) continue;
            return this.get(key);
        }
        return this.get(preferredKey);
    }

    public Object getWithDeprecation(ConfigKey<?> key, ConfigKey<?> ... deprecatedKeys) {
        return this.getWithDeprecation(new ConfigKey[]{key}, deprecatedKeys);
    }

    public synchronized Object getWithDeprecation(ConfigKey<?>[] currentKeysInOrderOfPreference, ConfigKey<?> ... deprecatedKeys) {
        ConfigKey<?> preferredKeyProvidingValue = null;
        Object result = null;
        boolean found = false;
        for (ConfigKey<?> key : currentKeysInOrderOfPreference) {
            if (!this.containsKey(key)) continue;
            preferredKeyProvidingValue = key;
            result = this.get(preferredKeyProvidingValue);
            found = true;
            break;
        }
        ConfigKey<?> deprecatedKeyProvidingValue = null;
        Object deprecatedResult = null;
        boolean foundDeprecated = false;
        for (ConfigKey<?> deprecatedKey : deprecatedKeys) {
            Object x = null;
            boolean foundX = false;
            if (this.containsKey(deprecatedKey)) {
                x = this.get(deprecatedKey);
                foundX = true;
            }
            if (!foundX) continue;
            if (found) {
                if (!Objects.equal(result, x)) {
                    log.warn("Conflicting value from deprecated key " + deprecatedKey + ", value " + x + "; using preferred key " + preferredKeyProvidingValue + " value " + result);
                    continue;
                }
                log.info("Deprecated key " + deprecatedKey + " ignored; has same value as preferred key " + preferredKeyProvidingValue + " (" + result + ")");
                continue;
            }
            if (foundDeprecated) {
                if (!Objects.equal(result, x)) {
                    log.warn("Conflicting values from deprecated keys: using " + deprecatedKeyProvidingValue + " instead of " + deprecatedKey + " (value " + deprecatedResult + " instead of " + x + ")");
                    continue;
                }
                log.info("Deprecated key " + deprecatedKey + " ignored; has same value as other deprecated key " + preferredKeyProvidingValue + " (" + deprecatedResult + ")");
                continue;
            }
            log.warn("Deprecated key " + deprecatedKey + " detected (supplying value " + x + "), " + "; recommend changing to preferred key '" + currentKeysInOrderOfPreference[0] + "'; this will not be supported in future versions");
            deprecatedResult = x;
            deprecatedKeyProvidingValue = deprecatedKey;
            foundDeprecated = true;
        }
        if (found) {
            return result;
        }
        if (foundDeprecated) {
            return deprecatedResult;
        }
        return currentKeysInOrderOfPreference[0].getDefaultValue();
    }

    protected <T> T get(ConfigKey<T> key, boolean markUsed) {
        return ConfigBag.coerceFirstNonNullKeyValue(key, this.getStringKey(key.getName(), markUsed));
    }

    public static <T> T coerceFirstNonNullKeyValue(ConfigKey<T> key, Object ... values) {
        for (Object o : values) {
            if (o == null) continue;
            return TypeCoercions.coerce(o, key.getTypeToken());
        }
        return TypeCoercions.coerce(key.getDefaultValue(), key.getTypeToken());
    }

    protected Object getStringKey(String key, boolean markUsed) {
        return this.getStringKeyMaybe(key, markUsed).orNull();
    }

    protected synchronized Maybe<Object> getStringKeyMaybe(String key, boolean markUsed) {
        if (this.config.containsKey(key)) {
            if (markUsed) {
                this.markUsed(key);
            }
            return Maybe.of((Object)this.config.get(key));
        }
        return Maybe.absent();
    }

    public synchronized void markUsed(String key) {
        this.unusedConfig.remove(key);
    }

    public synchronized void clear() {
        if (this.sealed) {
            throw new IllegalStateException("Cannot clear this config bag has been sealed and is now immutable.");
        }
        this.config.clear();
        this.unusedConfig.clear();
    }

    public ConfigBag removeAll(ConfigKey<?> ... keys) {
        for (ConfigKey<?> key : keys) {
            this.remove(key);
        }
        return this;
    }

    public synchronized void remove(ConfigKey<?> key) {
        this.remove(key.getName());
    }

    public ConfigBag removeAll(Iterable<String> keys) {
        for (String key : keys) {
            this.remove(key);
        }
        return this;
    }

    public synchronized void remove(String key) {
        if (this.sealed) {
            throw new IllegalStateException("Cannot remove " + key + ": this config bag has been sealed and is now immutable.");
        }
        this.config.remove(key);
        this.unusedConfig.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBag copy(ConfigBag other) {
        if (other == null) {
            ConfigBag configBag = this;
            synchronized (configBag) {
                return this.copyWhileSynched(other);
            }
        }
        if (System.identityHashCode(other) < System.identityHashCode(this)) {
            ConfigBag configBag = other;
            synchronized (configBag) {
                ConfigBag configBag2 = this;
                synchronized (configBag2) {
                    return this.copyWhileSynched(other);
                }
            }
        }
        ConfigBag configBag = this;
        synchronized (configBag) {
            ConfigBag configBag3 = other;
            synchronized (configBag3) {
                return this.copyWhileSynched(other);
            }
        }
    }

    protected ConfigBag copyWhileSynched(ConfigBag other) {
        if (this.sealed) {
            throw new IllegalStateException("Cannot copy " + other + " to " + this + ": this config bag has been sealed and is now immutable.");
        }
        this.putAll(other.getAllConfig());
        this.markAll((Iterable<String>)Sets.difference(other.getAllConfig().keySet(), other.getUnusedConfig().keySet()));
        this.setDescription(other.getDescription());
        return this;
    }

    public synchronized int size() {
        return this.config.size();
    }

    public synchronized boolean isEmpty() {
        return this.config.isEmpty();
    }

    public ConfigBag markAll(Iterable<String> usedFlags) {
        for (String flag : usedFlags) {
            this.markUsed(flag);
        }
        return this;
    }

    public synchronized boolean isUnused(ConfigKey<?> key) {
        return this.unusedConfig.containsKey(key.getName());
    }

    public ConfigBag seal() {
        this.sealed = true;
        if (!this.live) {
            this.config = this.getAllConfig();
        }
        return this;
    }

    public Map<String, Object> getAllConfigRaw() {
        return this.getAllConfigMutable();
    }

    public String toString() {
        return JavaClassNames.simpleClassName((Object)this) + "[" + this.getAllConfigRaw() + "]";
    }

    private static class ConfigBagExtendingParent
    extends ConfigBag {
        ConfigBag parentBag;

        private ConfigBagExtendingParent(ConfigBag parentBag) {
            this.parentBag = parentBag;
            this.copy(parentBag);
        }

        @Override
        public void markUsed(String key) {
            super.markUsed(key);
            if (this.parentBag != null) {
                this.parentBag.markUsed(key);
            }
        }
    }
}

