/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util;

import brooklyn.catalog.internal.BasicBrooklynCatalog;
import brooklyn.internal.BrooklynInitialization;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.http.HttpTool;
import brooklyn.util.javalang.Threads;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.DataUriSchemeParser;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);
    private static final List<Function<Object, BrooklynClassLoadingContext>> classLoaderProviders = Lists.newCopyOnWriteArrayList();
    private BrooklynClassLoadingContext loader = null;
    private String context = null;
    private Object contextObject = null;
    private static final Pattern pattern;

    public static final ResourceUtils create(ClassLoader loader, Object contextObject, String contextMessage) {
        return new ResourceUtils(loader, contextObject, contextMessage);
    }

    public static final ResourceUtils create(BrooklynClassLoadingContext loader, Object contextObject, String contextMessage) {
        return new ResourceUtils(loader, contextObject, contextMessage);
    }

    public static final ResourceUtils create(Object contextObject, String contextMessage) {
        return new ResourceUtils(contextObject, contextMessage);
    }

    public static final ResourceUtils create(Object contextObject) {
        return new ResourceUtils(contextObject);
    }

    public static final ResourceUtils create() {
        return new ResourceUtils(null);
    }

    public ResourceUtils(ClassLoader loader, Object contextObject, String contextMessage) {
        this(ResourceUtils.getClassLoadingContextInternal(loader, contextObject), contextObject, contextMessage);
    }

    public ResourceUtils(BrooklynClassLoadingContext loader, Object contextObject, String contextMessage) {
        this.loader = loader;
        this.contextObject = contextObject;
        this.context = contextMessage;
    }

    public ResourceUtils(Object contextObject, String contextMessage) {
        this(contextObject == null ? null : ResourceUtils.getClassLoadingContextInternal(null, contextObject), contextObject, contextMessage);
    }

    public ResourceUtils(Object contextObject) {
        this(contextObject, Strings.toString((Object)contextObject));
    }

    public static void addClassLoaderProvider(Function<Object, BrooklynClassLoadingContext> provider) {
        classLoaderProviders.add(provider);
    }

    protected static BrooklynClassLoadingContext getClassLoadingContextInternal(ClassLoader loader, Object contextObject) {
        if (contextObject instanceof BrooklynClassLoadingContext) {
            return (BrooklynClassLoadingContext)contextObject;
        }
        for (Function<Object, BrooklynClassLoadingContext> provider : classLoaderProviders) {
            BrooklynClassLoadingContext result = (BrooklynClassLoadingContext)provider.apply(contextObject);
            if (result == null) continue;
            return result;
        }
        BrooklynClassLoadingContext bl = BasicBrooklynCatalog.BrooklynLoaderTracker.getLoader();
        ManagementContext mgmt = bl != null ? bl.getManagementContext() : null;
        ClassLoader cl = loader;
        if (cl == null) {
            cl = contextObject instanceof Class ? ((Class)contextObject).getClassLoader() : (contextObject instanceof ClassLoader ? (ClassLoader)contextObject : contextObject.getClass().getClassLoader());
        }
        return JavaBrooklynClassLoadingContext.create(mgmt, cl);
    }

    private BrooklynClassLoadingContext getLoader() {
        return this.loader != null ? this.loader : ResourceUtils.getClassLoadingContextInternal(null, this.contextObject != null ? this.contextObject : this);
    }

    public InputStream getResourceFromUrl(String url) {
        try {
            if (url == null) {
                throw new NullPointerException("Cannot read from null");
            }
            if (url == "") {
                throw new NullPointerException("Cannot read from empty string");
            }
            String orig = url;
            String protocol = Urls.getProtocol((String)url);
            if (protocol != null) {
                if ("classpath".equals(protocol)) {
                    try {
                        return this.getResourceViaClasspath(url);
                    }
                    catch (IOException e) {
                        throw new IOException("Error accessing " + orig + ": " + e, e);
                    }
                }
                if ("sftp".equals(protocol)) {
                    try {
                        return this.getResourceViaSftp(url);
                    }
                    catch (IOException e) {
                        throw new IOException("Error accessing " + orig + ": " + e, e);
                    }
                }
                if ("file".equals(protocol)) {
                    url = ResourceUtils.tidyFileUrl(url);
                }
                if ("data".equals(protocol)) {
                    return new DataUriSchemeParser(url).lax().parse().getDataAsInputStream();
                }
                if ("http".equals(protocol) || "https".equals(protocol)) {
                    return this.getResourceViaHttp(url);
                }
                return new URL(url).openStream();
            }
            try {
                File f;
                try {
                    URL u = this.getLoader().getResource(url);
                    if (u != null) {
                        return u.openStream();
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (url.startsWith("/")) {
                    String urlNoSlash = url;
                    while (urlNoSlash.startsWith("/")) {
                        urlNoSlash = urlNoSlash.substring(1);
                    }
                    URL u = this.getLoader().getResource(urlNoSlash);
                    if (u != null) {
                        return u.openStream();
                    }
                }
                if ((f = url.startsWith("~/") ? new File(Os.home(), url.substring(2)) : (url.startsWith("~\\") ? new File(Os.home(), url.substring(2)) : new File(url))).exists()) {
                    return new FileInputStream(f);
                }
            }
            catch (IOException e) {
                throw new IOException("Error accessing " + orig + ": " + e, e);
            }
            throw new IOException("'" + orig + "' not found on classpath or filesystem");
        }
        catch (Exception e) {
            if (this.context != null) {
                throw new RuntimeException("Error getting resource '" + url + "' for " + this.context + ": " + e, e);
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static URL tidy(URL url) {
        URL urlOut;
        URI out;
        URI in;
        try {
            in = url.toURI();
        }
        catch (URISyntaxException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        Matcher matcher = pattern.matcher(in.toString());
        if (matcher.matches()) {
            File home = new File(Os.home());
            File file = new File(home, matcher.group(1));
            out = file.toURI();
        } else if (in.getScheme().equals("file:")) {
            File file = new File(in);
            out = file.toURI();
        } else {
            out = in;
        }
        try {
            urlOut = out.toURL();
        }
        catch (MalformedURLException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (!urlOut.equals(url) && log.isDebugEnabled()) {
            log.debug("quietly changing " + url + " to " + urlOut);
        }
        return urlOut;
    }

    public static String tidyFileUrl(String url) {
        try {
            return ResourceUtils.tidy(new URL(url)).toString();
        }
        catch (MalformedURLException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Deprecated
    public static String mergeFilePaths(String ... items) {
        return Os.mergePaths((String[])items);
    }

    @Deprecated
    public static String tidyFilePath(String path) {
        return Os.tidyPath((String)path);
    }

    @Deprecated
    public static String getProtocol(String url) {
        return Urls.getProtocol((String)url);
    }

    private InputStream getResourceViaClasspath(String url) throws IOException {
        assert (url.startsWith("classpath:"));
        String subUrl = url.substring("classpath:".length());
        while (subUrl.startsWith("/")) {
            subUrl = subUrl.substring(1);
        }
        URL u = this.getLoader().getResource(subUrl);
        if (u != null) {
            return u.openStream();
        }
        throw new IOException(subUrl + " not found on classpath");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getResourceViaSftp(String url) throws IOException {
        String subUrl;
        assert (url.startsWith("sftp://"));
        int atIndex = (subUrl = url.substring("sftp://".length())).indexOf("@");
        int colonIndex = subUrl.indexOf(":", atIndex > 0 ? atIndex : 0);
        if (colonIndex <= 0 || colonIndex <= atIndex) {
            throw new IllegalArgumentException("Invalid sftp url (" + url + "); IP or hostname must be specified, such as sftp://localhost:/path/to/file");
        }
        if (subUrl.length() <= colonIndex + 1) {
            throw new IllegalArgumentException("Invalid sftp url (" + url + "); must specify path of remote file, such as sftp://localhost:/path/to/file");
        }
        String user = atIndex >= 0 ? subUrl.substring(0, atIndex) : null;
        String address = subUrl.substring(atIndex + 1, colonIndex);
        String path = subUrl.substring(colonIndex + 1);
        SshMachineLocation machine = new SshMachineLocation((Map)MutableMap.builder().putIfNotNull((Object)"user", (Object)user).put((Object)"address", (Object)InetAddress.getByName(address)).build());
        try {
            final File tempFile = Os.newTempFile((String)"brooklyn-sftp", (String)"tmp");
            tempFile.setReadable(true, true);
            machine.copyFrom(path, tempFile.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(tempFile){

                @Override
                public void close() throws IOException {
                    super.close();
                    tempFile.delete();
                }
            };
            return fileInputStream;
        }
        finally {
            Streams.closeQuietly((Closeable)machine);
        }
    }

    private InputStream getResourceViaHttp(String resource) throws IOException {
        HttpClient client;
        HttpResponse result;
        int statusCode;
        URI uri = URI.create(resource);
        HttpTool.HttpClientBuilder builder = HttpTool.httpClientBuilder().laxRedirect(true).uri(uri);
        Credentials credentials = this.getUrlCredentials(uri.getRawUserInfo());
        if (credentials != null) {
            builder.credentials(credentials);
        }
        if (HttpTool.isStatusCodeHealthy(statusCode = (result = (client = builder.build()).execute((HttpUriRequest)new HttpGet(resource))).getStatusLine().getStatusCode())) {
            HttpEntity entity = result.getEntity();
            if (entity != null) {
                return entity.getContent();
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        EntityUtils.consume((HttpEntity)result.getEntity());
        throw new IllegalStateException("Invalid response invoking " + resource + ": response code " + statusCode);
    }

    private Credentials getUrlCredentials(String userInfo) {
        if (userInfo != null) {
            String username;
            String[] arr = userInfo.split(":");
            String password = null;
            if (arr.length == 1) {
                username = this.urlDecode(arr[0]);
            } else if (arr.length == 2) {
                username = this.urlDecode(arr[0]);
                password = this.urlDecode(arr[1]);
            } else {
                return null;
            }
            return new UsernamePasswordCredentials(username, password);
        }
        return null;
    }

    private String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String getResourceAsString(String url) {
        try {
            return ResourceUtils.readFullyString(this.getResourceFromUrl(url));
        }
        catch (Exception e) {
            log.debug("ResourceUtils got error reading " + url + (this.context == null ? "" : " " + this.context) + " (rethrowing): " + e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String checkUrlExists(String url) {
        return this.checkUrlExists(url, null);
    }

    public String checkUrlExists(String url, String message) {
        InputStream s;
        if (url == null) {
            throw new NullPointerException("URL " + (message != null ? message + " " : "") + "must not be null");
        }
        try {
            s = this.getResourceFromUrl(url);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalArgumentException("Unable to access URL " + (message != null ? message : "") + ": " + url, e);
        }
        Streams.closeQuietly((Closeable)s);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesUrlExist(String url) {
        InputStream s = null;
        try {
            s = this.getResourceFromUrl(url);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Streams.closeQuietly((Closeable)s);
        }
    }

    public Optional<String> firstAvailableUrl(String ... urls) {
        for (String url : urls) {
            if (!this.doesUrlExist(url)) continue;
            return Optional.of((Object)url);
        }
        return Optional.absent();
    }

    public String getClassLoaderDir() {
        if (this.contextObject == null) {
            throw new IllegalArgumentException("No suitable context (" + this.context + ") to auto-detect classloader dir");
        }
        Class<?> cc = this.contextObject instanceof Class ? (Class<?>)this.contextObject : this.contextObject.getClass();
        return this.getClassLoaderDir(cc.getCanonicalName().replace('.', '/') + ".class");
    }

    public String getClassLoaderDir(String resourceInThatDir) {
        File file;
        resourceInThatDir = Strings.removeFromStart((String)resourceInThatDir, (String)"/");
        URL resourceUrl = this.getLoader().getResource(resourceInThatDir);
        if (resourceUrl == null) {
            throw new NoSuchElementException("Resource (" + resourceInThatDir + ") not found");
        }
        URL containerUrl = ResourceUtils.getContainerUrl(resourceUrl, resourceInThatDir);
        if (!"file".equals(containerUrl.getProtocol())) {
            throw new IllegalStateException("Resource (" + resourceInThatDir + ") not on file system (at " + containerUrl + ")");
        }
        try {
            file = new File(containerUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Resource (" + resourceInThatDir + ") found at invalid URI (" + containerUrl + ")", e);
        }
        if (!file.exists()) {
            throw new IllegalStateException("Context class url substring (" + containerUrl + ") not found on filesystem");
        }
        return file.getPath();
    }

    public static URL getContainerUrl(URL url, String resourceInThatDir) {
        boolean isJar = "jar".equals(url.getProtocol());
        if (isJar) {
            try {
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                url = connection.getJarFileURL();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        String path = url.toString();
        int i = path.indexOf(resourceInThatDir);
        if (i == -1) {
            throw new IllegalStateException("Resource path (" + resourceInThatDir + ") not in url substring (" + url + ")");
        }
        String parent = path.substring(0, i);
        try {
            url = new URL(parent);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Resource (" + resourceInThatDir + ") found at invalid URL parent (" + parent + ")", e);
        }
        return url;
    }

    @Deprecated
    public static String readFullyString(InputStream is) throws IOException {
        return Streams.readFullyString((InputStream)is);
    }

    @Deprecated
    public static byte[] readFullyBytes(InputStream is) throws IOException {
        return Streams.readFully((InputStream)is);
    }

    @Deprecated
    public static void copy(InputStream input, OutputStream output) throws IOException {
        Streams.copy((InputStream)input, (OutputStream)output);
    }

    @Deprecated
    public static File mkdirs(File dir) {
        return Os.mkdirs((File)dir);
    }

    @Deprecated
    public static File writeToTempFile(InputStream is, String prefix, String suffix) {
        return Os.writeToTempFile((InputStream)is, (String)prefix, (String)suffix);
    }

    @Deprecated
    public static File writeToTempFile(InputStream is, File tempDir, String prefix, String suffix) {
        return Os.writeToTempFile((InputStream)is, (File)tempDir, (String)prefix, (String)suffix);
    }

    @Deprecated
    public static File writeToTempFile(Properties props, String prefix, String suffix) {
        return Os.writePropertiesToTempFile((Properties)props, (String)prefix, (String)suffix);
    }

    @Deprecated
    public static File writeToTempFile(Properties props, File tempDir, String prefix, String suffix) {
        return Os.writePropertiesToTempFile((Properties)props, (File)tempDir, (String)prefix, (String)suffix);
    }

    @Deprecated
    public static Thread addShutdownHook(Runnable task) {
        return Threads.addShutdownHook((Runnable)task);
    }

    @Deprecated
    public static boolean removeShutdownHook(Thread hook) {
        return Threads.removeShutdownHook((Thread)hook);
    }

    @Deprecated
    public static String mergePaths(String ... items) {
        return Urls.mergePaths((String[])items);
    }

    static {
        BrooklynInitialization.initNetworking();
        pattern = Pattern.compile("^file:/*~/+(.*)$");
    }
}

