/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.basic;

import brooklyn.config.ConfigKey;
import brooklyn.config.internal.AbstractConfigMapImpl;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Sanitizer;
import brooklyn.event.basic.StructuredConfigKey;
import brooklyn.management.ExecutionContext;
import brooklyn.policy.basic.AbstractEntityAdjunct;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.internal.ConfigKeySelfExtracting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapImpl
extends AbstractConfigMapImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMapImpl.class);
    private final AbstractEntityAdjunct adjunct;

    public ConfigMapImpl(AbstractEntityAdjunct adjunct) {
        this.adjunct = (AbstractEntityAdjunct)Preconditions.checkNotNull((Object)adjunct, (Object)"AbstractEntityAdjunct must be specified");
    }

    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        ConfigKey ownKey;
        ConfigKey configKey = ownKey = this.adjunct != null ? (ConfigKey)GroovyJavaMethods.elvis(this.adjunct.getAdjunctType().getConfigKey(key.getName()), key) : key;
        if (ownKey instanceof ConfigKeySelfExtracting) {
            if (((ConfigKeySelfExtracting)ownKey).isSet(this.ownConfig)) {
                EntityLocal entity = this.adjunct.entity;
                ExecutionContext exec = entity != null ? ((EntityInternal)entity).getExecutionContext() : null;
                return ((ConfigKeySelfExtracting)ownKey).extractValue(this.ownConfig, exec);
            }
        } else {
            LOG.warn("Config key {} of {} is not a ConfigKeySelfExtracting; cannot retrieve value; returning default", (Object)ownKey, (Object)this);
        }
        return TypeCoercions.coerce(defaultValue != null ? defaultValue : ownKey.getDefaultValue(), key.getTypeToken());
    }

    public Maybe<Object> getConfigRaw(ConfigKey<?> key, boolean includeInherited) {
        if (this.ownConfig.containsKey(key)) {
            return Maybe.of(this.ownConfig.get(key));
        }
        return Maybe.absent();
    }

    public Map<ConfigKey<?>, Object> getAllConfig() {
        return Collections.unmodifiableMap(Maps.newLinkedHashMap((Map)this.ownConfig));
    }

    public Object setConfig(ConfigKey<?> key, Object v) {
        Object val = this.coerceConfigVal(key, v);
        if (key instanceof StructuredConfigKey) {
            return ((StructuredConfigKey)key).applyValueToMap(val, this.ownConfig);
        }
        return this.ownConfig.put(key, val);
    }

    public void addToLocalBag(Map<String, ?> vals) {
        for (Map.Entry<String, ?> entry : vals.entrySet()) {
            this.setConfig(ConfigKeys.newConfigKey(Object.class, entry.getKey()), entry.getValue());
        }
    }

    public ConfigMapImpl submap(Predicate<ConfigKey<?>> filter) {
        ConfigMapImpl m = new ConfigMapImpl(this.adjunct);
        for (Map.Entry entry : this.ownConfig.entrySet()) {
            if (!filter.apply(entry.getKey())) continue;
            m.ownConfig.put(entry.getKey(), entry.getValue());
        }
        return m;
    }

    public String toString() {
        return super.toString() + "[own=" + Sanitizer.sanitize(this.ownConfig) + "]";
    }
}

