/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.basic;

import brooklyn.config.ConfigKey;
import brooklyn.policy.EntityAdjunct;
import brooklyn.policy.basic.AbstractEntityAdjunct;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdjunctType
implements Serializable {
    private static final long serialVersionUID = -662979234559595903L;
    private static final Logger LOG = LoggerFactory.getLogger(AdjunctType.class);
    private final String name;
    private final Map<String, ConfigKey<?>> configKeys;
    private final Set<ConfigKey<?>> configKeysSet;

    public AdjunctType(AbstractEntityAdjunct adjunct) {
        this(adjunct.getClass(), adjunct);
    }

    protected AdjunctType(Class<? extends EntityAdjunct> clazz) {
        this(clazz, null);
    }

    private AdjunctType(Class<? extends EntityAdjunct> clazz, AbstractEntityAdjunct adjunct) {
        this.name = clazz.getCanonicalName();
        this.configKeys = Collections.unmodifiableMap(AdjunctType.findConfigKeys(clazz, null));
        this.configKeysSet = ImmutableSet.copyOf(this.configKeys.values());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Policy {} config keys: {}", (Object)this.name, (Object)Joiner.on((String)", ").join(this.configKeys.keySet()));
        }
    }

    AdjunctType(String name, Map<String, ConfigKey<?>> configKeys) {
        this.name = name;
        this.configKeys = ImmutableMap.copyOf(configKeys);
        this.configKeysSet = ImmutableSet.copyOf(this.configKeys.values());
    }

    public String getName() {
        return this.name;
    }

    public Set<ConfigKey<?>> getConfigKeys() {
        return this.configKeysSet;
    }

    public ConfigKey<?> getConfigKey(String name) {
        return this.configKeys.get(name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.configKeys});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdjunctType o = (AdjunctType)obj;
        if (!Objects.equal((Object)this.name, (Object)o.getName())) {
            return false;
        }
        return Objects.equal(this.getConfigKeys(), o.getConfigKeys());
    }

    public String toString() {
        return Objects.toStringHelper((String)this.name).add("configKeys", this.configKeys).toString();
    }

    protected static Map<String, ConfigKey<?>> findConfigKeys(Class<? extends EntityAdjunct> clazz, EntityAdjunct optionalInstance) {
        try {
            LinkedHashMap result = Maps.newLinkedHashMap();
            LinkedHashMap configFields = Maps.newLinkedHashMap();
            for (Field f : clazz.getFields()) {
                boolean isConfigKey = ConfigKey.class.isAssignableFrom(f.getType());
                if (!isConfigKey && !ConfigKey.HasConfigKey.class.isAssignableFrom(f.getType())) continue;
                if (!Modifier.isStatic(f.getModifiers())) {
                    LOG.warn("Discouraged use of non-static config key " + f + " defined in " + (optionalInstance != null ? optionalInstance : clazz));
                    if (optionalInstance == null) continue;
                }
                ConfigKey k = isConfigKey ? (ConfigKey)f.get(optionalInstance) : ((ConfigKey.HasConfigKey)f.get(optionalInstance)).getConfigKey();
                Field alternativeField = (Field)configFields.get(k.getName());
                Field definitiveField = alternativeField != null ? AdjunctType.inferSubbestField(alternativeField, f) : f;
                boolean skip = false;
                if (definitiveField != f && alternativeField.get(optionalInstance) == f.get(optionalInstance)) {
                    skip = true;
                }
                if (skip) continue;
                if (definitiveField == f) {
                    result.put(k.getName(), k);
                    configFields.put(k.getName(), f);
                    continue;
                }
                if (definitiveField != null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("multiple definitions for config key {} on {}; preferring that in sub-class: {} to {}", new Object[]{k.getName(), optionalInstance != null ? optionalInstance : clazz, alternativeField, f});
                    continue;
                }
                if (definitiveField != null) continue;
                LOG.warn("multiple definitions for config key {} on {}; preferring {} to {}", new Object[]{k.getName(), optionalInstance != null ? optionalInstance : clazz, alternativeField, f});
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Field inferSubbestField(Field f1, Field f2) {
        Class<?> c1 = f1.getDeclaringClass();
        Class<?> c2 = f2.getDeclaringClass();
        boolean isSuper1 = c1.isAssignableFrom(c2);
        boolean isSuper2 = c2.isAssignableFrom(c1);
        return isSuper1 ? (isSuper2 ? null : f2) : (isSuper2 ? f1 : null);
    }
}

