/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.basic;

import brooklyn.basic.BrooklynObject;
import brooklyn.entity.rebind.BasicPolicyRebindSupport;
import brooklyn.entity.rebind.RebindSupport;
import brooklyn.entity.trait.Configurable;
import brooklyn.mementos.PolicyMemento;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicyType;
import brooklyn.policy.basic.AbstractEntityAdjunct;
import brooklyn.policy.basic.PolicyDynamicType;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicy
extends AbstractEntityAdjunct
implements Policy,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(AbstractPolicy.class);
    protected String policyStatus;
    protected AtomicBoolean suspended = new AtomicBoolean(false);
    private final PolicyDynamicType policyType = new PolicyDynamicType(this);

    public AbstractPolicy() {
        this(Collections.emptyMap());
    }

    public AbstractPolicy(Map<?, ?> flags) {
        super((Map)flags);
        if (this.isLegacyConstruction() && !this.isLegacyNoConstructionInit()) {
            this.init();
        }
    }

    public PolicyType getPolicyType() {
        return this.policyType.getSnapshot();
    }

    public void suspend() {
        this.suspended.set(true);
    }

    public void resume() {
        this.suspended.set(false);
    }

    public boolean isSuspended() {
        if (this.suspended == null) {
            return true;
        }
        return this.suspended.get();
    }

    @Override
    public void destroy() {
        this.suspend();
        super.destroy();
    }

    @Override
    public boolean isRunning() {
        return !this.isSuspended() && !this.isDestroyed();
    }

    @Override
    protected void onChanged() {
        if (this.getManagementContext() != null) {
            this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)this);
        }
    }

    public RebindSupport<PolicyMemento> getRebindSupport() {
        return new BasicPolicyRebindSupport(this);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("running", this.isRunning()).toString();
    }
}

