/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.basic;

import brooklyn.basic.AbstractBrooklynObject;
import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigMap;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.trait.Configurable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEventListener;
import brooklyn.management.ExecutionContext;
import brooklyn.management.SubscriptionHandle;
import brooklyn.management.Task;
import brooklyn.management.internal.SubscriptionTracker;
import brooklyn.policy.EntityAdjunct;
import brooklyn.policy.basic.AdjunctType;
import brooklyn.policy.basic.ConfigMapImpl;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityAdjunct
extends AbstractBrooklynObject
implements BrooklynObjectInternal,
EntityAdjunct,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityAdjunct.class);
    private boolean _legacyNoConstructionInit;
    @Deprecated
    protected Map<String, Object> leftoverProperties = Maps.newLinkedHashMap();
    protected transient ExecutionContext execution;
    private final BasicConfigurationSupport config = new BasicConfigurationSupport();
    @Deprecated
    protected final ConfigMapImpl configsInternal = new ConfigMapImpl(this);
    @Deprecated
    protected final AdjunctType adjunctType = new AdjunctType(this);
    @SetFromFlag
    protected String name;
    protected transient EntityLocal entity;
    protected transient SubscriptionTracker _subscriptionTracker;
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    @SetFromFlag(value="uniqueTag")
    protected String uniqueTag;

    public AbstractEntityAdjunct() {
        this(Collections.emptyMap());
    }

    public AbstractEntityAdjunct(Map properties) {
        super(properties);
        boolean bl = this._legacyNoConstructionInit = properties != null && Boolean.TRUE.equals(properties.get("noConstructionInit"));
        if (this.isLegacyConstruction()) {
            boolean deferConstructionChecks;
            AbstractEntityAdjunct checkWeGetThis = this.configure(properties);
            assert (this.equals(checkWeGetThis)) : this + " configure method does not return itself; returns " + checkWeGetThis + " instead of " + this;
            boolean bl2 = deferConstructionChecks = properties.containsKey("deferConstructionChecks") && TypeCoercions.coerce(properties.get("deferConstructionChecks"), Boolean.class) != false;
            if (!deferConstructionChecks) {
                FlagUtils.checkRequiredFields(this);
            }
        }
    }

    @Deprecated
    public AbstractEntityAdjunct configure(Map flags) {
        boolean isFirstTime = true;
        Iterator iter = flags.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof ConfigKey)) continue;
            ConfigKey key = (ConfigKey)entry.getKey();
            if (this.adjunctType.getConfigKeys().contains(key)) {
                this.setConfig(key, entry.getValue());
                continue;
            }
            log.warn("Unknown configuration key {} for policy {}; ignoring", (Object)key, (Object)this);
            iter.remove();
        }
        ConfigBag bag = new ConfigBag().putAll(flags);
        FlagUtils.setFieldsFromFlags(this, bag, isFirstTime);
        FlagUtils.setAllConfigKeys(this, bag, false);
        this.leftoverProperties.putAll(bag.getUnusedConfig());
        flags.clear();
        flags.putAll(this.leftoverProperties);
        this.leftoverProperties = flags;
        if (!GroovyJavaMethods.truth((Object)this.name) && flags.containsKey("displayName")) {
            Preconditions.checkArgument((boolean)(flags.get("displayName") instanceof CharSequence), (Object)"'displayName' property should be a string");
            this.setDisplayName(flags.remove("displayName").toString());
        }
        for (Object flag : flags.keySet()) {
            ConfigKey<Object> key = ConfigKeys.newConfigKey(Object.class, Strings.toString(flag));
            if (this.config().getRaw(key).isPresent()) {
                log.warn("Config '" + flag + "' on " + this + " conflicts with key already set; ignoring");
                continue;
            }
            this.config().set(key, flags.get(flag));
        }
        return this;
    }

    @Beta
    protected boolean isLegacyNoConstructionInit() {
        return this._legacyNoConstructionInit;
    }

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        return this.config;
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    @Deprecated
    public Map<ConfigKey<?>, Object> getAllConfig() {
        return this.configsInternal.getAllConfig();
    }

    protected <K> K getRequiredConfig(ConfigKey<K> key) {
        Object result = this.config().get(key);
        if (result == null) {
            throw new NullPointerException("Value required for '" + key.getName() + "' in " + this);
        }
        return (K)result;
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, T val) {
        return (T)this.config().set(key, val);
    }

    @Deprecated
    @Beta
    public ConfigMap getConfigMap() {
        return this.configsInternal;
    }

    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        throw new UnsupportedOperationException("reconfiguring " + key + " unsupported for " + this);
    }

    @Override
    protected void onTagsChanged() {
        this.onChanged();
    }

    protected abstract void onChanged();

    protected AdjunctType getAdjunctType() {
        return this.adjunctType;
    }

    public String getDisplayName() {
        if (this.name != null && this.name.length() > 0) {
            return this.name;
        }
        return this.getClass().getCanonicalName();
    }

    @Deprecated
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public void setDisplayName(String name) {
        this.name = name;
    }

    @Deprecated
    public void setName(String name) {
        this.setDisplayName(name);
    }

    public void setEntity(EntityLocal entity) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("Cannot set entity on a destroyed entity adjunct");
        }
        this.entity = entity;
        if (entity != null && this.getCatalogItemId() == null) {
            this.setCatalogItemId(entity.getCatalogItemId());
        }
    }

    protected <T> void emit(Sensor<T> sensor, Object val) {
        Preconditions.checkState((this.entity != null ? 1 : 0) != 0, (Object)"entity must first be set");
        if (val == Entities.UNCHANGED) {
            return;
        }
        if (val == Entities.REMOVE) {
            ((EntityInternal)this.entity).removeAttribute((AttributeSensor)sensor);
            return;
        }
        Object newVal = TypeCoercions.coerce(val, sensor.getTypeToken());
        if (sensor instanceof AttributeSensor) {
            this.entity.setAttribute((AttributeSensor)sensor, newVal);
        } else {
            this.entity.emit(sensor, newVal);
        }
    }

    protected synchronized SubscriptionTracker getSubscriptionTracker() {
        if (this._subscriptionTracker != null) {
            return this._subscriptionTracker;
        }
        if (this.entity == null) {
            return null;
        }
        this._subscriptionTracker = new SubscriptionTracker(((EntityInternal)this.entity).getManagementSupport().getSubscriptionContext());
        return this._subscriptionTracker;
    }

    protected <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        if (!this.checkCanSubscribe()) {
            return null;
        }
        return this.getSubscriptionTracker().subscribe(producer, sensor, listener);
    }

    protected <T> SubscriptionHandle subscribeToMembers(Group producerGroup, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        if (!this.checkCanSubscribe((Entity)producerGroup)) {
            return null;
        }
        return this.getSubscriptionTracker().subscribeToMembers(producerGroup, sensor, listener);
    }

    protected <T> SubscriptionHandle subscribeToChildren(Entity producerParent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        if (!this.checkCanSubscribe(producerParent)) {
            return null;
        }
        return this.getSubscriptionTracker().subscribeToChildren(producerParent, sensor, listener);
    }

    @Deprecated
    protected boolean check(Entity requiredEntity) {
        return this.checkCanSubscribe(requiredEntity);
    }

    protected boolean checkCanSubscribe(Entity producer) {
        if (this.destroyed.get()) {
            return false;
        }
        if (producer == null) {
            throw new IllegalStateException(this + " given a null target for subscription");
        }
        if (this.entity == null) {
            throw new IllegalStateException(this + " cannot subscribe to " + producer + " because it is not associated to an entity");
        }
        if (((EntityInternal)this.entity).getManagementSupport().isNoLongerManaged()) {
            throw new IllegalStateException(this + " cannot subscribe to " + producer + " because the associated entity " + this.entity + " is no longer managed");
        }
        return true;
    }

    protected boolean checkCanSubscribe() {
        if (this.destroyed.get()) {
            return false;
        }
        if (this.entity == null) {
            throw new IllegalStateException(this + " cannot subscribe because it is not associated to an entity");
        }
        if (((EntityInternal)this.entity).getManagementSupport().isNoLongerManaged()) {
            throw new IllegalStateException(this + " cannot subscribe because the associated entity " + this.entity + " is no longer managed");
        }
        return true;
    }

    protected boolean unsubscribe(Entity producer) {
        if (this.destroyed.get()) {
            return false;
        }
        return this.getSubscriptionTracker().unsubscribe(producer);
    }

    protected boolean unsubscribe(Entity producer, SubscriptionHandle handle) {
        if (this.destroyed.get()) {
            return false;
        }
        return this.getSubscriptionTracker().unsubscribe(producer, handle);
    }

    protected Collection<SubscriptionHandle> getAllSubscriptions() {
        SubscriptionTracker tracker = this.getSubscriptionTracker();
        return tracker != null ? tracker.getAllSubscriptions() : Collections.emptyList();
    }

    public void destroy() {
        this.destroyed.set(true);
        SubscriptionTracker tracker = this.getSubscriptionTracker();
        if (tracker != null) {
            tracker.unsubscribeAll();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean isRunning() {
        return !this.isDestroyed();
    }

    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Override
    public BrooklynObject.TagSupport tags() {
        return new AdjunctTagSupport();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).omitNullValues().add("name", (Object)this.name).add("uniqueTag", (Object)this.uniqueTag).add("running", this.isRunning()).add("entity", (Object)this.entity).add("id", (Object)this.getId()).toString();
    }

    public class AdjunctTagSupport
    extends AbstractBrooklynObject.BasicTagSupport {
        @Override
        public Set<Object> getTags() {
            ImmutableSet.Builder rb = ImmutableSet.builder().addAll(super.getTags());
            if (this.getUniqueTag() != null) {
                rb.add((Object)this.getUniqueTag());
            }
            return rb.build();
        }

        public String getUniqueTag() {
            return AbstractEntityAdjunct.this.getUniqueTag();
        }

        public void setUniqueTag(String uniqueTag) {
            AbstractEntityAdjunct.this.uniqueTag = uniqueTag;
        }
    }

    private class BasicConfigurationSupport
    implements BrooklynObjectInternal.ConfigurationSupportInternal {
        private BasicConfigurationSupport() {
        }

        public <T> T get(ConfigKey<T> key) {
            return AbstractEntityAdjunct.this.configsInternal.getConfig(key);
        }

        public <T> T get(ConfigKey.HasConfigKey<T> key) {
            return this.get(key.getConfigKey());
        }

        public <T> T set(ConfigKey<T> key, T val) {
            if (AbstractEntityAdjunct.this.entity != null && AbstractEntityAdjunct.this.isRunning()) {
                AbstractEntityAdjunct.this.doReconfigureConfig(key, val);
            }
            Object result = AbstractEntityAdjunct.this.configsInternal.setConfig(key, val);
            AbstractEntityAdjunct.this.onChanged();
            return (T)result;
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, T val) {
            return AbstractEntityAdjunct.this.setConfig(key.getConfigKey(), val);
        }

        public <T> T set(ConfigKey<T> key, Task<T> val) {
            if (AbstractEntityAdjunct.this.entity != null && AbstractEntityAdjunct.this.isRunning()) {
                throw new UnsupportedOperationException();
            }
            Object result = AbstractEntityAdjunct.this.configsInternal.setConfig(key, val);
            AbstractEntityAdjunct.this.onChanged();
            return (T)result;
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, Task<T> val) {
            return this.set(key.getConfigKey(), val);
        }

        @Override
        public ConfigBag getBag() {
            return this.getLocalBag();
        }

        @Override
        public ConfigBag getLocalBag() {
            return ConfigBag.newInstance(AbstractEntityAdjunct.this.configsInternal.getAllConfig());
        }

        @Override
        public Maybe<Object> getRaw(ConfigKey<?> key) {
            return AbstractEntityAdjunct.this.configsInternal.getConfigRaw(key, true);
        }

        @Override
        public Maybe<Object> getRaw(ConfigKey.HasConfigKey<?> key) {
            return this.getRaw(key.getConfigKey());
        }

        @Override
        public Maybe<Object> getLocalRaw(ConfigKey<?> key) {
            return AbstractEntityAdjunct.this.configsInternal.getConfigRaw(key, false);
        }

        @Override
        public Maybe<Object> getLocalRaw(ConfigKey.HasConfigKey<?> key) {
            return this.getLocalRaw(key.getConfigKey());
        }

        @Override
        public void addToLocalBag(Map<String, ?> vals) {
            AbstractEntityAdjunct.this.configsInternal.addToLocalBag(vals);
        }

        @Override
        public void refreshInheritedConfig() {
        }

        @Override
        public void refreshInheritedConfigOfChildren() {
        }
    }
}

