/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.usage;

import brooklyn.entity.basic.Lifecycle;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ApplicationUsage {
    private final String applicationId;
    private final String applicationName;
    private final String entityType;
    private final Map<String, String> metadata;
    private final List<ApplicationEvent> events = Collections.synchronizedList(Lists.newArrayList());

    public ApplicationUsage(String applicationId, String applicationName, String entityType, Map<String, String> metadata) {
        this.applicationId = (String)Preconditions.checkNotNull((Object)applicationId, (Object)"applicationId");
        this.applicationName = applicationName;
        this.entityType = (String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType");
        this.metadata = (Map)Preconditions.checkNotNull(metadata, (Object)"metadata");
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationEvent> getEvents() {
        List<ApplicationEvent> list = this.events;
        synchronized (list) {
            return ImmutableList.copyOf(this.events);
        }
    }

    public void addEvent(ApplicationEvent event) {
        this.events.add((ApplicationEvent)Preconditions.checkNotNull((Object)event, (Object)"event"));
    }

    public static class ApplicationEvent {
        private final Date date;
        private final Lifecycle state;
        private final String user;

        public ApplicationEvent(Lifecycle state, String user) {
            this(new Date(), state, user);
        }

        public ApplicationEvent(Date date, Lifecycle state) {
            this(date, state, null);
        }

        public ApplicationEvent(Date date, Lifecycle state, String user) {
            this.date = (Date)Preconditions.checkNotNull((Object)date, (Object)"date");
            this.state = (Lifecycle)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            this.user = user;
        }

        public Date getDate() {
            return this.date;
        }

        public Lifecycle getState() {
            return this.state;
        }

        public String getUser() {
            return this.user;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ApplicationEvent)) {
                return false;
            }
            ApplicationEvent o = (ApplicationEvent)other;
            return Objects.equal((Object)this.date, (Object)o.date) && Objects.equal((Object)((Object)this.state), (Object)((Object)o.state)) && Objects.equal((Object)this.user, (Object)o.user);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.date, this.state, this.user});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("date", (Object)this.date).add("state", (Object)this.state).add("entitlementContext", (Object)this.user).toString();
        }
    }
}

