/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Application;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.location.Location;
import brooklyn.management.internal.UsageListener;
import brooklyn.management.usage.ApplicationUsage;
import brooklyn.management.usage.LocationUsage;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Beta
public interface UsageManager {
    public static final ConfigKey<List<brooklyn.management.internal.UsageListener>> USAGE_LISTENERS = ConfigKeys.newConfigKey(new TypeToken<List<brooklyn.management.internal.UsageListener>>(){}, "brooklyn.usageManager.listeners", "Optional usage listeners (i.e. for metering)", ImmutableList.of());
    public static final ConfigKey<Duration> USAGE_LISTENER_TERMINATION_TIMEOUT = ConfigKeys.newConfigKey(Duration.class, "brooklyn.usageManager.listeners.timeout", "Timeout on termination, to wait for queue of usage listener events to be processed", Duration.TEN_SECONDS);

    public void recordApplicationEvent(Application var1, Lifecycle var2);

    public void recordLocationEvent(Location var1, Lifecycle var2);

    public LocationUsage getLocationUsage(String var1);

    public Set<LocationUsage> getLocationUsage(Predicate<? super LocationUsage> var1);

    public ApplicationUsage getApplicationUsage(String var1);

    public Set<ApplicationUsage> getApplicationUsage(Predicate<? super ApplicationUsage> var1);

    public void addUsageListener(UsageListener var1);

    @Deprecated
    public void removeUsageListener(UsageListener var1);

    public void addUsageListener(brooklyn.management.internal.UsageListener var1);

    public void removeUsageListener(brooklyn.management.internal.UsageListener var1);

    public static interface UsageListener {
        public static final UsageListener NOOP = new UsageListener(){

            @Override
            public void onApplicationEvent(String applicationId, String applicationName, String entityType, String catalogItemId, Map<String, String> metadata, ApplicationUsage.ApplicationEvent event) {
            }

            @Override
            public void onLocationEvent(String locationId, Map<String, String> metadata, LocationUsage.LocationEvent event) {
            }
        };

        public void onApplicationEvent(String var1, String var2, String var3, String var4, Map<String, String> var5, ApplicationUsage.ApplicationEvent var6);

        public void onLocationEvent(String var1, Map<String, String> var2, LocationUsage.LocationEvent var3);

        public static class UsageListenerAdapter
        implements brooklyn.management.internal.UsageListener {
            private final UsageListener listener;

            public UsageListenerAdapter(UsageListener listener) {
                this.listener = (UsageListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            }

            @Override
            public void onApplicationEvent(UsageListener.ApplicationMetadata app, ApplicationUsage.ApplicationEvent event) {
                this.listener.onApplicationEvent(app.getApplicationId(), app.getApplicationName(), app.getEntityType(), app.getCatalogItemId(), app.getMetadata(), event);
            }

            @Override
            public void onLocationEvent(UsageListener.LocationMetadata loc, LocationUsage.LocationEvent event) {
                this.listener.onLocationEvent(loc.getLocationId(), loc.getMetadata(), event);
            }

            public boolean equals(Object obj) {
                return obj instanceof UsageListenerAdapter && this.listener.equals(((UsageListenerAdapter)obj).listener);
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.listener});
            }
        }
    }
}

