/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEventListener;
import brooklyn.management.SubscriptionContext;
import brooklyn.management.SubscriptionHandle;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Set;

public class SubscriptionTracker {
    protected SubscriptionContext context;
    private final SetMultimap<Entity, SubscriptionHandle> subscriptions = HashMultimap.create();

    public SubscriptionTracker(SubscriptionContext subscriptionContext) {
        this.context = subscriptionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        SubscriptionHandle handle = this.context.subscribe(producer, sensor, listener);
        SetMultimap<Entity, SubscriptionHandle> setMultimap = this.subscriptions;
        synchronized (setMultimap) {
            this.subscriptions.put((Object)producer, (Object)handle);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        SubscriptionHandle handle = this.context.subscribeToChildren(parent, sensor, listener);
        SetMultimap<Entity, SubscriptionHandle> setMultimap = this.subscriptions;
        synchronized (setMultimap) {
            this.subscriptions.put((Object)parent, (Object)handle);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SubscriptionHandle subscribeToMembers(Group parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        SubscriptionHandle handle = this.context.subscribeToMembers(parent, sensor, listener);
        SetMultimap<Entity, SubscriptionHandle> setMultimap = this.subscriptions;
        synchronized (setMultimap) {
            this.subscriptions.put((Object)parent, (Object)handle);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(Entity producer) {
        Set handles;
        SetMultimap<Entity, SubscriptionHandle> setMultimap = this.subscriptions;
        synchronized (setMultimap) {
            handles = this.subscriptions.removeAll((Object)producer);
        }
        if (handles != null) {
            for (SubscriptionHandle handle : handles) {
                this.context.unsubscribe(handle);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(Entity producer, SubscriptionHandle handle) {
        SetMultimap<Entity, SubscriptionHandle> setMultimap = this.subscriptions;
        synchronized (setMultimap) {
            this.subscriptions.remove((Object)producer, (Object)handle);
        }
        return this.context.unsubscribe(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SubscriptionHandle> getAllSubscriptions() {
        SetMultimap<Entity, SubscriptionHandle> setMultimap = this.subscriptions;
        synchronized (setMultimap) {
            return ImmutableList.copyOf((Collection)this.subscriptions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll() {
        ImmutableList subscriptionsSnapshot;
        SetMultimap<Entity, SubscriptionHandle> setMultimap = this.subscriptions;
        synchronized (setMultimap) {
            subscriptionsSnapshot = ImmutableList.copyOf((Collection)this.subscriptions.values());
            this.subscriptions.clear();
        }
        for (SubscriptionHandle s : subscriptionsSnapshot) {
            this.context.unsubscribe(s);
        }
    }
}

