/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Entity;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.management.SubscriptionHandle;
import brooklyn.management.internal.LocalSubscriptionManager;
import brooklyn.util.text.Identifiers;
import com.google.common.base.Predicate;
import java.util.Map;

class Subscription<T>
implements SubscriptionHandle {
    public final String id = Identifiers.makeRandomId((int)8);
    public Object subscriber;
    public Object subscriberExecutionManagerTag;
    public boolean subscriberExecutionManagerTagSupplied;
    public final Entity producer;
    public final Sensor<T> sensor;
    public final SensorEventListener<? super T> listener;
    public Map<String, Object> flags;
    public Predicate<SensorEvent<T>> eventFilter;

    public Subscription(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        this.producer = producer;
        this.sensor = sensor;
        this.listener = listener;
    }

    public boolean equals(Object other) {
        return other instanceof Subscription && ((Subscription)other).id == this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Subscription[" + this.id + ";" + this.subscriber + "@" + LocalSubscriptionManager.makeEntitySensorToken(this.producer, this.sensor) + "]";
    }
}

