/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Entity;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.management.SubscriptionHandle;
import brooklyn.management.internal.AbstractSubscriptionManager;
import brooklyn.management.internal.Subscription;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueueingSubscriptionManager
extends AbstractSubscriptionManager {
    public AbstractSubscriptionManager delegate = null;
    public boolean useDelegateForSubscribing = false;
    public boolean useDelegateForPublishing = false;
    List<QueuedSubscription> queuedSubscriptions = new ArrayList<QueuedSubscription>();
    List<SensorEvent> queuedSensorEvents = new ArrayList<SensorEvent>();

    @Override
    protected synchronized <T> SubscriptionHandle subscribe(Map<String, Object> flags, Subscription<T> s) {
        if (this.useDelegateForSubscribing) {
            return this.delegate.subscribe(flags, s);
        }
        QueuedSubscription qs = new QueuedSubscription();
        qs.flags = flags;
        s.subscriber = this.getSubscriber(flags, s);
        qs.s = s;
        this.queuedSubscriptions.add(qs);
        return s;
    }

    @Override
    public synchronized <T> void publish(SensorEvent<T> event) {
        if (this.useDelegateForPublishing) {
            this.delegate.publish(event);
            return;
        }
        this.queuedSensorEvents.add(event);
    }

    public void setDelegate(AbstractSubscriptionManager delegate) {
        this.delegate = delegate;
    }

    public synchronized void startDelegatingForSubscribing() {
        assert (this.delegate != null);
        for (QueuedSubscription s : this.queuedSubscriptions) {
            this.delegate.subscribe(s.flags, s.s);
        }
        this.queuedSubscriptions.clear();
        this.useDelegateForSubscribing = true;
    }

    public synchronized void startDelegatingForPublishing() {
        assert (this.delegate != null);
        for (SensorEvent evt : this.queuedSensorEvents) {
            this.delegate.publish(evt);
        }
        this.queuedSensorEvents.clear();
        this.useDelegateForPublishing = true;
    }

    public synchronized void stopDelegatingForSubscribing() {
        this.useDelegateForSubscribing = false;
    }

    public synchronized void stopDelegatingForPublishing() {
        this.useDelegateForPublishing = false;
    }

    public synchronized boolean unsubscribe(SubscriptionHandle subscriptionId) {
        if (this.useDelegateForSubscribing) {
            return this.delegate.unsubscribe(subscriptionId);
        }
        Iterator<QueuedSubscription> qi = this.queuedSubscriptions.iterator();
        while (qi.hasNext()) {
            QueuedSubscription q = qi.next();
            if (!Objects.equal((Object)subscriptionId, q.s)) continue;
            qi.remove();
            return true;
        }
        return false;
    }

    public synchronized Set<SubscriptionHandle> getSubscriptionsForSubscriber(Object subscriber) {
        if (this.useDelegateForSubscribing) {
            return this.delegate.getSubscriptionsForSubscriber(subscriber);
        }
        LinkedHashSet<SubscriptionHandle> result = new LinkedHashSet<SubscriptionHandle>();
        for (QueuedSubscription q : this.queuedSubscriptions) {
            if (!Objects.equal((Object)subscriber, (Object)this.getSubscriber(q.flags, q.s))) continue;
            result.add(q.s);
        }
        return result;
    }

    public synchronized Set<SubscriptionHandle> getSubscriptionsForEntitySensor(Entity source, Sensor<?> sensor) {
        if (this.useDelegateForSubscribing) {
            return this.delegate.getSubscriptionsForEntitySensor(source, sensor);
        }
        LinkedHashSet<SubscriptionHandle> result = new LinkedHashSet<SubscriptionHandle>();
        for (QueuedSubscription q : this.queuedSubscriptions) {
            if (q.s.sensor != null && !Objects.equal(q.s.sensor, sensor) || q.s.producer != null && !Objects.equal((Object)q.s.producer, sensor)) continue;
            result.add(q.s);
        }
        return result;
    }

    static class QueuedSubscription<T> {
        Map<String, Object> flags;
        Subscription<T> s;

        QueuedSubscription() {
        }
    }
}

