/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Application;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.location.Location;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.management.internal.NonDeploymentManagementContext;
import brooklyn.management.internal.UsageListener;
import brooklyn.management.internal.UsageManager;
import brooklyn.management.usage.ApplicationUsage;
import brooklyn.management.usage.LocationUsage;
import com.google.common.base.Predicate;
import java.util.Set;

public class NonDeploymentUsageManager
implements UsageManager {
    private final ManagementContextInternal initialManagementContext;

    public NonDeploymentUsageManager(ManagementContextInternal initialManagementContext) {
        this.initialManagementContext = initialManagementContext;
    }

    private boolean isInitialManagementContextReal() {
        return this.initialManagementContext != null && !(this.initialManagementContext instanceof NonDeploymentManagementContext);
    }

    @Override
    public void recordApplicationEvent(Application app, Lifecycle state) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().recordApplicationEvent(app, state);
    }

    @Override
    public void recordLocationEvent(Location loc, Lifecycle state) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().recordLocationEvent(loc, state);
    }

    @Override
    public LocationUsage getLocationUsage(String locationId) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getLocationUsage(locationId);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public Set<LocationUsage> getLocationUsage(Predicate<? super LocationUsage> filter) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getLocationUsage(filter);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public ApplicationUsage getApplicationUsage(String appId) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getApplicationUsage(appId);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public Set<ApplicationUsage> getApplicationUsage(Predicate<? super ApplicationUsage> filter) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getApplicationUsage(filter);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    @Deprecated
    public void addUsageListener(UsageManager.UsageListener listener) {
        this.addUsageListener(new UsageManager.UsageListener.UsageListenerAdapter(listener));
    }

    @Override
    @Deprecated
    public void removeUsageListener(UsageManager.UsageListener listener) {
        this.removeUsageListener(new UsageManager.UsageListener.UsageListenerAdapter(listener));
    }

    @Override
    public void addUsageListener(UsageListener listener) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().addUsageListener(listener);
    }

    @Override
    public void removeUsageListener(UsageListener listener) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().removeUsageListener(listener);
    }
}

