/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.internal.CatalogInitialization;
import brooklyn.config.BrooklynProperties;
import brooklyn.config.StringConfigMap;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.drivers.EntityDriverManager;
import brooklyn.entity.drivers.downloads.DownloadResolverManager;
import brooklyn.entity.proxying.InternalEntityFactory;
import brooklyn.entity.proxying.InternalLocationFactory;
import brooklyn.entity.proxying.InternalPolicyFactory;
import brooklyn.entity.rebind.ChangeListener;
import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.RebindManager;
import brooklyn.internal.storage.BrooklynStorage;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.management.AccessController;
import brooklyn.management.EntityManager;
import brooklyn.management.ExecutionContext;
import brooklyn.management.ExecutionManager;
import brooklyn.management.LocationManager;
import brooklyn.management.ManagementContext;
import brooklyn.management.SubscriptionContext;
import brooklyn.management.Task;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.ha.HighAvailabilityManager;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.ha.ManagementPlaneSyncRecord;
import brooklyn.management.ha.ManagementPlaneSyncRecordPersister;
import brooklyn.management.ha.OsgiManager;
import brooklyn.management.internal.AccessManager;
import brooklyn.management.internal.BasicSubscriptionContext;
import brooklyn.management.internal.CollectionChangeListener;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.management.internal.NonDeploymentAccessManager;
import brooklyn.management.internal.NonDeploymentEntityManager;
import brooklyn.management.internal.NonDeploymentLocationManager;
import brooklyn.management.internal.NonDeploymentUsageManager;
import brooklyn.management.internal.QueueingSubscriptionManager;
import brooklyn.management.internal.UsageManager;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.util.guava.Maybe;
import brooklyn.util.time.Duration;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonDeploymentManagementContext
implements ManagementContextInternal {
    private static final Logger log = LoggerFactory.getLogger(NonDeploymentManagementContext.class);
    private final AbstractEntity entity;
    private NonDeploymentManagementContextMode mode;
    private ManagementContextInternal initialManagementContext;
    private final QueueingSubscriptionManager qsm;
    private final BasicSubscriptionContext subscriptionContext;
    private NonDeploymentEntityManager entityManager;
    private NonDeploymentLocationManager locationManager;
    private NonDeploymentAccessManager accessManager;
    private NonDeploymentUsageManager usageManager;
    private EntitlementManager entitlementManager;

    public NonDeploymentManagementContext(AbstractEntity entity, NonDeploymentManagementContextMode mode) {
        this.entity = (AbstractEntity)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.mode = (NonDeploymentManagementContextMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
        this.qsm = new QueueingSubscriptionManager();
        this.subscriptionContext = new BasicSubscriptionContext(this.qsm, entity);
        this.entityManager = new NonDeploymentEntityManager(null);
        this.locationManager = new NonDeploymentLocationManager(null);
        this.accessManager = new NonDeploymentAccessManager(null);
        this.usageManager = new NonDeploymentUsageManager(null);
        this.entitlementManager = Entitlements.minimal();
    }

    public String getManagementPlaneId() {
        return this.initialManagementContext == null ? null : this.initialManagementContext.getManagementPlaneId();
    }

    public String getManagementNodeId() {
        return this.initialManagementContext == null ? null : this.initialManagementContext.getManagementNodeId();
    }

    public Maybe<URI> getManagementNodeUri() {
        return this.initialManagementContext == null ? Maybe.absent() : this.initialManagementContext.getManagementNodeUri();
    }

    public void setManagementContext(ManagementContextInternal val) {
        this.initialManagementContext = (ManagementContextInternal)Preconditions.checkNotNull((Object)val, (Object)"initialManagementContext");
        this.entityManager = new NonDeploymentEntityManager(val);
        this.locationManager = new NonDeploymentLocationManager(val);
        this.accessManager = new NonDeploymentAccessManager(val);
        this.usageManager = new NonDeploymentUsageManager(val);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("entity", (Object)this.entity.getId()).add("mode", (Object)this.mode).toString();
    }

    public void setMode(NonDeploymentManagementContextMode mode) {
        this.mode = (NonDeploymentManagementContextMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
    }

    public NonDeploymentManagementContextMode getMode() {
        return this.mode;
    }

    public Collection<Application> getApplications() {
        return Collections.emptyList();
    }

    public boolean isRunning() {
        return true;
    }

    public boolean isStartupComplete() {
        return false;
    }

    @Override
    public InternalEntityFactory getEntityFactory() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getEntityFactory();
    }

    @Override
    public InternalLocationFactory getLocationFactory() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getLocationFactory();
    }

    @Override
    public InternalPolicyFactory getPolicyFactory() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getPolicyFactory();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public LocationManager getLocationManager() {
        return this.locationManager;
    }

    @Override
    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    @Override
    public UsageManager getUsageManager() {
        return this.usageManager;
    }

    @Override
    public Maybe<OsgiManager> getOsgiManager() {
        return Maybe.absent();
    }

    public AccessController getAccessController() {
        return this.getAccessManager().getAccessController();
    }

    public ExecutionManager getExecutionManager() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getExecutionManager();
    }

    public QueueingSubscriptionManager getSubscriptionManager() {
        return this.qsm;
    }

    public synchronized SubscriptionContext getSubscriptionContext(Entity entity) {
        if (!this.entity.equals(entity)) {
            throw new IllegalStateException("Non-deployment context " + this + " can only use a single Entity: has " + this.entity + ", but passed " + entity);
        }
        if (this.mode == NonDeploymentManagementContextMode.MANAGEMENT_STOPPED) {
            throw new IllegalStateException("Entity " + entity + " is no longer managed; subscription context not available");
        }
        return this.subscriptionContext;
    }

    public ExecutionContext getExecutionContext(Entity entity) {
        if (!this.entity.equals(entity)) {
            throw new IllegalStateException("Non-deployment context " + this + " can only use a single Entity: has " + this.entity + ", but passed " + entity);
        }
        if (this.mode == NonDeploymentManagementContextMode.MANAGEMENT_STOPPED) {
            throw new IllegalStateException("Entity " + entity + " is no longer managed; execution context not available");
        }
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getExecutionContext(entity);
    }

    public ExecutionContext getServerExecutionContext() {
        return this.initialManagementContext.getServerExecutionContext();
    }

    public EntityDriverManager getEntityDriverManager() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getEntityDriverManager();
    }

    public DownloadResolverManager getEntityDownloadsManager() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getEntityDownloadsManager();
    }

    public StringConfigMap getConfig() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getConfig();
    }

    @Override
    public BrooklynProperties getBrooklynProperties() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getBrooklynProperties();
    }

    @Override
    public BrooklynStorage getStorage() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getStorage();
    }

    public RebindManager getRebindManager() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getRebindManager();
        }
        return new NonDeploymentRebindManager();
    }

    public HighAvailabilityManager getHighAvailabilityManager() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getHighAvailabilityManager();
        }
        return new NonDeploymentHighAvailabilityManager();
    }

    public LocationRegistry getLocationRegistry() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getLocationRegistry();
    }

    public BrooklynCatalog getCatalog() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getCatalog();
    }

    public ClassLoader getCatalogClassLoader() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getCatalogClassLoader();
    }

    public EntitlementManager getEntitlementManager() {
        return this.entitlementManager;
    }

    @Override
    public <T> T invokeEffectorMethodSync(Entity entity, Effector<T> eff, Object args) throws ExecutionException {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot invoke effector " + eff + " on entity " + entity);
    }

    @Override
    public <T> Task<T> invokeEffector(Entity entity, Effector<T> eff, Map parameters) {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot invoke effector " + eff + " on entity " + entity);
    }

    @Override
    public ClassLoader getBaseClassLoader() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getBaseClassLoader();
    }

    @Override
    public Iterable<URL> getBaseClassPathForScanning() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getBaseClassPathForScanning();
    }

    @Override
    public void addEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.addEntitySetListener(listener);
    }

    @Override
    public void removeEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.removeEntitySetListener(listener);
    }

    @Override
    public void terminate() {
        if (this.isInitialManagementContextReal()) {
            this.initialManagementContext.terminate();
        }
    }

    @Override
    public long getTotalEffectorInvocations() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getTotalEffectorInvocations();
        }
        return 0L;
    }

    @Override
    public void setBaseClassPathForScanning(Iterable<URL> urls) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.setBaseClassPathForScanning(urls);
    }

    @Override
    public void setManagementNodeUri(URI uri) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.setManagementNodeUri(uri);
    }

    @Override
    public void prePreManage(Entity entity) {
        log.warn("Ignoring call to prePreManage(" + entity + ") on " + this);
    }

    @Override
    public void prePreManage(Location location) {
        log.warn("Ignoring call to prePreManage(" + location + ") on " + this);
    }

    private boolean isInitialManagementContextReal() {
        return this.initialManagementContext != null && !(this.initialManagementContext instanceof NonDeploymentManagementContext);
    }

    private void checkInitialManagementContextReal() {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation.");
        }
    }

    public void reloadBrooklynProperties() {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.reloadBrooklynProperties();
    }

    public void addPropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.addPropertiesReloadListener(listener);
    }

    public void removePropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.removePropertiesReloadListener(listener);
    }

    public BrooklynObject lookup(String id) {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.lookup(id);
    }

    public <T extends BrooklynObject> T lookup(String id, Class<T> type) {
        this.checkInitialManagementContextReal();
        return (T)this.initialManagementContext.lookup(id, type);
    }

    @Override
    public List<Throwable> errors() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.errors();
    }

    @Override
    public CatalogInitialization getCatalogInitialization() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getCatalogInitialization();
    }

    @Override
    public void setCatalogInitialization(CatalogInitialization catalogInitialization) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.setCatalogInitialization(catalogInitialization);
    }

    private class NonDeploymentHighAvailabilityManager
    implements HighAvailabilityManager {
        private NonDeploymentHighAvailabilityManager() {
        }

        public ManagementNodeState getNodeState() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public boolean isRunning() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public HighAvailabilityManager setPersister(ManagementPlaneSyncRecordPersister persister) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void disabled() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void start(HighAvailabilityMode startMode) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stop() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public ManagementPlaneSyncRecordPersister getPersister() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public ManagementPlaneSyncRecord getManagementPlaneSyncState() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public ManagementPlaneSyncRecord getLastManagementPlaneSyncRecord() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public ManagementPlaneSyncRecord loadManagementPlaneSyncRecord(boolean x) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void changeMode(HighAvailabilityMode startMode) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void setPriority(long priority) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public long getPriority() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public Map<String, Object> getMetrics() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void publishClearNonMaster() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public long getLastStateChange() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }
    }

    private class NonDeploymentRebindManager
    implements RebindManager {
        private NonDeploymentRebindManager() {
        }

        public ChangeListener getChangeListener() {
            return ChangeListener.NOOP;
        }

        public void setPersister(BrooklynMementoPersister persister) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void setPersister(BrooklynMementoPersister persister, PersistenceExceptionHandler exceptionHandler) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public BrooklynMementoPersister getPersister() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public List<Application> rebind() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public List<Application> rebind(ClassLoader classLoader) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public List<Application> rebind(ClassLoader classLoader, RebindExceptionHandler exceptionHandler) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public List<Application> rebind(ClassLoader classLoader, RebindExceptionHandler exceptionHandler, ManagementNodeState mode) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void startPersistence() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stopPersistence() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void startReadOnly(ManagementNodeState state) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stopReadOnly() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void start() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stop() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void waitForPendingComplete(Duration timeout, boolean canTrigger) throws InterruptedException, TimeoutException {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void forcePersistNow() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void forcePersistNow(boolean full, PersistenceExceptionHandler exceptionHandler) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public BrooklynMementoRawData retrieveMementoRawData() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public boolean isAwaitingInitialRebind() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public Map<String, Object> getMetrics() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }
    }

    public static enum NonDeploymentManagementContextMode {
        PRE_MANAGEMENT,
        MANAGEMENT_REBINDING,
        MANAGEMENT_STARTING,
        MANAGEMENT_STARTED,
        MANAGEMENT_STOPPING,
        MANAGEMENT_STOPPED;


        public boolean isPreManaged() {
            return this == PRE_MANAGEMENT || this == MANAGEMENT_REBINDING;
        }
    }
}

