/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.basic.BrooklynObject;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.EntityTypeRegistry;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.EntityManagerInternal;
import brooklyn.management.internal.ManagementTransitionMode;
import brooklyn.management.internal.NonDeploymentManagementContext;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class NonDeploymentEntityManager
implements EntityManagerInternal {
    private final ManagementContext initialManagementContext;

    public NonDeploymentEntityManager(ManagementContext initialManagementContext) {
        this.initialManagementContext = initialManagementContext;
    }

    public EntityTypeRegistry getEntityTypeRegistry() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getEntityManager().getEntityTypeRegistry();
        }
        throw new IllegalStateException("Non-deployment context " + this + " (with no initial management context supplied) is not valid for this operation.");
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec) {
        if (this.isInitialManagementContextReal()) {
            return (T)this.initialManagementContext.getEntityManager().createEntity(spec);
        }
        throw new IllegalStateException("Non-deployment context " + this + " (with no initial management context supplied) is not valid for this operation.");
    }

    public <T extends Entity> T createEntity(Map<?, ?> config, Class<T> type) {
        return this.createEntity(EntitySpec.create(type).configure(config));
    }

    public <T extends Policy> T createPolicy(PolicySpec<T> spec) {
        if (this.isInitialManagementContextReal()) {
            return (T)this.initialManagementContext.getEntityManager().createPolicy(spec);
        }
        throw new IllegalStateException("Non-deployment context " + this + " (with no initial management context supplied) is not valid for this operation.");
    }

    public <T extends Enricher> T createEnricher(EnricherSpec<T> spec) {
        if (this.isInitialManagementContextReal()) {
            return (T)this.initialManagementContext.getEntityManager().createEnricher(spec);
        }
        throw new IllegalStateException("Non-deployment context " + this + " (with no initial management context supplied) is not valid for this operation.");
    }

    public Collection<Entity> getEntities() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getEntityManager().getEntities();
        }
        return Collections.emptyList();
    }

    public Collection<Entity> getEntitiesInApplication(Application application) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getEntityManager().getEntitiesInApplication(application);
        }
        return Collections.emptyList();
    }

    public Collection<Entity> findEntities(Predicate<? super Entity> filter) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getEntityManager().findEntities(filter);
        }
        return Collections.emptyList();
    }

    public Collection<Entity> findEntitiesInApplication(Application application, Predicate<? super Entity> filter) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getEntityManager().findEntitiesInApplication(application, filter);
        }
        return Collections.emptyList();
    }

    public Entity getEntity(String id) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getEntityManager().getEntity(id);
        }
        return null;
    }

    @Override
    public Iterable<String> getEntityIds() {
        if (this.isInitialManagementContextReal()) {
            return ((EntityManagerInternal)this.initialManagementContext.getEntityManager()).getEntityIds();
        }
        return Collections.emptyList();
    }

    @Override
    public ManagementTransitionMode getLastManagementTransitionMode(String itemId) {
        if (this.isInitialManagementContextReal()) {
            return ((EntityManagerInternal)this.initialManagementContext.getEntityManager()).getLastManagementTransitionMode(itemId);
        }
        return null;
    }

    @Override
    public void setManagementTransitionMode(Entity item, ManagementTransitionMode mode) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        ((EntityManagerInternal)this.initialManagementContext.getEntityManager()).setManagementTransitionMode((BrooklynObject)item, mode);
    }

    public boolean isManaged(Entity entity) {
        return false;
    }

    public void manage(Entity e) {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot manage " + e);
    }

    @Override
    public void unmanage(Entity e, ManagementTransitionMode info) {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public void manageRebindedRoot(Entity item) {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    public void unmanage(Entity e) {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot unmanage " + e);
    }

    private boolean isInitialManagementContextReal() {
        return this.initialManagementContext != null && !(this.initialManagementContext instanceof NonDeploymentManagementContext);
    }

    @Override
    public Iterable<Entity> getAllEntitiesInApplication(Application application) {
        if (this.isInitialManagementContextReal()) {
            return ((EntityManagerInternal)this.initialManagementContext.getEntityManager()).getAllEntitiesInApplication(application);
        }
        throw new IllegalStateException("Non-deployment context " + this + " (with no initial management context supplied) is not valid for this operation.");
    }
}

