/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.management.AccessController;
import brooklyn.management.internal.AccessManager;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.management.internal.NonDeploymentManagementContext;

public class NonDeploymentAccessManager
implements AccessManager {
    private final ManagementContextInternal initialManagementContext;

    public NonDeploymentAccessManager(ManagementContextInternal initialManagementContext) {
        this.initialManagementContext = initialManagementContext;
    }

    private boolean isInitialManagementContextReal() {
        return this.initialManagementContext != null && !(this.initialManagementContext instanceof NonDeploymentManagementContext);
    }

    @Override
    public AccessController getAccessController() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getAccessManager().getAccessController();
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public boolean isLocationProvisioningAllowed() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getAccessManager().isLocationProvisioningAllowed();
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public boolean isLocationManagementAllowed() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getAccessManager().isLocationManagementAllowed();
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public boolean isEntityManagementAllowed() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getAccessManager().isEntityManagementAllowed();
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public void setLocationProvisioningAllowed(boolean allowed) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getAccessManager().setLocationProvisioningAllowed(allowed);
    }

    @Override
    public void setLocationManagementAllowed(boolean allowed) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getAccessManager().setLocationManagementAllowed(allowed);
    }

    @Override
    public void setEntityManagementAllowed(boolean allowed) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getAccessManager().setEntityManagementAllowed(allowed);
    }
}

