/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.management.internal.BrooklynObjectManagementMode;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementTransitionMode {
    private static final Logger log = LoggerFactory.getLogger(ManagementTransitionMode.class);
    private final BrooklynObjectManagementMode modeBefore;
    private final BrooklynObjectManagementMode modeAfter;

    private ManagementTransitionMode(BrooklynObjectManagementMode modeBefore, BrooklynObjectManagementMode modeAfter) {
        this.modeBefore = modeBefore;
        this.modeAfter = modeAfter;
    }

    public static ManagementTransitionMode transitioning(BrooklynObjectManagementMode modeBefore, BrooklynObjectManagementMode modeAfter) {
        return new ManagementTransitionMode((BrooklynObjectManagementMode)((Object)Preconditions.checkNotNull((Object)((Object)modeBefore), (Object)"modeBefore")), (BrooklynObjectManagementMode)((Object)Preconditions.checkNotNull((Object)((Object)modeAfter), (Object)"modeAfter")));
    }

    @Deprecated
    public static ManagementTransitionMode guessing(BrooklynObjectManagementMode modeBefore, BrooklynObjectManagementMode modeAfter) {
        return ManagementTransitionMode.transitioning(modeBefore, modeAfter);
    }

    public BrooklynObjectManagementMode getModeBefore() {
        return this.modeBefore;
    }

    public BrooklynObjectManagementMode getModeAfter() {
        return this.modeAfter;
    }

    public boolean wasNotLoaded() {
        return this.getModeBefore() == BrooklynObjectManagementMode.NONEXISTENT || this.getModeBefore() == BrooklynObjectManagementMode.UNMANAGED_PERSISTED;
    }

    public boolean isNoLongerLoaded() {
        return this.getModeAfter() == BrooklynObjectManagementMode.NONEXISTENT || this.getModeAfter() == BrooklynObjectManagementMode.UNMANAGED_PERSISTED;
    }

    public boolean wasPrimary() {
        return this.getModeBefore() == BrooklynObjectManagementMode.MANAGED_PRIMARY;
    }

    public boolean isPrimary() {
        return this.getModeAfter() == BrooklynObjectManagementMode.MANAGED_PRIMARY;
    }

    public boolean wasReadOnly() {
        return this.getModeBefore() == BrooklynObjectManagementMode.LOADED_READ_ONLY;
    }

    public boolean isReadOnly() {
        return this.getModeAfter() == BrooklynObjectManagementMode.LOADED_READ_ONLY;
    }

    public boolean isCreating() {
        if (this.getModeBefore() != BrooklynObjectManagementMode.NONEXISTENT) {
            return false;
        }
        if (this.getModeAfter() == BrooklynObjectManagementMode.LOADED_READ_ONLY) {
            log.warn("isCreating set on RO object; highly irregular!");
        }
        return true;
    }

    public boolean isDestroying() {
        return this.getModeAfter() == BrooklynObjectManagementMode.NONEXISTENT;
    }

    public String toString() {
        return ManagementTransitionMode.class.getSimpleName() + "[" + (Object)((Object)this.getModeBefore()) + "->" + (Object)((Object)this.getModeAfter()) + "]";
    }
}

