/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.internal.storage.BrooklynStorage;
import brooklyn.location.Location;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.LocationInternal;
import brooklyn.management.ManagementContextInjectable;
import brooklyn.management.entitlement.EntitlementContext;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.UsageListener;
import brooklyn.management.internal.UsageManager;
import brooklyn.management.usage.ApplicationUsage;
import brooklyn.management.usage.LocationUsage;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.time.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalUsageManager
implements UsageManager {
    private static final Logger log = LoggerFactory.getLogger(LocalUsageManager.class);
    @VisibleForTesting
    public static final String APPLICATION_USAGE_KEY = "usage-application";
    @VisibleForTesting
    public static final String LOCATION_USAGE_KEY = "usage-location";
    private final LocalManagementContext managementContext;
    private final Object mutex = new Object();
    private final List<UsageListener> listeners = Lists.newCopyOnWriteArrayList();
    private final AtomicInteger listenerQueueSize = new AtomicInteger();
    private ListeningExecutorService listenerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("brooklyn-usagemanager-listener-%d").build()));

    public LocalUsageManager(LocalManagementContext managementContext) {
        this.managementContext = (LocalManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        Collection listeners = managementContext.getBrooklynProperties().getConfig(UsageManager.USAGE_LISTENERS);
        if (listeners != null) {
            for (Object listener : listeners) {
                if (listener instanceof ManagementContextInjectable) {
                    ((ManagementContextInjectable)listener).injectManagementContext(managementContext);
                }
                if (listener instanceof UsageManager.UsageListener) {
                    this.addUsageListener((UsageManager.UsageListener)listener);
                    continue;
                }
                if (listener instanceof UsageListener) {
                    this.addUsageListener((UsageListener)listener);
                    continue;
                }
                if (listener == null) {
                    throw new NullPointerException("null listener in config " + UsageManager.USAGE_LISTENERS);
                }
                throw new ClassCastException("listener " + listener + " of type " + listener.getClass() + " is not of type " + UsageListener.class.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Duration timeout = this.managementContext.getBrooklynProperties().getConfig(UsageManager.USAGE_LISTENER_TERMINATION_TIMEOUT);
        if (this.listenerQueueSize.get() > 0) {
            log.info("Usage manager waiting for " + this.listenerQueueSize + " listener events for up to " + timeout);
        }
        ArrayList futures = Lists.newArrayList();
        for (final UsageListener listener : this.listeners) {
            ListenableFuture future = this.listenerExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    if (listener instanceof Closeable) {
                        try {
                            ((Closeable)((Object)listener)).close();
                        }
                        catch (IOException e) {
                            log.warn("Problem closing usage listener " + listener + " (continuing)", (Throwable)e);
                        }
                    }
                }
            });
            futures.add(future);
        }
        try {
            Futures.successfulAsList((Iterable)futures).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Problem terminiating usage listeners (continuing)", (Throwable)e);
        }
        finally {
            this.listenerExecutor.shutdownNow();
        }
    }

    private void execOnListeners(final Function<UsageListener, Void> job) {
        for (final UsageListener listener : this.listeners) {
            this.listenerQueueSize.incrementAndGet();
            this.listenerExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        job.apply((Object)listener);
                    }
                    catch (RuntimeException e) {
                        log.error("Problem notifying listener " + listener + " of " + job, (Throwable)e);
                        Exceptions.propagateIfFatal((Throwable)e);
                    }
                    finally {
                        LocalUsageManager.this.listenerQueueSize.decrementAndGet();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordApplicationEvent(final Application app, final Lifecycle state) {
        log.debug("Storing application lifecycle usage event: application {} in state {}", new Object[]{app, state});
        ConcurrentMap<String, ApplicationUsage> eventMap = this.managementContext.getStorage().getMap(APPLICATION_USAGE_KEY);
        Object object = this.mutex;
        synchronized (object) {
            ApplicationUsage usage = (ApplicationUsage)eventMap.get(app.getId());
            if (usage == null) {
                usage = new ApplicationUsage(app.getId(), app.getDisplayName(), app.getEntityType().getName(), ((EntityInternal)app).toMetadataRecord());
            }
            final ApplicationUsage.ApplicationEvent event = new ApplicationUsage.ApplicationEvent(state, this.getUser());
            usage.addEvent(event);
            eventMap.put(app.getId(), usage);
            this.execOnListeners(new Function<UsageListener, Void>(){

                public Void apply(UsageListener listener) {
                    listener.onApplicationEvent(new ApplicationMetadataImpl(Entities.proxy(app)), event);
                    return null;
                }

                public String toString() {
                    return "applicationEvent(" + app + ", " + (Object)((Object)state) + ")";
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLocationEvent(final Location loc, final Lifecycle state) {
        Preconditions.checkNotNull((Object)loc, (Object)"location");
        Preconditions.checkNotNull((Object)((Object)state), (String)"state of location %s", (Object[])new Object[]{loc});
        if (loc.getId() == null) {
            log.error("Ignoring location lifecycle usage event for {} (state {}), because location has no id", (Object)loc, (Object)state);
            return;
        }
        if (this.managementContext.getStorage() == null) {
            log.warn("Cannot store location lifecycle usage event for {} (state {}), because storage not available", (Object)loc, (Object)state);
            return;
        }
        Object callerContext = loc.getConfig(LocationConfigKeys.CALLER_CONTEXT);
        if (callerContext != null && callerContext instanceof Entity) {
            log.debug("Storing location lifecycle usage event: location {} in state {}; caller context {}", new Object[]{loc, state, callerContext});
            Entity caller = (Entity)callerContext;
            String entityTypeName = caller.getEntityType().getName();
            String appId = caller.getApplicationId();
            final LocationUsage.LocationEvent event = new LocationUsage.LocationEvent(state, caller.getId(), entityTypeName, appId, this.getUser());
            ConcurrentMap<String, LocationUsage> usageMap = this.managementContext.getStorage().getMap(LOCATION_USAGE_KEY);
            Object object = this.mutex;
            synchronized (object) {
                LocationUsage usage = (LocationUsage)usageMap.get(loc.getId());
                if (usage == null) {
                    usage = new LocationUsage(loc.getId(), ((LocationInternal)loc).toMetadataRecord());
                }
                usage.addEvent(event);
                usageMap.put(loc.getId(), usage);
                this.execOnListeners(new Function<UsageListener, Void>(){

                    public Void apply(UsageListener listener) {
                        listener.onLocationEvent(new LocationMetadataImpl(loc), event);
                        return null;
                    }

                    public String toString() {
                        return "locationEvent(" + loc + ", " + (Object)((Object)state) + ")";
                    }
                });
            }
        } else {
            log.trace("Not recording location lifecycle usage event for {} in state {}, because no caller context", new Object[]{loc, state});
        }
    }

    @Override
    public LocationUsage getLocationUsage(String locationId) {
        BrooklynStorage storage = this.managementContext.getStorage();
        ConcurrentMap usageMap = storage.getMap(LOCATION_USAGE_KEY);
        return (LocationUsage)usageMap.get(locationId);
    }

    @Override
    public Set<LocationUsage> getLocationUsage(Predicate<? super LocationUsage> filter) {
        ConcurrentMap usageMap = this.managementContext.getStorage().getMap(LOCATION_USAGE_KEY);
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (LocationUsage usage : usageMap.values()) {
            if (!filter.apply((Object)usage)) continue;
            result.add(usage);
        }
        return result;
    }

    @Override
    public ApplicationUsage getApplicationUsage(String appId) {
        BrooklynStorage storage = this.managementContext.getStorage();
        ConcurrentMap usageMap = storage.getMap(APPLICATION_USAGE_KEY);
        return (ApplicationUsage)usageMap.get(appId);
    }

    @Override
    public Set<ApplicationUsage> getApplicationUsage(Predicate<? super ApplicationUsage> filter) {
        ConcurrentMap usageMap = this.managementContext.getStorage().getMap(APPLICATION_USAGE_KEY);
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (ApplicationUsage usage : usageMap.values()) {
            if (!filter.apply((Object)usage)) continue;
            result.add(usage);
        }
        return result;
    }

    @Override
    @Deprecated
    public void addUsageListener(UsageManager.UsageListener listener) {
        this.addUsageListener(new UsageManager.UsageListener.UsageListenerAdapter(listener));
    }

    @Override
    @Deprecated
    public void removeUsageListener(UsageManager.UsageListener listener) {
        this.removeUsageListener(new UsageManager.UsageListener.UsageListenerAdapter(listener));
    }

    @Override
    public void addUsageListener(UsageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUsageListener(UsageListener listener) {
        this.listeners.remove(listener);
    }

    private String getUser() {
        EntitlementContext entitlementContext = Entitlements.getEntitlementContext();
        if (entitlementContext != null) {
            return entitlementContext.user();
        }
        return null;
    }

    static {
        TypeCoercions.registerAdapter(String.class, UsageListener.class, new Function<String, UsageListener>(){

            public UsageListener apply(String input) {
                ClassLoader classLoader = LocalUsageManager.class.getClassLoader();
                Optional result = Reflections.invokeConstructorWithArgs((ClassLoader)classLoader, (String)input, (Object[])new Object[0]);
                if (result.isPresent()) {
                    if (result.get() instanceof UsageManager.UsageListener) {
                        return new UsageManager.UsageListener.UsageListenerAdapter((UsageManager.UsageListener)result.get());
                    }
                    return (UsageListener)result.get();
                }
                throw new IllegalStateException("Failed to create UsageListener from class name '" + input + "' using no-arg constructor");
            }
        });
    }

    private static class LocationMetadataImpl
    implements UsageListener.LocationMetadata {
        private final Location loc;
        private String locationId;
        private Map<String, String> metadata;

        LocationMetadataImpl(Location loc) {
            this.loc = (Location)Preconditions.checkNotNull((Object)loc, (Object)"loc");
            this.locationId = loc.getId();
            this.metadata = ((LocationInternal)loc).toMetadataRecord();
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }

        @Override
        public String getLocationId() {
            return this.locationId;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }

    private static class ApplicationMetadataImpl
    implements UsageListener.ApplicationMetadata {
        private final Application app;
        private String applicationId;
        private String applicationName;
        private String entityType;
        private String catalogItemId;
        private Map<String, String> metadata;

        ApplicationMetadataImpl(Application app) {
            this.app = (Application)Preconditions.checkNotNull((Object)app, (Object)"app");
            this.applicationId = app.getId();
            this.applicationName = app.getDisplayName();
            this.entityType = app.getEntityType().getName();
            this.catalogItemId = app.getCatalogItemId();
            this.metadata = ((EntityInternal)app).toMetadataRecord();
        }

        @Override
        public Application getApplication() {
            return this.app;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getEntityType() {
            return this.entityType;
        }

        @Override
        public String getCatalogItemId() {
            return this.catalogItemId;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

