/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.management.ExecutionManager;
import brooklyn.management.SubscriptionHandle;
import brooklyn.management.internal.AbstractSubscriptionManager;
import brooklyn.management.internal.Subscription;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.task.BasicExecutionManager;
import brooklyn.util.task.SingleThreadedScheduler;
import brooklyn.util.text.Identifiers;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSubscriptionManager
extends AbstractSubscriptionManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSubscriptionManager.class);
    protected final ExecutionManager em;
    private final String tostring = "SubscriptionContext(" + Identifiers.getBase64IdFromValue((long)System.identityHashCode(this), (int)5) + ")";
    private final AtomicLong totalEventsPublishedCount = new AtomicLong();
    private final AtomicLong totalEventsDeliveredCount = new AtomicLong();
    protected final ConcurrentMap<String, Subscription> allSubscriptions = new ConcurrentHashMap<String, Subscription>();
    protected final ConcurrentMap<Object, Set<Subscription>> subscriptionsBySubscriber = new ConcurrentHashMap<Object, Set<Subscription>>();
    protected final ConcurrentMap<Object, Set<Subscription>> subscriptionsByToken = new ConcurrentHashMap<Object, Set<Subscription>>();

    public LocalSubscriptionManager(ExecutionManager m) {
        this.em = m;
    }

    public long getNumSubscriptions() {
        return this.allSubscriptions.size();
    }

    public long getTotalEventsPublished() {
        return this.totalEventsPublishedCount.get();
    }

    public long getTotalEventsDelivered() {
        return this.totalEventsDeliveredCount.get();
    }

    @Override
    protected synchronized <T> SubscriptionHandle subscribe(Map<String, Object> flags, Subscription<T> s) {
        Entity producer = s.producer;
        Sensor sensor = s.sensor;
        s.subscriber = this.getSubscriber(flags, s);
        if (flags.containsKey("subscriberExecutionManagerTag")) {
            s.subscriberExecutionManagerTag = flags.remove("subscriberExecutionManagerTag");
            s.subscriberExecutionManagerTagSupplied = true;
        } else {
            s.subscriberExecutionManagerTag = s.subscriber instanceof Entity ? "subscription-delivery-entity-" + ((Entity)s.subscriber).getId() + "[" + s.subscriber + "]" : (s.subscriber instanceof String ? "subscription-delivery-string[" + s.subscriber + "]" : "subscription-delivery-object[" + s.subscriber + "]");
            s.subscriberExecutionManagerTagSupplied = false;
        }
        s.eventFilter = (Predicate)flags.remove("eventFilter");
        s.flags = flags;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating subscription {} for {} on {} {} in {}", new Object[]{s.id, s.subscriber, producer, sensor, this});
        }
        this.allSubscriptions.put(s.id, s);
        LocalSubscriptionManager.addToMapOfSets(this.subscriptionsByToken, LocalSubscriptionManager.makeEntitySensorToken(s.producer, s.sensor), s);
        if (s.subscriber != null) {
            LocalSubscriptionManager.addToMapOfSets(this.subscriptionsBySubscriber, s.subscriber, s);
        }
        if (!s.subscriberExecutionManagerTagSupplied && s.subscriberExecutionManagerTag != null) {
            ((BasicExecutionManager)this.em).setTaskSchedulerForTag(s.subscriberExecutionManagerTag, SingleThreadedScheduler.class);
        }
        return s;
    }

    public Set<SubscriptionHandle> getSubscriptionsForSubscriber(Object subscriber) {
        return (Set)JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsBySubscriber.get(subscriber)), Collections.emptySet());
    }

    public synchronized Set<SubscriptionHandle> getSubscriptionsForEntitySensor(Entity source, Sensor<?> sensor) {
        LinkedHashSet<SubscriptionHandle> subscriptions = new LinkedHashSet<SubscriptionHandle>();
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(source, sensor))), Collections.emptySet()));
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(null, sensor))), Collections.emptySet()));
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(source, null))), Collections.emptySet()));
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(null, null))), Collections.emptySet()));
        return subscriptions;
    }

    public synchronized boolean unsubscribe(SubscriptionHandle sh) {
        if (!(sh instanceof Subscription)) {
            throw new IllegalArgumentException("Only subscription handles of type Subscription supported: sh=" + sh + "; type=" + (sh != null ? sh.getClass().getCanonicalName() : null));
        }
        Subscription s = (Subscription)sh;
        boolean result = this.allSubscriptions.remove(s.id) != null;
        boolean b2 = LocalSubscriptionManager.removeFromMapOfCollections(this.subscriptionsByToken, LocalSubscriptionManager.makeEntitySensorToken(s.producer, s.sensor), s);
        assert (result == b2);
        if (s.subscriber != null) {
            boolean b3 = LocalSubscriptionManager.removeFromMapOfCollections(this.subscriptionsBySubscriber, s.subscriber, s);
            assert (b3 == b2);
        }
        ((BasicExecutionManager)this.em).setTaskSchedulerForTag(s.subscriberExecutionManagerTag, SingleThreadedScheduler.class);
        return result;
    }

    @Override
    public <T> void publish(final SensorEvent<T> event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} got event {}", (Object)this, event);
        }
        this.totalEventsPublishedCount.incrementAndGet();
        Set<SubscriptionHandle> subs = this.getSubscriptionsForEntitySensor(event.getSource(), event.getSensor());
        if (JavaGroovyEquivalents.groovyTruth(subs)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("sending {}, {} to {}", new Object[]{event.getSensor().getName(), event, JavaGroovyEquivalents.join(subs, (String)",")});
            }
            for (Subscription subscription : subs) {
                if (subscription.eventFilter != null && !subscription.eventFilter.apply(event)) continue;
                final Subscription sAtClosureCreation = subscription;
                Map tagsMap = JavaGroovyEquivalents.mapOf((Object)"tag", (Object)subscription.subscriberExecutionManagerTag);
                this.em.submit(tagsMap, new Runnable(){

                    public String toString() {
                        return "LSM.publish(" + event + ")";
                    }

                    @Override
                    public void run() {
                        try {
                            sAtClosureCreation.listener.onEvent(event);
                        }
                        catch (Throwable t) {
                            if (event != null && event.getSource() != null && Entities.isNoLongerManaged(event.getSource())) {
                                LOG.debug("Error in " + this + ", after entity unmanaged: " + t, t);
                            }
                            LOG.warn("Error in " + this + ": " + t, t);
                        }
                    }
                });
                this.totalEventsDeliveredCount.incrementAndGet();
            }
        }
    }

    public String toString() {
        return this.tostring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static <K, V> Set<V> addToMapOfSets(Map<K, Set<V>> map, K key, V valueInCollection) {
        Set<V> coll;
        Object object = map;
        synchronized (object) {
            coll = map.get(key);
            if (coll == null) {
                coll = new LinkedHashSet<V>();
                map.put(key, coll);
            }
            if (coll.isEmpty()) {
                Set<V> set = coll;
                synchronized (set) {
                    coll.add(valueInCollection);
                }
                return coll;
            }
        }
        object = coll;
        synchronized (object) {
            if (!coll.isEmpty()) {
                coll.add(valueInCollection);
                return coll;
            }
        }
        return LocalSubscriptionManager.addToMapOfSets(map, key, valueInCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static <K, V> boolean removeFromMapOfCollections(Map<K, ? extends Collection<V>> map, K key, V valueInCollection) {
        boolean result;
        Collection<V> coll;
        Map<K, Collection<V>> map2 = map;
        synchronized (map2) {
            coll = map.get(key);
            if (coll == null) {
                return false;
            }
        }
        Object object = coll;
        synchronized (object) {
            result = coll.remove(valueInCollection);
        }
        if (coll.isEmpty()) {
            object = map;
            synchronized (object) {
                Collection<V> collection = coll;
                synchronized (collection) {
                    if (coll.isEmpty() && map.get(key) == coll) {
                        map.remove(key);
                    }
                }
            }
        }
        return result;
    }
}

