/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.config.BrooklynProperties;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.drivers.downloads.BasicDownloadsManager;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.proxying.InternalEntityFactory;
import brooklyn.entity.proxying.InternalLocationFactory;
import brooklyn.entity.proxying.InternalPolicyFactory;
import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.internal.storage.DataGridFactory;
import brooklyn.location.Location;
import brooklyn.management.AccessController;
import brooklyn.management.ExecutionManager;
import brooklyn.management.ManagementContext;
import brooklyn.management.SubscriptionManager;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.ha.OsgiManager;
import brooklyn.management.internal.AbstractManagementContext;
import brooklyn.management.internal.BrooklynGarbageCollector;
import brooklyn.management.internal.CollectionChangeListener;
import brooklyn.management.internal.LocalAccessManager;
import brooklyn.management.internal.LocalEntityManager;
import brooklyn.management.internal.LocalLocationManager;
import brooklyn.management.internal.LocalSubscriptionManager;
import brooklyn.management.internal.LocalUsageManager;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.BasicExecutionContext;
import brooklyn.util.task.BasicExecutionManager;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskTags;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalManagementContext
extends AbstractManagementContext {
    private static final Logger log = LoggerFactory.getLogger(LocalManagementContext.class);
    private static final Set<LocalManagementContext> INSTANCES = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final BrooklynProperties.Factory.Builder builder;
    private final List<ManagementContext.PropertiesReloadListener> reloadListeners = new CopyOnWriteArrayList<ManagementContext.PropertiesReloadListener>();
    private String managementPlaneId;
    private String managementNodeId;
    private BasicExecutionManager execution;
    private SubscriptionManager subscriptions;
    private LocalEntityManager entityManager;
    private final LocalLocationManager locationManager;
    private final LocalAccessManager accessManager;
    private final LocalUsageManager usageManager;
    private OsgiManager osgiManager;
    public final Throwable constructionStackTrace = new Throwable("for construction stacktrace").fillInStackTrace();
    private final Map<String, Object> brooklynAdditionalProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static Set<LocalManagementContext> getInstances() {
        Set<LocalManagementContext> set = INSTANCES;
        synchronized (set) {
            return ImmutableSet.copyOf(INSTANCES);
        }
    }

    public static void logAll(Logger logger) {
        for (LocalManagementContext context : LocalManagementContext.getInstances()) {
            logger.warn("Management Context " + context + " running, creation stacktrace:\n" + Throwables.getStackTraceAsString((Throwable)context.constructionStackTrace));
        }
    }

    @Beta
    public static int terminateAll() {
        int closed = 0;
        int dangling = 0;
        for (LocalManagementContext context : LocalManagementContext.getInstances()) {
            try {
                context.terminate();
                ++closed;
            }
            catch (Throwable t) {
                Exceptions.propagateIfFatal((Throwable)t);
                log.warn("Failed to terminate management context", t);
                ++dangling;
            }
        }
        if (dangling > 0) {
            return -dangling;
        }
        return closed;
    }

    public LocalManagementContext() {
        this(BrooklynProperties.Factory.builderDefault());
    }

    public LocalManagementContext(BrooklynProperties brooklynProperties) {
        this(brooklynProperties, (DataGridFactory)null);
    }

    @VisibleForTesting
    public LocalManagementContext(BrooklynProperties brooklynProperties, DataGridFactory datagridFactory) {
        this(BrooklynProperties.Factory.Builder.fromProperties(brooklynProperties), datagridFactory);
    }

    public LocalManagementContext(BrooklynProperties.Factory.Builder builder) {
        this(builder, null, null);
    }

    public LocalManagementContext(BrooklynProperties.Factory.Builder builder, DataGridFactory datagridFactory) {
        this(builder, null, datagridFactory);
    }

    public LocalManagementContext(BrooklynProperties.Factory.Builder builder, Map<String, Object> brooklynAdditionalProperties) {
        this(builder, brooklynAdditionalProperties, null);
    }

    public LocalManagementContext(BrooklynProperties brooklynProperties, Map<String, Object> brooklynAdditionalProperties) {
        this(BrooklynProperties.Factory.Builder.fromProperties(brooklynProperties), brooklynAdditionalProperties, null);
    }

    public LocalManagementContext(BrooklynProperties.Factory.Builder builder, Map<String, Object> brooklynAdditionalProperties, DataGridFactory datagridFactory) {
        super(builder.build(), datagridFactory);
        Preconditions.checkNotNull((Object)this.configMap, (Object)"brooklynProperties");
        this.managementPlaneId = Strings.makeRandomId((int)8);
        this.managementNodeId = Strings.makeRandomId((int)8);
        this.builder = builder;
        this.brooklynAdditionalProperties = brooklynAdditionalProperties;
        if (brooklynAdditionalProperties != null) {
            this.configMap.addFromMap(brooklynAdditionalProperties);
        }
        BrooklynFeatureEnablement.init(this.configMap);
        this.locationManager = new LocalLocationManager(this);
        this.accessManager = new LocalAccessManager();
        this.usageManager = new LocalUsageManager(this);
        if (this.configMap.getConfig(OsgiManager.USE_OSGI).booleanValue()) {
            this.osgiManager = new OsgiManager(this);
            this.osgiManager.start();
        }
        INSTANCES.add(this);
        log.debug("Created management context " + this);
    }

    public String getManagementPlaneId() {
        return this.managementPlaneId;
    }

    public String getManagementNodeId() {
        return this.managementNodeId;
    }

    @Override
    public void prePreManage(Entity entity) {
        this.getEntityManager().prePreManage(entity);
    }

    @Override
    public void prePreManage(Location location) {
        this.getLocationManager().prePreManage(location);
    }

    public synchronized Collection<Application> getApplications() {
        return this.getEntityManager().getApplications();
    }

    @Override
    public void addEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.getEntityManager().addEntitySetListener(listener);
    }

    @Override
    public void removeEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.getEntityManager().removeEntitySetListener(listener);
    }

    @Override
    protected void manageIfNecessary(Entity entity, Object context) {
        this.getEntityManager().manageIfNecessary(entity, context);
    }

    public synchronized LocalEntityManager getEntityManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.entityManager == null) {
            this.entityManager = new LocalEntityManager(this);
        }
        return this.entityManager;
    }

    @Override
    public InternalEntityFactory getEntityFactory() {
        return this.getEntityManager().getEntityFactory();
    }

    @Override
    public InternalLocationFactory getLocationFactory() {
        return this.getLocationManager().getLocationFactory();
    }

    @Override
    public InternalPolicyFactory getPolicyFactory() {
        return this.getEntityManager().getPolicyFactory();
    }

    public synchronized LocalLocationManager getLocationManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.locationManager;
    }

    @Override
    public synchronized LocalAccessManager getAccessManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.accessManager;
    }

    @Override
    public synchronized LocalUsageManager getUsageManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.usageManager;
    }

    @Override
    public synchronized Maybe<OsgiManager> getOsgiManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.osgiManager == null) {
            return Maybe.absent((String)"OSGi not available in this instance");
        }
        return Maybe.of((Object)this.osgiManager);
    }

    public synchronized AccessController getAccessController() {
        return this.getAccessManager().getAccessController();
    }

    public synchronized SubscriptionManager getSubscriptionManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LocalSubscriptionManager(this.getExecutionManager());
        }
        return this.subscriptions;
    }

    public synchronized ExecutionManager getExecutionManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.execution == null) {
            this.execution = new BasicExecutionManager(this.getManagementNodeId());
            this.gc = new BrooklynGarbageCollector(this.configMap, this.execution, this.getStorage());
        }
        return this.execution;
    }

    @Override
    public void terminate() {
        INSTANCES.remove(this);
        super.terminate();
        if (this.osgiManager != null) {
            this.osgiManager.stop();
            this.osgiManager = null;
        }
        if (this.usageManager != null) {
            this.usageManager.terminate();
        }
        if (this.execution != null) {
            this.execution.shutdownNow();
        }
        if (this.gc != null) {
            this.gc.shutdownNow();
        }
    }

    protected void finalize() {
        this.terminate();
    }

    @Override
    public <T> Task<T> runAtEntity(Map flags, Entity entity, Callable<T> c) {
        this.manageIfNecessary(entity, JavaGroovyEquivalents.elvis(Arrays.asList(flags.get("displayName"), flags.get("description"), flags, c)));
        return this.runAtEntity(entity, (TaskAdaptable<T>)Tasks.builder().dynamic(true).body(c).flags(flags).build());
    }

    protected <T> Task<T> runAtEntity(Entity entity, TaskAdaptable<T> task) {
        this.getExecutionContext(entity).submit(task);
        if (DynamicTasks.getTaskQueuingContext() != null) {
            TaskTags.markInessential(task);
            DynamicTasks.getTaskQueuingContext().queue(task.asTask());
        }
        return task.asTask();
    }

    @Override
    protected <T> Task<T> runAtEntity(Entity entity, Effector<T> eff, Map parameters) {
        this.manageIfNecessary(entity, eff);
        BasicExecutionContext ec = BasicExecutionContext.getCurrentExecutionContext();
        if (ec == null) {
            log.debug("Top-level effector invocation: {} on {}", eff, (Object)entity);
            ec = this.getExecutionContext(entity);
        }
        return this.runAtEntity(entity, Effectors.invocation(entity, eff, parameters));
    }

    @Override
    public boolean isManagedLocally(Entity e) {
        return true;
    }

    public String toString() {
        return LocalManagementContext.class.getSimpleName() + "[" + this.getManagementPlaneId() + "-" + this.getManagementNodeId() + "]";
    }

    public void reloadBrooklynProperties() {
        BrooklynProperties properties;
        log.info("Reloading brooklyn properties from " + this.builder);
        if (this.builder.hasDelegateOriginalProperties()) {
            log.warn("When reloading, mgmt context " + this + " properties are fixed, so reload will be of limited utility");
        }
        this.configMap = properties = this.builder.build();
        if (this.brooklynAdditionalProperties != null) {
            log.info("Reloading additional brooklyn properties from " + this.brooklynAdditionalProperties);
            this.configMap.addFromMap(this.brooklynAdditionalProperties);
        }
        this.downloadsManager = BasicDownloadsManager.newDefault(this.configMap);
        this.clearLocationRegistry();
        BrooklynFeatureEnablement.init(this.configMap);
        for (ManagementContext.PropertiesReloadListener listener : this.reloadListeners) {
            listener.reloaded();
        }
    }

    @VisibleForTesting
    public void clearLocationRegistry() {
        this.locationRegistry = null;
    }

    public void addPropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.reloadListeners.add((ManagementContext.PropertiesReloadListener)Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    public void removePropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.reloadListeners.remove(listener);
    }

    public void noteStartupComplete() {
        this.startupComplete = true;
    }
}

