/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.basic.BrooklynObject;
import brooklyn.config.BrooklynLogging;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.proxying.BasicEntityTypeRegistry;
import brooklyn.entity.proxying.EntityProxy;
import brooklyn.entity.proxying.EntityProxyImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.EntityTypeRegistry;
import brooklyn.entity.proxying.InternalEntityFactory;
import brooklyn.entity.proxying.InternalPolicyFactory;
import brooklyn.entity.trait.Startable;
import brooklyn.internal.storage.BrooklynStorage;
import brooklyn.management.AccessController;
import brooklyn.management.Task;
import brooklyn.management.internal.AsyncCollectionChangeAdapter;
import brooklyn.management.internal.BrooklynObjectManagementMode;
import brooklyn.management.internal.CollectionChangeListener;
import brooklyn.management.internal.EntityManagerInternal;
import brooklyn.management.internal.GroovyObservablesPropertyChangeToCollectionChangeAdapter;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.ManagementTransitionInfo;
import brooklyn.management.internal.ManagementTransitionMode;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.collections.SetFromLiveMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.util.ObservableList;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEntityManager
implements EntityManagerInternal {
    private static final Logger log = LoggerFactory.getLogger(LocalEntityManager.class);
    private final LocalManagementContext managementContext;
    private final BasicEntityTypeRegistry entityTypeRegistry;
    private final InternalEntityFactory entityFactory;
    private final InternalPolicyFactory policyFactory;
    protected final Map<String, Entity> preRegisteredEntitiesById = Collections.synchronizedMap(new WeakHashMap());
    protected final Map<String, Entity> preManagedEntitiesById = Collections.synchronizedMap(new WeakHashMap());
    protected final ConcurrentMap<String, Entity> entityProxiesById = Maps.newConcurrentMap();
    protected final Map<String, Entity> entitiesById = Maps.newLinkedHashMap();
    protected final Map<String, ManagementTransitionMode> entityModesById = Collections.synchronizedMap(Maps.newLinkedHashMap());
    protected final ObservableList entities = new ObservableList();
    protected final Set<Application> applications = Sets.newConcurrentHashSet();
    private final BrooklynStorage storage;
    private final Map<String, String> entityTypes;
    private final Set<String> applicationIds;

    public LocalEntityManager(LocalManagementContext managementContext) {
        this.managementContext = (LocalManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        this.storage = managementContext.getStorage();
        this.entityTypeRegistry = new BasicEntityTypeRegistry();
        this.policyFactory = new InternalPolicyFactory(managementContext);
        this.entityFactory = new InternalEntityFactory(managementContext, this.entityTypeRegistry, this.policyFactory);
        this.entityTypes = this.storage.getMap("entities");
        this.applicationIds = SetFromLiveMap.create(this.storage.getMap("applications"));
    }

    public InternalEntityFactory getEntityFactory() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.entityFactory;
    }

    public InternalPolicyFactory getPolicyFactory() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.policyFactory;
    }

    public EntityTypeRegistry getEntityTypeRegistry() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.entityTypeRegistry;
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec) {
        try {
            T entity = this.entityFactory.createEntity(spec);
            Entity proxy = ((AbstractEntity)entity).getProxy();
            return (T)((Entity)Preconditions.checkNotNull((Object)proxy, (String)"proxy for entity %s, spec %s", (Object[])new Object[]{entity, spec}));
        }
        catch (Throwable e) {
            log.warn("Failed to create entity using spec " + spec + " (rethrowing)", e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Entity> T createEntity(Map<?, ?> config, Class<T> type) {
        return this.createEntity(EntitySpec.create(config, type));
    }

    public <T extends Policy> T createPolicy(PolicySpec<T> spec) {
        try {
            return this.policyFactory.createPolicy(spec);
        }
        catch (Throwable e) {
            log.warn("Failed to create policy using spec " + spec + " (rethrowing)", e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Enricher> T createEnricher(EnricherSpec<T> spec) {
        try {
            return this.policyFactory.createEnricher(spec);
        }
        catch (Throwable e) {
            log.warn("Failed to create enricher using spec " + spec + " (rethrowing)", e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Collection<Entity> getEntities() {
        return ImmutableList.copyOf(this.entityProxiesById.values());
    }

    public Collection<String> getEntityIds() {
        return ImmutableList.copyOf(this.entityProxiesById.keySet());
    }

    public Collection<Entity> getEntitiesInApplication(Application application) {
        Predicate<Entity> predicate = EntityPredicates.applicationIdEqualTo(application.getId());
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.entityProxiesById.values(), predicate));
    }

    public Collection<Entity> findEntities(Predicate<? super Entity> filter) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.entityProxiesById.values(), filter));
    }

    public Collection<Entity> findEntitiesInApplication(Application application, Predicate<? super Entity> filter) {
        Predicate predicate = Predicates.and(EntityPredicates.applicationIdEqualTo(application.getId()), filter);
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.entityProxiesById.values(), (Predicate)predicate));
    }

    @Override
    public Iterable<Entity> getAllEntitiesInApplication(Application application) {
        Predicate<Entity> predicate = EntityPredicates.applicationIdEqualTo(application.getId());
        Iterable allentities = Iterables.concat(this.preRegisteredEntitiesById.values(), this.preManagedEntitiesById.values(), this.entityProxiesById.values());
        Iterable result = Iterables.filter((Iterable)allentities, predicate);
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result, (Function)new Function<Entity, Entity>(){

            public Entity apply(Entity input) {
                return Entities.proxy(input);
            }
        }));
    }

    public Entity getEntity(String id) {
        return (Entity)this.entityProxiesById.get(id);
    }

    Collection<Application> getApplications() {
        return ImmutableList.copyOf(this.applications);
    }

    public boolean isManaged(Entity e) {
        return this.isRunning() && this.getEntity(e.getId()) != null;
    }

    boolean isPreRegistered(Entity e) {
        return this.preRegisteredEntitiesById.containsKey(e.getId());
    }

    void prePreManage(Entity entity) {
        if (this.isPreRegistered(entity)) {
            log.warn("" + this + " redundant call to pre-pre-manage entity " + entity + "; skipping", (Throwable)new Exception("source of duplicate pre-pre-manage of " + entity));
            return;
        }
        this.preRegisteredEntitiesById.put(entity.getId(), entity);
    }

    @Override
    public ManagementTransitionMode getLastManagementTransitionMode(String itemId) {
        return this.entityModesById.get(itemId);
    }

    @Override
    public void setManagementTransitionMode(Entity item, ManagementTransitionMode mode) {
        this.entityModesById.put(item.getId(), mode);
    }

    public void manage(Entity e) {
        if (this.isManaged(e)) {
            log.warn("" + this + " redundant call to start management of entity (and descendants of) " + e + "; skipping", (Throwable)new Exception("source of duplicate management of " + e));
            return;
        }
        this.manageRecursive(e, ManagementTransitionMode.guessing(BrooklynObjectManagementMode.NONEXISTENT, BrooklynObjectManagementMode.MANAGED_PRIMARY));
    }

    @Override
    public void manageRebindedRoot(Entity item) {
        ManagementTransitionMode mode = this.getLastManagementTransitionMode(item.getId());
        Preconditions.checkNotNull((Object)mode, (String)"Mode not set for rebinding %s", (Object[])new Object[]{item});
        this.manageRecursive(item, mode);
    }

    protected void checkManagementAllowed(Entity item) {
        AccessController.Response access = this.managementContext.getAccessController().canManageEntity(item);
        if (!access.isAllowed()) {
            throw new IllegalStateException("Access controller forbids management of " + item + ": " + access.getMsg());
        }
    }

    protected void manageRecursive(Entity e, final ManagementTransitionMode initialMode) {
        this.checkManagementAllowed(e);
        final ArrayList allEntities = Lists.newArrayList();
        Predicate<EntityInternal> manageEntity = new Predicate<EntityInternal>(){

            public boolean apply(EntityInternal it) {
                Boolean isReadOnlyFromEntity;
                ManagementTransitionMode mode = LocalEntityManager.this.getLastManagementTransitionMode(it.getId());
                if (mode == null) {
                    mode = initialMode;
                    LocalEntityManager.this.setManagementTransitionMode((Entity)it, mode);
                }
                if ((isReadOnlyFromEntity = it.getManagementSupport().isReadOnlyRaw()) == null) {
                    if (mode.isReadOnly()) {
                        log.warn("Read-only entity " + it + " not marked as such on call to manage; marking and continuing");
                    }
                    it.getManagementSupport().setReadOnly(mode.isReadOnly());
                } else if (!isReadOnlyFromEntity.equals(mode.isReadOnly())) {
                    log.warn("Read-only status at entity " + it + " (" + isReadOnlyFromEntity + ") not consistent with management mode " + mode);
                }
                if (it.getManagementSupport().isDeployed()) {
                    if (mode.wasNotLoaded()) {
                        return false;
                    }
                    if (!(mode.wasPrimary() && mode.isPrimary() || mode.wasReadOnly() && mode.isReadOnly())) {
                        log.warn("Already deployed " + it + " when managing " + mode + "/" + initialMode + "; ignoring this and all descendants");
                        return false;
                    }
                }
                boolean isNowReadOnly = Boolean.TRUE.equals(it.getManagementSupport().isReadOnly());
                if (mode.isReadOnly() != isNowReadOnly) {
                    throw new IllegalStateException("Read-only status mismatch for " + it + ": " + mode + " / RO=" + isNowReadOnly);
                }
                allEntities.add(it);
                LocalEntityManager.this.preManageNonRecursive((Entity)it, mode);
                it.getManagementSupport().onManagementStarting(new ManagementTransitionInfo(LocalEntityManager.this.managementContext, mode));
                return LocalEntityManager.this.manageNonRecursive((Entity)it, mode);
            }
        };
        boolean isRecursive = true;
        if (initialMode.wasPrimary() && initialMode.isPrimary()) {
            Entity aChild = (Entity)Iterables.getFirst((Iterable)e.getChildren(), null);
            if (aChild != null && this.isPreRegistered(aChild)) {
                log.debug("Managing " + e + " in mode " + initialMode + ", doing this recursively because a child is preregistered");
            } else {
                log.debug("Managing " + e + " but skipping recursion, as mode is " + initialMode);
                isRecursive = false;
            }
        }
        if (!isRecursive) {
            manageEntity.apply((Object)((EntityInternal)e));
        } else {
            this.recursively(e, manageEntity);
        }
        for (EntityInternal it : allEntities) {
            if (it.getManagementSupport().isFullyManaged()) continue;
            ManagementTransitionMode mode = this.getLastManagementTransitionMode(it.getId());
            ManagementTransitionInfo info = new ManagementTransitionInfo(this.managementContext, mode);
            it.getManagementSupport().onManagementStarted(info);
            this.managementContext.getRebindManager().getChangeListener().onManaged((BrooklynObject)it);
        }
    }

    public void unmanage(Entity e) {
        this.unmanage(e, ManagementTransitionMode.guessing(BrooklynObjectManagementMode.MANAGED_PRIMARY, BrooklynObjectManagementMode.NONEXISTENT));
    }

    @Override
    public void unmanage(Entity e, ManagementTransitionMode mode) {
        this.unmanage(e, mode, false);
    }

    private void unmanage(Entity e, ManagementTransitionMode mode, boolean hasBeenReplaced) {
        if (this.shouldSkipUnmanagement(e)) {
            return;
        }
        final ManagementTransitionInfo info = new ManagementTransitionInfo(this.managementContext, mode);
        if (hasBeenReplaced) {
            if (!mode.wasReadOnly()) {
                if (!mode.wasPrimary()) {
                    log.warn("Unexpected mode " + mode + " for unmanage-replace " + e + " (applying anyway)");
                }
                ((EntityInternal)e).getManagementSupport().onManagementStopping(info);
                this.stopTasks(e);
                ((EntityInternal)e).getManagementSupport().onManagementStopped(info);
            }
            return;
        }
        if (mode.wasReadOnly() && mode.isNoLongerLoaded()) {
            ((EntityInternal)e).getManagementSupport().onManagementStopping(info);
            this.unmanageNonRecursive(e);
            this.stopTasks(e);
            ((EntityInternal)e).getManagementSupport().onManagementStopped(info);
            this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)e);
            if (this.managementContext.getGarbageCollector() != null) {
                this.managementContext.getGarbageCollector().onUnmanaged(e);
            }
        } else if (mode.wasPrimary() && mode.isNoLongerLoaded()) {
            final ArrayList allEntities = Lists.newArrayList();
            this.recursively(e, new Predicate<EntityInternal>(){

                public boolean apply(EntityInternal it) {
                    if (LocalEntityManager.this.shouldSkipUnmanagement((Entity)it)) {
                        return false;
                    }
                    allEntities.add(it);
                    it.getManagementSupport().onManagementStopping(info);
                    return true;
                }
            });
            for (EntityInternal it : allEntities) {
                if (this.shouldSkipUnmanagement((Entity)it)) continue;
                this.unmanageNonRecursive((Entity)it);
                this.stopTasks((Entity)it);
            }
            for (EntityInternal it : allEntities) {
                it.getManagementSupport().onManagementStopped(info);
                this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)it);
                if (this.managementContext.getGarbageCollector() == null) continue;
                this.managementContext.getGarbageCollector().onUnmanaged(e);
            }
        } else {
            log.warn("Invalid mode for unmanage: " + mode + " on " + e + " (ignoring)");
        }
        this.preRegisteredEntitiesById.remove(e.getId());
        this.preManagedEntitiesById.remove(e.getId());
        this.entityProxiesById.remove(e.getId());
        this.entitiesById.remove(e.getId());
        this.entityModesById.remove(e.getId());
    }

    private void stopTasks(Entity entity) {
        this.stopTasks(entity, null);
    }

    @Beta
    public void stopTasks(Entity entity, @Nullable Duration timeout) {
        CountdownTimer timeleft = timeout == null ? null : timeout.countdownTimer();
        MutableSet exceptions = MutableSet.of();
        try {
            MutableSet tasksCancelled = MutableSet.of();
            for (Task t : this.managementContext.getExecutionContext(entity).getTasks()) {
                if (entity.equals(BrooklynTaskTags.getContextEntity(Tasks.current())) && this.hasTaskAsAncestor(t, Tasks.current()) || t.isDone()) continue;
                try {
                    log.debug("Cancelling " + t + " on " + entity);
                    tasksCancelled.add(t);
                    t.cancel(true);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.debug("Error cancelling " + t + " on " + entity + " (will warn when all tasks are cancelled): " + e, (Throwable)e);
                    exceptions.add(e);
                }
            }
            if (timeleft != null) {
                MutableSet tasksIncomplete = MutableSet.of();
                for (Task t : this.managementContext.getExecutionContext(entity).getTasks()) {
                    if (this.hasTaskAsAncestor(t, Tasks.current()) || Tasks.blockUntilInternalTasksEnded(t, timeleft.getDurationRemaining())) continue;
                    tasksIncomplete.add(t);
                }
                if (!tasksIncomplete.isEmpty()) {
                    log.warn("Incomplete tasks when stopping " + entity + ": " + tasksIncomplete);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Cancelled " + tasksCancelled + " tasks for " + entity + ", with " + timeleft.getDurationRemaining() + " remaining (of " + timeout + "): " + tasksCancelled);
                }
            } else if (log.isTraceEnabled()) {
                log.trace("Cancelled " + tasksCancelled + " tasks for " + entity + ": " + tasksCancelled);
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error inspecting tasks to cancel on unmanagement: " + e, (Throwable)e);
        }
        if (!exceptions.isEmpty()) {
            log.warn("Error when cancelling tasks for " + entity + " on unmanagement: " + Exceptions.create((Collection)exceptions));
        }
    }

    private boolean hasTaskAsAncestor(Task<?> t, Task<?> potentialAncestor) {
        if (t == null || potentialAncestor == null) {
            return false;
        }
        if (t.equals(potentialAncestor)) {
            return true;
        }
        return this.hasTaskAsAncestor(t.getSubmittedByTask(), potentialAncestor);
    }

    void manageIfNecessary(Entity entity, Object context) {
        Entity candidateUnmanagedParent;
        if (!this.isRunning()) {
            return;
        }
        if (((EntityInternal)entity).getManagementSupport().wasDeployed()) {
            return;
        }
        if (this.isManaged(entity)) {
            return;
        }
        if (this.isPreManaged(entity)) {
            return;
        }
        if (Boolean.TRUE.equals(((EntityInternal)entity).getManagementSupport().isReadOnly())) {
            return;
        }
        Entity rootUnmanaged = entity;
        while ((candidateUnmanagedParent = rootUnmanaged.getParent()) != null && !this.isManaged(candidateUnmanagedParent) && !this.isPreManaged(candidateUnmanagedParent)) {
            rootUnmanaged = candidateUnmanagedParent;
        }
        if (context == Startable.START.getName()) {
            log.info("Activating local management for {} on start", (Object)rootUnmanaged);
        } else {
            log.warn("Activating local management for {} due to effector invocation on {}: {}", new Object[]{rootUnmanaged, entity, context});
        }
        this.manage(rootUnmanaged);
    }

    private void recursively(Entity e, Predicate<EntityInternal> action) {
        boolean success;
        Entity otherPreregistered = this.preRegisteredEntitiesById.get(e.getId());
        if (otherPreregistered != null) {
            e = otherPreregistered;
        }
        if (!(success = action.apply((Object)((EntityInternal)e)))) {
            return;
        }
        for (Entity child : e.getChildren()) {
            this.recursively(child, action);
        }
    }

    private synchronized boolean isPreManaged(Entity e) {
        return this.preManagedEntitiesById.containsKey(e.getId());
    }

    private synchronized boolean preManageNonRecursive(Entity e, ManagementTransitionMode mode) {
        Entity realE = this.toRealEntity(e);
        Entity old = this.preManagedEntitiesById.put(e.getId(), realE);
        this.preRegisteredEntitiesById.remove(e.getId());
        if (old != null && mode.wasNotLoaded()) {
            if (!old.equals(e)) {
                throw new IllegalStateException("call to pre-manage entity " + e + " (" + mode + ") but different entity " + old + " already known under that id at " + this);
            }
            log.warn("{} redundant call to pre-start management of entity {}, mode {}; ignoring", new Object[]{this, e, mode});
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("{} pre-start management of entity {}, mode {}", new Object[]{this, e, mode});
        }
        return true;
    }

    private synchronized boolean manageNonRecursive(Entity e, ManagementTransitionMode mode) {
        Entity proxyE;
        Entity old = this.entitiesById.get(e.getId());
        if (old != null && mode.wasNotLoaded()) {
            if (!old.equals(e)) {
                throw new IllegalStateException("call to manage entity " + e + " (" + mode + ") but different entity " + old + " already known under that id at " + this);
            }
            log.warn("{} redundant call to start management of entity {}; ignoring", (Object)this, (Object)e);
            return false;
        }
        BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly(e), "{} starting management of entity {}", this, e);
        Entity realE = this.toRealEntity(e);
        Entity oldProxy = (Entity)this.entityProxiesById.get(e.getId());
        if (oldProxy != null) {
            if (mode.wasNotLoaded()) {
                throw new IllegalStateException("call to manage entity " + e + " from unloaded state (" + mode + ") but already had proxy " + oldProxy + " already known under that id at " + this);
            }
            ((EntityProxyImpl)Proxy.getInvocationHandler(oldProxy)).resetDelegate(oldProxy, oldProxy, realE);
            proxyE = oldProxy;
        } else {
            proxyE = this.toProxyEntityIfAvailable(e);
        }
        this.entityProxiesById.put(e.getId(), proxyE);
        this.entityTypes.put(e.getId(), realE.getClass().getName());
        this.entitiesById.put(e.getId(), realE);
        this.preManagedEntitiesById.remove(e.getId());
        if (e instanceof Application && e.getParent() == null) {
            this.applications.add((Application)proxyE);
            this.applicationIds.add(e.getId());
        }
        if (!this.entities.contains((Object)proxyE)) {
            this.entities.add((Object)proxyE);
        }
        if (old != null && old != e) {
            this.unmanage(old, mode, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unmanageNonRecursive(Entity e) {
        if (!this.getLastManagementTransitionMode(e.getId()).isReadOnly()) {
            e.clearParent();
            Collection groups = e.getGroups();
            for (Group group : groups) {
                if (Entities.isNoLongerManaged((Entity)group)) continue;
                group.removeMember(e);
            }
            if (e instanceof Group) {
                Collection members = ((Group)e).getMembers();
                for (Entity member : members) {
                    if (Entities.isNoLongerManaged(member)) continue;
                    member.removeGroup((Group)e);
                }
            }
        } else {
            log.debug("No relations being updated on unmanage of read only {}", (Object)e);
        }
        LocalEntityManager localEntityManager = this;
        synchronized (localEntityManager) {
            Entity proxyE = this.toProxyEntityIfAvailable(e);
            if (e instanceof Application) {
                this.applications.remove(proxyE);
                this.applicationIds.remove(e.getId());
            }
            this.entities.remove((Object)proxyE);
            this.entityProxiesById.remove(e.getId());
            this.entityModesById.remove(e.getId());
            Entity old = this.entitiesById.remove(e.getId());
            this.entityTypes.remove(e.getId());
            if (old == null) {
                log.warn("{} call to stop management of unknown entity (already unmanaged?) {}; ignoring", (Object)this, (Object)e);
                return false;
            }
            if (!old.equals(e)) {
                log.error("{} call to stop management of entity {} removed different entity {}", new Object[]{this, e, old});
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} stopped management of entity {}", (Object)this, (Object)e);
            }
            return true;
        }
    }

    void addEntitySetListener(CollectionChangeListener<Entity> listener) {
        AsyncCollectionChangeAdapter<Entity> wrappedListener = new AsyncCollectionChangeAdapter<Entity>(this.managementContext.getExecutionManager(), listener);
        this.entities.addPropertyChangeListener((PropertyChangeListener)new GroovyObservablesPropertyChangeToCollectionChangeAdapter(wrappedListener));
    }

    void removeEntitySetListener(CollectionChangeListener<Entity> listener) {
        AsyncCollectionChangeAdapter<Entity> wrappedListener = new AsyncCollectionChangeAdapter<Entity>(this.managementContext.getExecutionManager(), listener);
        this.entities.removePropertyChangeListener((PropertyChangeListener)new GroovyObservablesPropertyChangeToCollectionChangeAdapter(wrappedListener));
    }

    private boolean shouldSkipUnmanagement(Entity e) {
        if (e == null) {
            log.warn("" + this + " call to unmanage null entity; skipping", (Throwable)new IllegalStateException("source of null unmanagement call to " + this));
            return true;
        }
        if (!this.isManaged(e)) {
            log.warn("{} call to stop management of unknown entity (already unmanaged?) {}; skipping, and all descendants", (Object)this, (Object)e);
            return true;
        }
        return false;
    }

    private Entity toProxyEntityIfAvailable(Entity e) {
        Preconditions.checkNotNull((Object)e, (Object)"entity");
        if (e instanceof EntityProxy) {
            return e;
        }
        if (e instanceof AbstractEntity) {
            Entity result = ((AbstractEntity)e).getProxy();
            return result == null ? e : result;
        }
        return e;
    }

    private Entity toRealEntity(Entity e) {
        Preconditions.checkNotNull((Object)e, (Object)"entity");
        if (e instanceof AbstractEntity) {
            return e;
        }
        Entity result = this.toRealEntityOrNull(e.getId());
        if (result == null) {
            throw new IllegalStateException("No concrete entity known for entity " + e + " (" + e.getId() + ", " + e.getEntityType().getName() + ")");
        }
        return result;
    }

    public boolean isKnownEntityId(String id) {
        return this.entitiesById.containsKey(id) || this.preManagedEntitiesById.containsKey(id) || this.preRegisteredEntitiesById.containsKey(id);
    }

    private Entity toRealEntityOrNull(String id) {
        Entity result = this.preRegisteredEntitiesById.get(id);
        if (result == null) {
            result = this.preManagedEntitiesById.get(id);
        }
        if (result == null) {
            this.entitiesById.get(id);
        }
        return result;
    }

    private boolean isRunning() {
        return this.managementContext.isRunning();
    }
}

