/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.camp.brooklyn.api.AssemblyTemplateSpecInstantiator;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityFunctions;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.spi.Assembly;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagementUtils {
    private static final Logger log = LoggerFactory.getLogger(EntityManagementUtils.class);
    public static final ConfigKey<Boolean> WRAPPER_APP_MARKER = ConfigKeys.newBooleanConfigKey("brooklyn.wrapper_app");

    public static <T extends Application> T createUnstarted(ManagementContext mgmt, EntitySpec<T> spec) {
        Application app = (Application)mgmt.getEntityManager().createEntity(spec);
        Entities.startManagement(app, mgmt);
        return (T)app;
    }

    public static Maybe<CampPlatform> getCampPlatform(ManagementContext mgmt) {
        return BrooklynServerConfig.getCampPlatform(mgmt);
    }

    public static <T extends Application> T createUnstarted(ManagementContext mgmt, String yaml) {
        AssemblyTemplate at = ((CampPlatform)EntityManagementUtils.getCampPlatform(mgmt).get()).pdp().registerDeploymentPlan((Reader)new StringReader(yaml));
        return EntityManagementUtils.createUnstarted(mgmt, at);
    }

    public static <T extends Application> T createUnstarted(ManagementContext mgmt, AssemblyTemplate at) {
        AssemblyTemplateInstantiator instantiator;
        CampPlatform camp = (CampPlatform)EntityManagementUtils.getCampPlatform(mgmt).get();
        try {
            instantiator = (AssemblyTemplateInstantiator)at.getInstantiator().newInstance();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (instantiator instanceof AssemblyTemplateSpecInstantiator) {
            JavaBrooklynClassLoadingContext loader = JavaBrooklynClassLoadingContext.create(mgmt);
            EntitySpec<?> spec = ((AssemblyTemplateSpecInstantiator)instantiator).createSpec(at, camp, loader, true);
            Entity app = mgmt.getEntityManager().createEntity(spec);
            Entities.startManagement((Application)app, mgmt);
            return (T)((Application)app);
        }
        try {
            Assembly assembly = instantiator.instantiate(at, camp);
            return (T)((Application)mgmt.getEntityManager().getEntity(assembly.getId()));
        }
        catch (UnsupportedOperationException e) {
            if (at.getPlatformComponentTemplates() == null || at.getPlatformComponentTemplates().isEmpty()) {
                if (at.getCustomAttributes().containsKey("brooklyn.catalog")) {
                    throw new IllegalArgumentException("Unrecognized application blueprint format: expected an application, not a brooklyn.catalog");
                }
                throw new IllegalArgumentException("Unrecognized application blueprint format: no services defined");
            }
            throw new IllegalArgumentException("Unrecognized application blueprint format");
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalArgumentException("Invalid plan: " + at, e);
        }
    }

    public static <T extends Application> CreationResult<T, Void> createStarting(ManagementContext mgmt, EntitySpec<T> appSpec) {
        return EntityManagementUtils.start(EntityManagementUtils.createUnstarted(mgmt, appSpec));
    }

    public static CreationResult<? extends Application, Void> createStarting(ManagementContext mgmt, String appSpec) {
        return EntityManagementUtils.start(EntityManagementUtils.createUnstarted(mgmt, appSpec));
    }

    public static CreationResult<? extends Application, Void> createStarting(ManagementContext mgmt, AssemblyTemplate at) {
        return EntityManagementUtils.start(EntityManagementUtils.createUnstarted(mgmt, at));
    }

    public static <T extends Application> CreationResult<T, Void> start(T app) {
        Task<Void> task = Entities.invokeEffector((EntityLocal)app, app, Startable.START, MutableMap.of((Object)"locations", (Object)MutableList.of()));
        return CreationResult.of(app, task);
    }

    public static CreationResult<List<Entity>, List<String>> addChildren(EntityLocal parent, String yaml, Boolean start) {
        if (Boolean.FALSE.equals(start)) {
            return CreationResult.of(EntityManagementUtils.addChildrenUnstarted(parent, yaml), null);
        }
        return EntityManagementUtils.addChildrenStarting(parent, yaml);
    }

    public static List<Entity> addChildrenUnstarted(EntityLocal parent, String yaml) {
        AssemblyTemplateInstantiator instantiator;
        log.debug("Creating child of " + parent + " from yaml:\n{}", (Object)yaml);
        ManagementContext mgmt = parent.getApplication().getManagementContext();
        CampPlatform camp = (CampPlatform)BrooklynServerConfig.getCampPlatform(mgmt).get();
        AssemblyTemplate at = camp.pdp().registerDeploymentPlan((Reader)new StringReader(yaml));
        try {
            instantiator = (AssemblyTemplateInstantiator)at.getInstantiator().newInstance();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (instantiator instanceof AssemblyTemplateSpecInstantiator) {
            JavaBrooklynClassLoadingContext loader = JavaBrooklynClassLoadingContext.create(mgmt);
            EntitySpec<?> specA = ((AssemblyTemplateSpecInstantiator)instantiator).createSpec(at, camp, loader, false);
            MutableList specs = MutableList.of();
            if (EntityManagementUtils.hasNoNameOrCustomKeysOrRoot(at, specA)) {
                for (EntitySpec specC : specA.getChildren()) {
                    EntityManagementUtils.collapseSpec(specA, specC);
                    specs.add(specC);
                }
            } else {
                if (Strings.isEmpty((CharSequence)specA.getDisplayName())) {
                    int size = specA.getChildren().size();
                    String childrenCountString = size + " " + (size != 1 ? "children" : "child");
                    specA.displayName("Dynamically added " + childrenCountString);
                }
                specs.add(specA);
            }
            MutableList children = MutableList.of();
            for (EntitySpec spec : specs) {
                Entity child = parent.addChild(spec);
                Entities.manage(child);
                children.add(child);
            }
            return children;
        }
        throw new IllegalStateException("Spec could not be parsed to supply a compatible instantiator");
    }

    public static CreationResult<List<Entity>, List<String>> addChildrenStarting(EntityLocal parent, String yaml) {
        final List<Entity> children = EntityManagementUtils.addChildrenUnstarted(parent, yaml);
        int size = children.size();
        String childrenCountString = size + " " + (size != 1 ? "children" : "child");
        TaskBuilder<List<String>> taskM = Tasks.builder().name("add children").dynamic(true).tag("NON-TRANSIENT").body(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)children, EntityFunctions.id()));
            }
        }).description("Add and start " + childrenCountString);
        TaskBuilder taskS = Tasks.builder().parallel(true).name("add (parallel)").description("Start each new entity");
        for (Entity child : children) {
            if (child instanceof Startable) {
                taskS.add((TaskAdaptable<?>)Effectors.invocation(child, Startable.START, ImmutableMap.of((Object)"locations", (Object)ImmutableList.of())));
                continue;
            }
            taskS.add((TaskAdaptable<?>)Tasks.builder().name("create").description("Skipping start (not a Startable Entity)").body(new Runnable(){

                @Override
                public void run() {
                }
            }).tag(BrooklynTaskTags.tagForTargetEntity(child)).build());
        }
        taskM.add((TaskAdaptable<?>)taskS.build());
        Task<List<String>> task = Entities.submit((Entity)parent, taskM.build());
        return CreationResult.of(children, task);
    }

    @Beta
    public static void collapseSpec(EntitySpec<?> sourceToBeCollapsed, EntitySpec<?> targetToBeExpanded) {
        if (Strings.isEmpty((CharSequence)targetToBeExpanded.getDisplayName())) {
            targetToBeExpanded.displayName(sourceToBeCollapsed.getDisplayName());
        }
        if (!sourceToBeCollapsed.getLocations().isEmpty()) {
            targetToBeExpanded.locations((Iterable)sourceToBeCollapsed.getLocations());
        }
        targetToBeExpanded.configure(sourceToBeCollapsed.getConfig());
        targetToBeExpanded.configure(sourceToBeCollapsed.getFlags());
        targetToBeExpanded.tags((Iterable)sourceToBeCollapsed.getTags());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Beta
    public static boolean hasNoNameOrCustomKeysOrRoot(AssemblyTemplate template, EntitySpec<?> spec) {
        if (!Strings.isEmpty((CharSequence)template.getName())) {
            if (spec.getChildren().size() != 1) return false;
            String childName = ((EntitySpec)Iterables.getOnlyElement((Iterable)spec.getChildren())).getDisplayName();
            if (!Strings.isEmpty((CharSequence)childName) && !childName.equals(template.getName())) {
                return false;
            }
        } else if (spec.getChildren().size() > 1) {
            return false;
        }
        Set rootAttrs = template.getCustomAttributes().keySet();
        for (String rootAttr : rootAttrs) {
            if (rootAttr.equals("brooklyn.catalog") || rootAttr.equals("brooklyn.config") || !rootAttr.startsWith("brooklyn.")) continue;
            return false;
        }
        return true;
    }

    public static class CreationResult<T, U> {
        private final T thing;
        @Nullable
        private final Task<U> task;

        public CreationResult(T thing, Task<U> task) {
            this.thing = thing;
            this.task = task;
        }

        protected static <T, U> CreationResult<T, U> of(T thing, @Nullable Task<U> task) {
            return new CreationResult<T, U>(thing, task);
        }

        @Nullable
        public T get() {
            return this.thing;
        }

        public Task<U> task() {
            return this.task;
        }

        public CreationResult<T, U> blockUntilComplete(Duration timeout) {
            if (this.task != null) {
                this.task.blockUntilEnded(timeout);
            }
            return this;
        }

        public CreationResult<T, U> blockUntilComplete() {
            if (this.task != null) {
                this.task.blockUntilEnded();
            }
            return this;
        }
    }
}

