/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.ParameterType;
import brooklyn.entity.basic.BasicParameterType;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.management.Task;
import brooklyn.management.internal.EntityManagementSupport;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.PropagatedRuntimeException;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectorUtils {
    private static final Logger log = LoggerFactory.getLogger(EffectorUtils.class);

    public static Object[] prepareArgsForEffector(Effector<?> eff, Object args) {
        if (args != null && args.getClass().isArray()) {
            return EffectorUtils.prepareArgsForEffectorFromArray(eff, (Object[])args);
        }
        if (args instanceof Map) {
            return EffectorUtils.prepareArgsForEffectorFromMap(eff, (Map)args);
        }
        log.warn("Deprecated effector invocation style for call to " + eff + ", expecting a map or an array, got: " + args);
        if (log.isDebugEnabled()) {
            log.debug("Deprecated effector invocation style for call to " + eff + ", expecting a map or an array, got: " + args, new Throwable("Trace for deprecated effector invocation style"));
        }
        return EffectorUtils.oldPrepareArgsForEffector(eff, args);
    }

    private static Object[] prepareArgsForEffectorFromArray(Effector<?> eff, Object[] args) {
        int newArgsNeeded = eff.getParameters().size();
        if (args.length == 1 && args[0] instanceof Map && (newArgsNeeded != 1 || !((ParameterType)eff.getParameters().get(0)).getParameterClass().isAssignableFrom(args[0].getClass()))) {
            return EffectorUtils.prepareArgsForEffectorFromMap(eff, (Map)args[0]);
        }
        return EffectorUtils.prepareArgsForEffectorAsMapFromArray(eff, args).values().toArray(new Object[0]);
    }

    public static Map prepareArgsForEffectorAsMapFromArray(Effector<?> eff, Object[] args) {
        int newArgsNeeded = eff.getParameters().size();
        ArrayList l = Lists.newArrayList();
        l.addAll(Arrays.asList(args));
        LinkedHashMap<String, Object> newArgs = new LinkedHashMap<String, Object>();
        for (int index = 0; index < eff.getParameters().size(); ++index) {
            ParameterType it = (ParameterType)eff.getParameters().get(index);
            if (l.size() >= newArgsNeeded) {
                newArgs.put(it.getName(), l.remove(0));
            } else if (!l.isEmpty() && it.getParameterClass().isInstance(l.get(0))) {
                newArgs.put(it.getName(), l.remove(0));
            } else if (it instanceof BasicParameterType && ((BasicParameterType)it).hasDefaultValue()) {
                newArgs.put(it.getName(), ((BasicParameterType)it).getDefaultValue());
            } else {
                throw new IllegalArgumentException("Invalid arguments (count mismatch) for effector " + eff + ": " + args);
            }
            --newArgsNeeded;
        }
        if (newArgsNeeded > 0) {
            throw new IllegalArgumentException("Invalid arguments (missing " + newArgsNeeded + ") for effector " + eff + ": " + args);
        }
        if (!l.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments (" + l.size() + " extra) for effector " + eff + ": " + args);
        }
        return newArgs;
    }

    private static Object[] prepareArgsForEffectorFromMap(Effector<?> eff, Map m) {
        m = Maps.newLinkedHashMap((Map)m);
        ArrayList newArgs = Lists.newArrayList();
        int newArgsNeeded = eff.getParameters().size();
        for (int index = 0; index < eff.getParameters().size(); ++index) {
            Object v;
            ParameterType it = (ParameterType)eff.getParameters().get(index);
            if (GroovyJavaMethods.truth((Object)it.getName()) && m.containsKey(it.getName())) {
                v = m.remove(it.getName());
            } else if (it instanceof BasicParameterType && ((BasicParameterType)it).hasDefaultValue()) {
                v = ((BasicParameterType)it).getDefaultValue();
            } else {
                throw new IllegalArgumentException("Invalid arguments (missing argument " + it + ") for effector " + eff + ": " + m);
            }
            newArgs.add(TypeCoercions.coerce(v, it.getParameterClass()));
            --newArgsNeeded;
        }
        if (newArgsNeeded > 0) {
            throw new IllegalArgumentException("Invalid arguments (missing " + newArgsNeeded + ") for effector " + eff + ": " + m);
        }
        return newArgs.toArray(new Object[newArgs.size()]);
    }

    public static Object[] oldPrepareArgsForEffector(Effector<?> eff, Object args) {
        Object[] argsArray = args == null ? new Object[]{} : (args.getClass().isArray() ? (Object[])args : (args instanceof Collection ? ((Collection)args).toArray(new Object[((Collection)args).size()]) : new Object[]{args}));
        ArrayList l = Lists.newArrayList();
        l.addAll(Arrays.asList(argsArray));
        LinkedHashMap m = argsArray.length > 0 && argsArray[0] instanceof Map ? Maps.newLinkedHashMap((Map)((Map)l.remove(0))) : null;
        ArrayList newArgs = Lists.newArrayList();
        int newArgsNeeded = eff.getParameters().size();
        boolean mapUsed = false;
        for (int index = 0; index < eff.getParameters().size(); ++index) {
            ParameterType it = (ParameterType)eff.getParameters().get(index);
            if (l.size() >= newArgsNeeded) {
                newArgs.add(l.remove(0));
            } else if (GroovyJavaMethods.truth((Object)m) && GroovyJavaMethods.truth((Object)it.getName()) && m.containsKey(it.getName())) {
                newArgs.add(m.remove(it.getName()));
            } else if (index == 0 && Map.class.isAssignableFrom(it.getParameterClass())) {
                newArgs.add(m);
                mapUsed = true;
            } else if (!l.isEmpty() && it.getParameterClass().isInstance(l.get(0))) {
                newArgs.add(l.remove(0));
            } else if (it instanceof BasicParameterType && ((BasicParameterType)it).hasDefaultValue()) {
                newArgs.add(((BasicParameterType)it).getDefaultValue());
            } else {
                throw new IllegalArgumentException("Invalid arguments (count mismatch) for effector " + eff + ": " + args);
            }
            --newArgsNeeded;
        }
        if (newArgsNeeded > 0) {
            throw new IllegalArgumentException("Invalid arguments (missing " + newArgsNeeded + ") for effector " + eff + ": " + args);
        }
        if (!l.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments (" + l.size() + " extra) for effector " + eff + ": " + args);
        }
        if (GroovyJavaMethods.truth((Object)m) && !mapUsed) {
            throw new IllegalArgumentException("Invalid arguments (" + m.size() + " extra named) for effector " + eff + ": " + args);
        }
        return newArgs.toArray(new Object[newArgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T invokeMethodEffector(Entity entity, Effector<T> eff, Object[] args) {
        String name = eff.getName();
        try {
            EntityManagementSupport mgmtSupport;
            if (log.isDebugEnabled()) {
                log.debug("Invoking effector {} on {}", new Object[]{name, entity});
            }
            if (log.isTraceEnabled()) {
                log.trace("Invoking effector {} on {} with args {}", new Object[]{name, entity, args});
            }
            if (!(mgmtSupport = ((EntityInternal)entity).getManagementSupport()).isDeployed()) {
                mgmtSupport.attemptLegacyAutodeployment(name);
            }
            ManagementContextInternal mgmtContext = (ManagementContextInternal)((EntityInternal)entity).getManagementContext();
            mgmtSupport.getEntityChangeListener().onEffectorStarting(eff, args);
            try {
                T t = mgmtContext.invokeEffectorMethodSync(entity, eff, args);
                return t;
            }
            finally {
                mgmtSupport.getEntityChangeListener().onEffectorCompleted(eff);
            }
        }
        catch (Exception e) {
            EffectorUtils.handleEffectorException(entity, eff, e);
            return null;
        }
    }

    public static void handleEffectorException(Entity entity, Effector<?> effector, Throwable throwable) {
        String message = "Error invoking " + effector.getName() + " at " + entity;
        if (throwable instanceof PropagatedRuntimeException && throwable.getMessage() != null && throwable.getMessage().startsWith(message)) {
            throw (PropagatedRuntimeException)PropagatedRuntimeException.class.cast(throwable);
        }
        log.warn(message + ": " + Exceptions.collapseText((Throwable)throwable));
        throw new PropagatedRuntimeException(message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Task<T> invokeEffectorAsync(Entity entity, Effector<T> eff, Map<String, ?> parameters) {
        EntityManagementSupport mgmtSupport;
        String name = eff.getName();
        if (log.isDebugEnabled()) {
            log.debug("Invoking-async effector {} on {}", new Object[]{name, entity});
        }
        if (log.isTraceEnabled()) {
            log.trace("Invoking-async effector {} on {} with args {}", new Object[]{name, entity, parameters});
        }
        if (!(mgmtSupport = ((EntityInternal)entity).getManagementSupport()).isDeployed()) {
            mgmtSupport.attemptLegacyAutodeployment(name);
        }
        ManagementContextInternal mgmtContext = (ManagementContextInternal)((EntityInternal)entity).getManagementContext();
        mgmtSupport.getEntityChangeListener().onEffectorStarting(eff, parameters);
        try {
            Task<T> task = mgmtContext.invokeEffector(entity, eff, parameters);
            return task;
        }
        finally {
            mgmtSupport.getEntityChangeListener().onEffectorCompleted(eff);
        }
    }

    @Deprecated
    public static Effector<?> findEffectorMatching(Entity entity, Method method) {
        block0: for (Effector effector : entity.getEntityType().getEffectors()) {
            if (!effector.getName().equals(entity) || effector.getParameters().size() != method.getParameterTypes().length) continue;
            for (int i = 0; i < effector.getParameters().size(); ++i) {
                if (((ParameterType)effector.getParameters().get(i)).getParameterClass() != method.getParameterTypes()[i]) continue block0;
            }
            return effector;
        }
        return null;
    }

    @Deprecated
    public static Effector<?> findEffectorMatching(Set<Effector<?>> effectors, String effectorName, Map<String, ?> parameters) {
        for (Effector<?> effector : effectors) {
            if (!effector.getName().equals(effectorName)) continue;
            return effector;
        }
        return null;
    }

    public static Maybe<Effector<?>> findEffector(Collection<? extends Effector<?>> effectors, String effectorName) {
        for (Effector<?> effector : effectors) {
            if (!effector.getName().equals(effectorName)) continue;
            return Maybe.of(effector);
        }
        return Maybe.absent((Throwable)new NoSuchElementException("No effector with name " + effectorName + " (contenders " + effectors + ")"));
    }

    public static Maybe<Effector<?>> findEffectorDeclared(Entity entity, String effectorName) {
        return EffectorUtils.findEffector(entity.getEntityType().getEffectors(), effectorName);
    }

    public static Map<Object, Object> getTaskFlagsForEffectorInvocation(Entity entity, Effector<?> effector) {
        return EffectorUtils.getTaskFlagsForEffectorInvocation(entity, effector, null);
    }

    public static Map<Object, Object> getTaskFlagsForEffectorInvocation(Entity entity, Effector<?> effector, ConfigBag parameters) {
        return MutableMap.builder().put((Object)"description", (Object)("Invoking effector " + effector.getName() + " on " + entity.getDisplayName() + (parameters != null ? " with parameters " + parameters.getAllConfig() : ""))).put((Object)"displayName", (Object)effector.getName()).put((Object)"tags", (Object)MutableList.of((Object)"EFFECTOR", (Object)BrooklynTaskTags.tagForEffectorCall(entity, effector.getName(), parameters), (Object[])new Object[]{BrooklynTaskTags.tagForTargetEntity(entity)})).build();
    }
}

