/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.management.SubscriptionContext;
import brooklyn.management.SubscriptionHandle;
import brooklyn.management.SubscriptionManager;
import brooklyn.management.internal.Subscription;
import brooklyn.util.JavaGroovyEquivalents;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSubscriptionContext
implements SubscriptionContext {
    private static final Logger LOG = LoggerFactory.getLogger(BasicSubscriptionContext.class);
    private final SubscriptionManager manager;
    private final Object subscriber;
    private final Map<String, Object> flags;

    public BasicSubscriptionContext(SubscriptionManager manager, Object subscriber) {
        this(Collections.emptyMap(), manager, subscriber);
    }

    public BasicSubscriptionContext(Map<String, ?> flags, SubscriptionManager manager, Object subscriber) {
        this.manager = manager;
        this.subscriber = subscriber;
        this.flags = JavaGroovyEquivalents.mapOf((Object)"subscriber", (Object)subscriber);
        if (flags != null) {
            this.flags.putAll(flags);
        }
    }

    public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, Closure c) {
        return this.subscribe(Collections.<String, Object>emptyMap(), producer, sensor, c);
    }

    public <T> SubscriptionHandle subscribe(Map<String, Object> newFlags, Entity producer, Sensor<T> sensor, Closure c) {
        return this.subscribe(newFlags, producer, sensor, this.toSensorEventListener(c));
    }

    public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribe(Collections.<String, Object>emptyMap(), producer, sensor, listener);
    }

    public <T> SubscriptionHandle subscribe(Map<String, Object> newFlags, Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        LinkedHashMap subscriptionFlags = Maps.newLinkedHashMap(this.flags);
        if (newFlags != null) {
            subscriptionFlags.putAll(newFlags);
        }
        return this.manager.subscribe((Map)subscriptionFlags, producer, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, Closure c) {
        return this.subscribeToChildren(Collections.<String, Object>emptyMap(), parent, sensor, c);
    }

    public <T> SubscriptionHandle subscribeToChildren(Map<String, Object> newFlags, Entity parent, Sensor<T> sensor, Closure c) {
        return this.subscribeToChildren(newFlags, parent, sensor, this.toSensorEventListener(c));
    }

    public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribeToChildren(Collections.<String, Object>emptyMap(), parent, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToChildren(Map<String, Object> newFlags, Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        LinkedHashMap subscriptionFlags = Maps.newLinkedHashMap(this.flags);
        if (newFlags != null) {
            subscriptionFlags.putAll(newFlags);
        }
        return this.manager.subscribeToChildren((Map)subscriptionFlags, parent, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToMembers(Group parent, Sensor<T> sensor, Closure c) {
        return this.subscribeToMembers(Collections.<String, Object>emptyMap(), parent, sensor, c);
    }

    public <T> SubscriptionHandle subscribeToMembers(Map<String, Object> newFlags, Group parent, Sensor<T> sensor, Closure c) {
        return this.subscribeToMembers(newFlags, parent, sensor, this.toSensorEventListener(c));
    }

    public <T> SubscriptionHandle subscribeToMembers(Group parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribeToMembers(Collections.<String, Object>emptyMap(), parent, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToMembers(Map<String, Object> newFlags, Group parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        LinkedHashMap subscriptionFlags = Maps.newLinkedHashMap(this.flags);
        if (newFlags != null) {
            subscriptionFlags.putAll(newFlags);
        }
        return this.manager.subscribeToMembers((Map)subscriptionFlags, parent, sensor, listener);
    }

    public boolean unsubscribe(SubscriptionHandle subscriptionId) {
        Preconditions.checkNotNull((Object)subscriptionId, (Object)"subscriptionId must not be null");
        Preconditions.checkArgument((boolean)Objects.equal((Object)this.subscriber, (Object)((Subscription)subscriptionId).subscriber), (Object)("The subscriptionId is for a different " + this.subscriber + "; expected " + ((Subscription)subscriptionId).subscriber));
        return this.manager.unsubscribe(subscriptionId);
    }

    public <T> void publish(SensorEvent<T> event) {
        this.manager.publish(event);
    }

    public Set<SubscriptionHandle> getSubscriptions() {
        return this.manager.getSubscriptionsForSubscriber(this.subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unsubscribeAll() {
        ImmutableList subscriptionsCopy;
        Set<SubscriptionHandle> subscriptions;
        int count = 0;
        Set<SubscriptionHandle> set = subscriptions = this.getSubscriptions();
        synchronized (set) {
            subscriptionsCopy = ImmutableList.copyOf(subscriptions);
        }
        for (SubscriptionHandle s : subscriptionsCopy) {
            ++count;
            boolean result = this.unsubscribe(s);
            if (result) continue;
            LOG.warn("When unsubscribing from all of {}, unsubscribe of {} return false", this.subscriber, (Object)s);
        }
        return count;
    }

    private <T> SensorEventListener<T> toSensorEventListener(final Closure c) {
        return new SensorEventListener<T>(){

            public void onEvent(SensorEvent<T> event) {
                c.call(event);
            }
        };
    }
}

