/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.management.ExecutionManager;
import brooklyn.management.internal.CollectionChangeListener;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.BasicExecutionManager;
import brooklyn.util.task.SingleThreadedScheduler;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCollectionChangeAdapter<Item>
implements CollectionChangeListener<Item> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncCollectionChangeAdapter.class);
    private final ExecutionManager executor;
    private final CollectionChangeListener<Item> delegate;

    public AsyncCollectionChangeAdapter(ExecutionManager executor, CollectionChangeListener<Item> delegate) {
        this.executor = (ExecutionManager)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.delegate = (CollectionChangeListener)Preconditions.checkNotNull(delegate, (Object)"delegate");
        ((BasicExecutionManager)executor).setTaskSchedulerForTag(delegate, SingleThreadedScheduler.class);
    }

    @Override
    public void onItemAdded(final Item item) {
        this.executor.submit((Map)MutableMap.of((Object)"tag", this.delegate), new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncCollectionChangeAdapter.this.delegate.onItemAdded(item);
                }
                catch (Throwable t) {
                    LOG.warn("Error notifying listener of itemAdded(" + item + ")", t);
                    Exceptions.propagate((Throwable)t);
                }
            }
        });
    }

    @Override
    public void onItemRemoved(final Item item) {
        this.executor.submit((Map)MutableMap.of((Object)"tag", this.delegate), new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncCollectionChangeAdapter.this.delegate.onItemRemoved(item);
                }
                catch (Throwable t) {
                    LOG.warn("Error notifying listener of itemAdded(" + item + ")", t);
                    Exceptions.propagate((Throwable)t);
                }
            }
        });
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof AsyncCollectionChangeAdapter && this.delegate.equals(((AsyncCollectionChangeAdapter)other).delegate);
    }
}

