/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.internal;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.BasicBrooklynCatalog;
import brooklyn.catalog.internal.CatalogInitialization;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.config.BrooklynProperties;
import brooklyn.config.StringConfigMap;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.drivers.BasicEntityDriverManager;
import brooklyn.entity.drivers.EntityDriverManager;
import brooklyn.entity.drivers.downloads.BasicDownloadsManager;
import brooklyn.entity.drivers.downloads.DownloadResolverManager;
import brooklyn.entity.rebind.RebindManager;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.internal.storage.BrooklynStorage;
import brooklyn.internal.storage.DataGrid;
import brooklyn.internal.storage.DataGridFactory;
import brooklyn.internal.storage.impl.BrooklynStorageImpl;
import brooklyn.internal.storage.impl.inmemory.InMemoryDataGridFactory;
import brooklyn.location.LocationRegistry;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.management.ExecutionContext;
import brooklyn.management.ManagementContext;
import brooklyn.management.SubscriptionContext;
import brooklyn.management.Task;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.ha.HighAvailabilityManager;
import brooklyn.management.ha.HighAvailabilityManagerImpl;
import brooklyn.management.internal.BasicSubscriptionContext;
import brooklyn.management.internal.BrooklynGarbageCollector;
import brooklyn.management.internal.CollectionChangeListener;
import brooklyn.management.internal.EffectorUtils;
import brooklyn.management.internal.EntityManagementSupport;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.BasicExecutionContext;
import brooklyn.util.task.Tasks;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagementContext
implements ManagementContextInternal {
    private static final Logger log = LoggerFactory.getLogger(AbstractManagementContext.class);
    private final AtomicLong totalEffectorInvocationCount = new AtomicLong();
    protected BrooklynProperties configMap;
    protected BasicLocationRegistry locationRegistry;
    protected final BasicBrooklynCatalog catalog;
    protected ClassLoader baseClassLoader;
    protected Iterable<URL> baseClassPathForScanning;
    private final RebindManager rebindManager;
    private final HighAvailabilityManager highAvailabilityManager;
    protected volatile BrooklynGarbageCollector gc;
    private final EntityDriverManager entityDriverManager;
    protected DownloadResolverManager downloadsManager;
    protected EntitlementManager entitlementManager;
    private final BrooklynStorage storage;
    private volatile boolean running = true;
    protected boolean startupComplete = false;
    protected final List<Throwable> errors = Collections.synchronizedList(MutableList.of());
    protected Maybe<URI> uri = Maybe.absent();
    protected CatalogInitialization catalogInitialization;
    private Object catalogInitMutex = new Object();

    private static DataGridFactory loadDataGridFactory(BrooklynProperties properties) {
        Object instance;
        Class<?> clazz;
        String clazzName = properties.getFirst(DataGridFactory.class.getName());
        if (clazzName == null) {
            clazzName = InMemoryDataGridFactory.class.getName();
        }
        try {
            clazz = LocalManagementContext.class.getClassLoader().loadClass(clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Could not load class [%s]", clazzName), e);
        }
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(String.format("Could not instantiate class [%s]", clazzName), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Could not instantiate class [%s]", clazzName), e);
        }
        if (!(instance instanceof DataGridFactory)) {
            throw new IllegalStateException(String.format("Class [%s] not an instantiate of class [%s]", clazzName, DataGridFactory.class.getName()));
        }
        return (DataGridFactory)instance;
    }

    public AbstractManagementContext(BrooklynProperties brooklynProperties) {
        this(brooklynProperties, null);
    }

    public AbstractManagementContext(BrooklynProperties brooklynProperties, DataGridFactory datagridFactory) {
        this.configMap = brooklynProperties;
        this.entityDriverManager = new BasicEntityDriverManager();
        this.downloadsManager = BasicDownloadsManager.newDefault(this.configMap);
        if (datagridFactory == null) {
            datagridFactory = AbstractManagementContext.loadDataGridFactory(brooklynProperties);
        }
        DataGrid datagrid = datagridFactory.newDataGrid(this);
        this.catalog = new BasicBrooklynCatalog(this);
        this.storage = new BrooklynStorageImpl(datagrid);
        this.rebindManager = new RebindManagerImpl(this);
        this.highAvailabilityManager = new HighAvailabilityManagerImpl(this);
        this.entitlementManager = Entitlements.newManager(this, brooklynProperties);
    }

    @Override
    public void terminate() {
        this.highAvailabilityManager.stop();
        this.running = false;
        this.rebindManager.stop();
        this.storage.terminate();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStartupComplete() {
        return this.startupComplete;
    }

    @Override
    public BrooklynStorage getStorage() {
        return this.storage;
    }

    public RebindManager getRebindManager() {
        return this.rebindManager;
    }

    public HighAvailabilityManager getHighAvailabilityManager() {
        return this.highAvailabilityManager;
    }

    @Override
    public long getTotalEffectorInvocations() {
        return this.totalEffectorInvocationCount.get();
    }

    public ExecutionContext getExecutionContext(Entity e) {
        if (e instanceof AbstractEntity) {
            return new BasicExecutionContext((Map<?, ?>)MutableMap.of((Object)"tag", (Object)BrooklynTaskTags.tagForContextEntity(e)), this.getExecutionManager());
        }
        return ((EntityInternal)e).getManagementSupport().getExecutionContext();
    }

    public ExecutionContext getServerExecutionContext() {
        return new BasicExecutionContext((Map<?, ?>)MutableMap.of((Object)"tag", (Object)"BROOKLYN-SERVER"), this.getExecutionManager());
    }

    public SubscriptionContext getSubscriptionContext(Entity e) {
        return new BasicSubscriptionContext(this.getSubscriptionManager(), e);
    }

    public EntityDriverManager getEntityDriverManager() {
        return this.entityDriverManager;
    }

    public DownloadResolverManager getEntityDownloadsManager() {
        return this.downloadsManager;
    }

    public EntitlementManager getEntitlementManager() {
        return this.entitlementManager;
    }

    protected abstract void manageIfNecessary(Entity var1, Object var2);

    @Override
    public <T> Task<T> invokeEffector(Entity entity, Effector<T> eff, Map parameters) {
        return this.runAtEntity(entity, eff, parameters);
    }

    protected <T> T invokeEffectorMethodLocal(Entity entity, Effector<T> eff, Object args) {
        assert (this.isManagedLocally(entity)) : "cannot invoke effector method at " + this + " because it is not managed here";
        this.totalEffectorInvocationCount.incrementAndGet();
        Object[] transformedArgs = EffectorUtils.prepareArgsForEffector(eff, args);
        return (T)GroovyJavaMethods.invokeMethodOnMetaClass((Object)entity, (String)eff.getName(), (Object)transformedArgs);
    }

    @Override
    public <T> T invokeEffectorMethodSync(final Entity entity, final Effector<T> eff, final Object args) throws ExecutionException {
        try {
            Task current = Tasks.current();
            if (current == null || !entity.equals(BrooklynTaskTags.getContextEntity(current)) || !this.isManagedLocally(entity)) {
                this.manageIfNecessary(entity, eff.getName());
                Task<T> task = this.runAtEntity(EffectorUtils.getTaskFlagsForEffectorInvocation(entity, eff, ConfigBag.newInstance().configureStringKey("args", args)), entity, new Callable<T>(){

                    @Override
                    public T call() {
                        return AbstractManagementContext.this.invokeEffectorMethodLocal(entity, eff, args);
                    }
                });
                return (T)task.get();
            }
            return this.invokeEffectorMethodLocal(entity, eff, args);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public abstract boolean isManagedLocally(Entity var1);

    @Deprecated
    public abstract <T> Task<T> runAtEntity(Map var1, Entity var2, Callable<T> var3);

    protected abstract <T> Task<T> runAtEntity(Entity var1, Effector<T> var2, Map var3);

    @Override
    public abstract void addEntitySetListener(CollectionChangeListener<Entity> var1);

    @Override
    public abstract void removeEntitySetListener(CollectionChangeListener<Entity> var1);

    public StringConfigMap getConfig() {
        return this.configMap;
    }

    @Override
    public BrooklynProperties getBrooklynProperties() {
        return this.configMap;
    }

    public synchronized LocationRegistry getLocationRegistry() {
        if (this.locationRegistry == null) {
            this.locationRegistry = new BasicLocationRegistry(this);
        }
        return this.locationRegistry;
    }

    public BrooklynCatalog getCatalog() {
        if (!this.getCatalogInitialization().hasRunAnyInitialization()) {
            this.getCatalogInitialization().injectManagementContext(this);
            this.getCatalogInitialization().populateUnofficial(this.catalog);
        }
        return this.catalog;
    }

    public ClassLoader getCatalogClassLoader() {
        return this.catalog.getRootClassLoader();
    }

    @Override
    public ClassLoader getBaseClassLoader() {
        return this.baseClassLoader;
    }

    public void setBaseClassLoader(ClassLoader cl) {
        if (this.baseClassLoader == cl) {
            return;
        }
        if (this.baseClassLoader != null) {
            throw new IllegalStateException("Cannot change base class loader (in " + this + ")");
        }
        if (this.catalog != null) {
            throw new IllegalStateException("Cannot set base class after catalog has been loaded (in " + this + ")");
        }
        this.baseClassLoader = cl;
    }

    @Override
    public void setBaseClassPathForScanning(Iterable<URL> urls) {
        if (Objects.equal(this.baseClassPathForScanning, urls)) {
            return;
        }
        if (this.baseClassPathForScanning != null) {
            if (this.catalog == null) {
                log.warn("Changing scan classpath to " + urls + " from " + this.baseClassPathForScanning);
            } else {
                throw new IllegalStateException("Cannot change base class path for scanning (in " + this + ")");
            }
        }
        this.baseClassPathForScanning = urls;
    }

    @Override
    public Iterable<URL> getBaseClassPathForScanning() {
        return this.baseClassPathForScanning;
    }

    public BrooklynGarbageCollector getGarbageCollector() {
        return this.gc;
    }

    @Override
    public void setManagementNodeUri(URI uri) {
        this.uri = Maybe.of((Object)Preconditions.checkNotNull((Object)uri, (Object)"uri"));
    }

    public Maybe<URI> getManagementNodeUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CatalogInitialization getCatalogInitialization() {
        Object object = this.catalogInitMutex;
        synchronized (object) {
            if (this.catalogInitialization != null) {
                return this.catalogInitialization;
            }
            CatalogInitialization ci = new CatalogInitialization();
            this.setCatalogInitialization(ci);
            return ci;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalogInitialization(CatalogInitialization catalogInitialization) {
        Object object = this.catalogInitMutex;
        synchronized (object) {
            Preconditions.checkNotNull((Object)catalogInitialization, (Object)"initialization must not be null");
            if (this.catalogInitialization != null && this.catalogInitialization != catalogInitialization) {
                throw new IllegalStateException("Changing catalog init from " + this.catalogInitialization + " to " + catalogInitialization + "; changes not permitted");
            }
            catalogInitialization.injectManagementContext(this);
            this.catalogInitialization = catalogInitialization;
        }
    }

    public BrooklynObject lookup(String id) {
        return this.lookup(id, BrooklynObject.class);
    }

    public <T extends BrooklynObject> T lookup(String id, Class<T> type) {
        Entity result = this.getEntityManager().getEntity(id);
        if (result != null && type.isInstance(result)) {
            return (T)((BrooklynObject)result);
        }
        result = this.getLocationManager().getLocation(id);
        if (result != null && type.isInstance(result)) {
            return (T)((BrooklynObject)result);
        }
        return null;
    }

    @Override
    public List<Throwable> errors() {
        return this.errors;
    }

    static {
        ResourceUtils.addClassLoaderProvider(new Function<Object, BrooklynClassLoadingContext>(){

            public BrooklynClassLoadingContext apply(@Nullable Object input) {
                if (input instanceof EntityInternal) {
                    EntityInternal internal = (EntityInternal)input;
                    if (internal.getCatalogItemId() != null) {
                        CatalogItem<?, ?> item = CatalogUtils.getCatalogItemOptionalVersion(internal.getManagementContext(), internal.getCatalogItemId());
                        if (item != null) {
                            return CatalogUtils.newClassLoadingContext(internal.getManagementContext(), item);
                        }
                        log.error("Can't find catalog item " + internal.getCatalogItemId() + " used for instantiating entity " + internal + ". Falling back to application classpath.");
                    }
                    return this.apply(internal.getManagementSupport());
                }
                if (input instanceof EntityManagementSupport) {
                    return this.apply(((EntityManagementSupport)input).getManagementContext());
                }
                if (input instanceof ManagementContext) {
                    return JavaBrooklynClassLoadingContext.create((ManagementContext)input);
                }
                return null;
            }
        });
    }
}

