/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.ha;

import brooklyn.BrooklynVersion;
import brooklyn.catalog.CatalogItem;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.BrooklynServerPaths;
import brooklyn.config.ConfigKey;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.os.Os;
import brooklyn.util.osgi.Osgis;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.collect.Iterables;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiManager {
    private static final Logger log = LoggerFactory.getLogger(OsgiManager.class);
    public static final ConfigKey<Boolean> USE_OSGI = BrooklynServerConfig.USE_OSGI;
    protected ManagementContext mgmt;
    protected Framework framework;
    protected File osgiCacheDir;

    public OsgiManager(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public void start() {
        try {
            this.osgiCacheDir = BrooklynServerPaths.getOsgiCacheDirCleanedIfNeeded(this.mgmt);
            this.framework = Osgis.newFrameworkStarted(this.osgiCacheDir.getAbsolutePath(), false, MutableMap.of());
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void stop() {
        try {
            if (this.framework != null) {
                this.framework.stop();
                this.framework.waitForStop(0L);
            }
        }
        catch (BundleException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (BrooklynServerPaths.isOsgiCacheForCleaning(this.mgmt, this.osgiCacheDir)) {
            final AtomicReference deletionResult = new AtomicReference();
            Repeater.create((String)"Delete OSGi cache dir").until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    deletionResult.set(Os.deleteRecursively((File)OsgiManager.this.osgiCacheDir));
                    return ((Os.DeletionResult)deletionResult.get()).wasSuccessful();
                }
            }).limitTimeTo(Duration.ONE_SECOND).backoffTo(Duration.millis((Number)50)).run();
            if (((Os.DeletionResult)deletionResult.get()).getThrowable() != null) {
                log.debug("Unable to delete " + this.osgiCacheDir + " (possibly being modified concurrently?): " + ((Os.DeletionResult)deletionResult.get()).getThrowable());
            }
        }
        this.osgiCacheDir = null;
        this.framework = null;
    }

    public synchronized void registerBundle(CatalogItem.CatalogBundle bundle) {
        try {
            if (this.checkBundleInstalledThrowIfInconsistent(bundle)) {
                return;
            }
            Bundle b = Osgis.install(this.framework, bundle.getUrl());
            this.checkCorrectlyInstalled(bundle, b);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Bundle from " + bundle.getUrl() + " failed to install: " + e.getMessage(), e);
        }
    }

    private void checkCorrectlyInstalled(CatalogItem.CatalogBundle bundle, Bundle b) {
        String nv = b.getSymbolicName() + ":" + b.getVersion().toString();
        if (!OsgiManager.isBundleNameEqualOrAbsent(bundle, b)) {
            throw new IllegalStateException("Bundle already installed as " + nv + " but user explicitly requested " + bundle);
        }
        List<Bundle> matches = Osgis.bundleFinder(this.framework).symbolicName(b.getSymbolicName()).version(b.getVersion().toString()).findAll();
        if (matches.isEmpty()) {
            log.error("OSGi could not find bundle " + nv + " in search after installing it from " + bundle.getUrl());
        } else if (matches.size() == 1) {
            log.debug("Bundle from " + bundle.getUrl() + " successfully installed as " + nv + " (" + b + ")");
        } else {
            log.warn("OSGi has multiple bundles matching " + nv + ", when just installed from " + bundle.getUrl() + ": " + matches + "; " + "brooklyn will prefer the URL-based bundle for top-level references but any dependencies or " + "import-packages will be at the mercy of OSGi. " + "It is recommended to use distinct versions for different bundles, and the same URL for the same bundles.");
        }
    }

    private boolean checkBundleInstalledThrowIfInconsistent(CatalogItem.CatalogBundle bundle) {
        String bundleUrl = bundle.getUrl();
        if (bundleUrl != null) {
            Maybe<Bundle> installedBundle = Osgis.bundleFinder(this.framework).requiringFromUrl(bundleUrl).find();
            if (installedBundle.isPresent()) {
                Bundle b = (Bundle)installedBundle.get();
                String nv = b.getSymbolicName() + ":" + b.getVersion().toString();
                if (!OsgiManager.isBundleNameEqualOrAbsent(bundle, b)) {
                    throw new IllegalStateException("User requested bundle " + bundle + " but already installed as " + nv);
                }
                log.trace("Bundle from " + bundleUrl + " already installed as " + nv + "; not re-registering");
                return true;
            }
        } else {
            Maybe<Bundle> installedBundle = Osgis.bundleFinder(this.framework).symbolicName(bundle.getSymbolicName()).version(bundle.getVersion()).find();
            if (!installedBundle.isPresent()) {
                throw new IllegalStateException("Bundle " + bundle + " not previously registered, but URL is empty.");
            }
            log.trace("Bundle " + bundle + " installed from " + ((Bundle)installedBundle.get()).getLocation());
            return true;
        }
        return false;
    }

    public static boolean isBundleNameEqualOrAbsent(CatalogItem.CatalogBundle bundle, Bundle b) {
        return !bundle.isNamed() || bundle.getSymbolicName().equals(b.getSymbolicName()) && bundle.getVersion().equals(b.getVersion().toString());
    }

    public <T> Maybe<Class<T>> tryResolveClass(String type, CatalogItem.CatalogBundle ... catalogBundles) {
        return this.tryResolveClass(type, Arrays.asList(catalogBundles));
    }

    public <T> Maybe<Class<T>> tryResolveClass(String type, Iterable<CatalogItem.CatalogBundle> catalogBundles) {
        MutableMap bundleProblems = MutableMap.of();
        MutableSet extraMessages = MutableSet.of();
        for (CatalogItem.CatalogBundle catalogBundle : catalogBundles) {
            try {
                Maybe<Bundle> bundle = this.findBundle(catalogBundle);
                if (bundle.isPresent()) {
                    Class c;
                    Bundle b = (Bundle)bundle.get();
                    Class clazz = Osgis.isExtensionBundle(b) ? (c = Class.forName(type)) : (c = b.loadClass(type));
                    return Maybe.of((Object)clazz);
                }
                bundleProblems.put(catalogBundle, ((Maybe.Absent)bundle).getException());
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                bundleProblems.put(catalogBundle, e);
                Throwable cause = e.getCause();
                if (cause == null || !cause.getMessage().contains("Unresolved constraint in bundle")) continue;
                if (BrooklynVersion.INSTANCE.getVersionFromOsgiManifest() == null) {
                    extraMessages.add("No brooklyn-core OSGi manifest available. OSGi will not work.");
                }
                if (BrooklynVersion.isDevelopmentEnvironment()) {
                    extraMessages.add("Your development environment may not have created necessary files. Doing a maven build then retrying may fix the issue.");
                }
                if (!extraMessages.isEmpty()) {
                    log.warn(Strings.join((Iterable)extraMessages, (String)" "));
                }
                log.warn("Unresolved constraint resolving OSGi bundle " + catalogBundle + " to load " + type + ": " + cause.getMessage());
                if (!log.isDebugEnabled()) continue;
                log.debug("Trace for OSGi resolution failure", (Throwable)e);
            }
        }
        if (bundleProblems.size() == 1) {
            Throwable error = (Throwable)Iterables.getOnlyElement(bundleProblems.values());
            if (error instanceof ClassNotFoundException && error.getCause() != null && error.getCause().getMessage() != null) {
                error = Exceptions.collapseIncludingAllCausalMessages((Throwable)error);
            }
            return Maybe.absent((String)("Unable to resolve class " + type + " in " + Iterables.getOnlyElement(bundleProblems.keySet()) + (extraMessages.isEmpty() ? "" : " (" + Strings.join((Iterable)extraMessages, (String)" ") + ")")), (Throwable)error);
        }
        return Maybe.absent((Throwable)Exceptions.create((String)("Unable to resolve class " + type + ": " + bundleProblems + (extraMessages.isEmpty() ? "" : " (" + Strings.join((Iterable)extraMessages, (String)" ") + ")")), bundleProblems.values()));
    }

    public Maybe<Bundle> findBundle(CatalogItem.CatalogBundle catalogBundle) {
        Osgis.BundleFinder bundleFinder = Osgis.bundleFinder(this.framework);
        if (catalogBundle.getUrl() != null) {
            bundleFinder.requiringFromUrl(catalogBundle.getUrl());
        } else {
            bundleFinder.symbolicName(catalogBundle.getSymbolicName()).version(catalogBundle.getVersion());
        }
        return bundleFinder.find();
    }

    public URL getResource(String name, Iterable<CatalogItem.CatalogBundle> catalogBundles) {
        for (CatalogItem.CatalogBundle catalogBundle : catalogBundles) {
            try {
                URL result;
                Maybe<Bundle> bundle = this.findBundle(catalogBundle);
                if (!bundle.isPresent() || (result = ((Bundle)bundle.get()).getResource(name)) == null) continue;
                return result;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
        }
        return null;
    }

    public Framework getFramework() {
        return this.framework;
    }
}

