/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.ha;

import brooklyn.entity.rebind.persister.MementoSerializer;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.entity.rebind.persister.RetryingMementoSerializer;
import brooklyn.entity.rebind.persister.StoreObjectAccessorLocking;
import brooklyn.entity.rebind.persister.XmlMementoSerializer;
import brooklyn.entity.rebind.plane.dto.BasicManagementNodeSyncRecord;
import brooklyn.entity.rebind.plane.dto.ManagementPlaneSyncRecordImpl;
import brooklyn.management.ManagementContext;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.ha.ManagementNodeSyncRecord;
import brooklyn.management.ha.ManagementPlaneSyncRecord;
import brooklyn.management.ha.ManagementPlaneSyncRecordPersister;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ManagementPlaneSyncRecordPersisterToObjectStore
implements ManagementPlaneSyncRecordPersister {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementPlaneSyncRecordPersisterToObjectStore.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.TEN_SECONDS;
    private static final Duration SYNC_WRITE_TIMEOUT = Duration.TEN_SECONDS;
    public static final String NODES_SUB_PATH = "nodes";
    private final ConcurrentMap<String, PersistenceObjectStore.StoreObjectAccessorWithLock> nodeWriters = Maps.newConcurrentMap();
    private PersistenceObjectStore.StoreObjectAccessorWithLock masterWriter;
    private PersistenceObjectStore.StoreObjectAccessorWithLock changeLogWriter;
    private ManagementContext mgmt;
    private final PersistenceObjectStore objectStore;
    private final MementoSerializer<Object> serializer;
    private static final int MAX_SERIALIZATION_ATTEMPTS = 5;
    private boolean started = false;
    private volatile boolean running = true;
    @VisibleForTesting
    private boolean preferRemoteTimestampInMemento = false;

    public ManagementPlaneSyncRecordPersisterToObjectStore(ManagementContext mgmt, PersistenceObjectStore objectStore, ClassLoader classLoader) {
        this.mgmt = mgmt;
        this.objectStore = (PersistenceObjectStore)Preconditions.checkNotNull((Object)objectStore, (Object)"objectStore");
        XmlMementoSerializer rawSerializer = new XmlMementoSerializer((ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader"));
        this.serializer = new RetryingMementoSerializer<Object>(rawSerializer, 5);
        objectStore.createSubPath(NODES_SUB_PATH);
        LOG.debug("ManagementPlaneMemento-persister will use store " + objectStore);
    }

    protected synchronized void init() {
        if (!this.started) {
            this.started = true;
            this.masterWriter = new StoreObjectAccessorLocking(this.objectStore.newAccessor("/master"));
            if (this.masterWriter.get() != null) {
                this.changeLogWriter = new StoreObjectAccessorLocking(this.objectStore.newAccessor("/change.log"));
            } else {
                this.masterWriter = new StoreObjectAccessorLocking(this.objectStore.newAccessor("master"));
                this.changeLogWriter = new StoreObjectAccessorLocking(this.objectStore.newAccessor("change.log"));
            }
        }
    }

    @VisibleForTesting
    public void preferRemoteTimestampInMemento() {
        this.preferRemoteTimestampInMemento = true;
    }

    public void stop() {
        this.running = false;
        try {
            for (PersistenceObjectStore.StoreObjectAccessorWithLock writer : this.nodeWriters.values()) {
                try {
                    writer.waitForCurrentWrites(SHUTDOWN_TIMEOUT);
                }
                catch (TimeoutException e) {
                    LOG.warn("Timeout during shutdown, waiting for write of " + writer + "; continuing");
                }
            }
            try {
                this.masterWriter.waitForCurrentWrites(SHUTDOWN_TIMEOUT);
            }
            catch (TimeoutException e) {
                LOG.warn("Timeout during shutdown, waiting for write of " + this.masterWriter + "; continuing");
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public ManagementPlaneSyncRecord loadSyncRecord() throws IOException {
        if (!this.running) {
            throw new IllegalStateException("Persister not running; cannot load memento from " + this.objectStore.getSummaryName());
        }
        this.init();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading management-plane memento from {}", (Object)this.objectStore.getSummaryName());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ManagementPlaneSyncRecordImpl.Builder builder = ManagementPlaneSyncRecordImpl.builder();
        String masterNodeId = this.masterWriter.get();
        if (masterNodeId == null) {
            LOG.debug("No master-memento deserialized from file " + this.masterWriter + "; ignoring and continuing (normal on startup, should cause an error later in live operation)");
        } else {
            builder.masterNodeId(masterNodeId);
        }
        List<String> nodeFiles = this.objectStore.listContentsWithSubPath(NODES_SUB_PATH);
        LOG.trace("Loading nodes from {}; {} nodes.", new Object[]{this.objectStore.getSummaryName(), nodeFiles.size()});
        for (String nodeFile : nodeFiles) {
            PersistenceObjectStore.StoreObjectAccessor objectAccessor = this.objectStore.newAccessor(nodeFile);
            String nodeContents = null;
            Exception problem = null;
            try {
                nodeContents = objectAccessor.get();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                problem = e;
            }
            if (problem != null || Strings.isBlank((CharSequence)nodeContents)) {
                if (objectAccessor.exists()) {
                    throw Exceptions.propagate((Throwable)new IllegalStateException("Node record " + nodeFile + " could not be read when " + this.mgmt.getManagementNodeId() + " was scanning", problem));
                }
                LOG.warn("Node record " + nodeFile + " went away while " + this.mgmt.getManagementNodeId() + " was scanning, ignoring (it has probably been terminated)");
                continue;
            }
            ManagementNodeSyncRecord memento = (ManagementNodeSyncRecord)this.serializer.fromString(nodeContents);
            if (memento == null) {
                throw Exceptions.propagate((Throwable)new IllegalStateException("Node record " + nodeFile + " could not be deserialized when " + this.mgmt.getManagementNodeId() + " was scanning: " + nodeContents, problem));
            }
            if (memento.getRemoteTimestamp() == null || !this.preferRemoteTimestampInMemento) {
                if (memento.getRemoteTimestamp() != null) {
                    LOG.debug("Ignoring remote timestamp in memento file (" + memento + "); looks like this data has been manually copied in");
                }
                Date lastModifiedDate = objectAccessor.getLastModifiedDate();
                ((BasicManagementNodeSyncRecord)memento).setRemoteTimestamp(lastModifiedDate != null ? Long.valueOf(lastModifiedDate.getTime()) : null);
            }
            builder.node(memento);
        }
        if (LOG.isDebugEnabled()) {
            LOG.trace("Loaded management-plane memento; {} nodes, took {}", (Object)nodeFiles.size(), (Object)Time.makeTimeStringRounded((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
        return builder.build();
    }

    public void delta(ManagementPlaneSyncRecordPersister.Delta delta) {
        if (!this.running) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Persister not running; ignoring checkpointed delta of manager-memento");
            }
            return;
        }
        this.init();
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checkpointing delta of manager-memento; updating {}", (Object)delta);
        }
        for (ManagementNodeSyncRecord m : delta.getNodes()) {
            this.persist(m);
        }
        for (String id : delta.getRemovedNodeIds()) {
            this.deleteNode(id);
        }
        switch (delta.getMasterChange()) {
            case NO_CHANGE: {
                break;
            }
            case SET_MASTER: {
                this.persistMaster((String)Preconditions.checkNotNull((Object)delta.getNewMasterOrNull()), null);
                break;
            }
            case CLEAR_MASTER: {
                this.persistMaster("", delta.getExpectedMasterToClear());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state for master-change: " + delta.getMasterChange());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checkpointed delta of manager-memento in " + Time.makeTimeStringRounded((Stopwatch)stopwatch) + ": " + delta);
        }
    }

    private void persistMaster(String nodeId, String optionalExpectedId) {
        String currentRemoteMaster;
        if (optionalExpectedId != null && (currentRemoteMaster = this.masterWriter.get()) != null && !currentRemoteMaster.trim().equals(optionalExpectedId.trim())) {
            LOG.warn("Master at server is " + (Strings.isBlank((CharSequence)currentRemoteMaster) ? "<none>" : currentRemoteMaster) + "; expected " + optionalExpectedId + " " + (Strings.isNonBlank((CharSequence)nodeId) ? "and would set as " + nodeId : "and would clear") + ", so not applying (yet)");
            return;
        }
        this.masterWriter.put(nodeId);
        try {
            this.masterWriter.waitForCurrentWrites(SYNC_WRITE_TIMEOUT);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        this.changeLogWriter.append(Time.makeDateString() + ": set master to " + nodeId + "\n");
        try {
            this.changeLogWriter.waitForCurrentWrites(SYNC_WRITE_TIMEOUT);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    public void waitForWritesCompleted(Duration timeout) throws InterruptedException, TimeoutException {
        for (PersistenceObjectStore.StoreObjectAccessorWithLock writer : this.nodeWriters.values()) {
            writer.waitForCurrentWrites(timeout);
        }
        this.masterWriter.waitForCurrentWrites(timeout);
    }

    public void checkpoint(ManagementPlaneSyncRecord record) {
        this.init();
        for (ManagementNodeSyncRecord node : record.getManagementNodes().values()) {
            if (ManagementNodeState.INITIALIZING.equals((Object)node.getStatus()) || node.getNodeId() == null) continue;
            this.persist(node);
        }
    }

    private void persist(ManagementNodeSyncRecord node) {
        PersistenceObjectStore.StoreObjectAccessorWithLock writer = this.getOrCreateNodeWriter(node.getNodeId());
        boolean fileExists = writer.exists();
        writer.put(this.serializer.toString(node));
        try {
            writer.waitForCurrentWrites(SYNC_WRITE_TIMEOUT);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (!fileExists) {
            this.changeLogWriter.append(Time.makeDateString() + ": created node " + node.getNodeId() + "\n");
        }
        if (node.getStatus() == ManagementNodeState.TERMINATED || node.getStatus() == ManagementNodeState.FAILED) {
            this.changeLogWriter.append(Time.makeDateString() + ": set node " + node.getNodeId() + " status to " + node.getStatus() + "\n");
        }
    }

    private void deleteNode(String nodeId) {
        this.getOrCreateNodeWriter(nodeId).delete();
        this.changeLogWriter.append(Time.makeDateString() + ": deleted node " + nodeId + "\n");
    }

    private PersistenceObjectStore.StoreObjectAccessorWithLock getOrCreateNodeWriter(String nodeId) {
        PersistenceObjectStore.StoreObjectAccessorWithLock writer = (PersistenceObjectStore.StoreObjectAccessorWithLock)this.nodeWriters.get(nodeId);
        if (writer == null) {
            this.nodeWriters.putIfAbsent(nodeId, new StoreObjectAccessorLocking(this.objectStore.newAccessor("nodes/" + nodeId)));
            writer = (PersistenceObjectStore.StoreObjectAccessorWithLock)this.nodeWriters.get(nodeId);
        }
        return writer;
    }
}

