/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.ha;

import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToMultiFile;
import brooklyn.entity.rebind.persister.MementoFileWriterSync;
import brooklyn.entity.rebind.persister.MementoSerializer;
import brooklyn.entity.rebind.persister.RetryingMementoSerializer;
import brooklyn.entity.rebind.persister.XmlMementoSerializer;
import brooklyn.entity.rebind.plane.dto.ManagementPlaneSyncRecordImpl;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.ha.ManagementNodeSyncRecord;
import brooklyn.management.ha.ManagementPlaneSyncRecord;
import brooklyn.management.ha.ManagementPlaneSyncRecordPersister;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Beta
public class ManagementPlaneSyncRecordPersisterToMultiFile
implements ManagementPlaneSyncRecordPersister {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementPlaneSyncRecordPersisterToMultiFile.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.TEN_SECONDS;
    private final String tmpSuffix;
    private final File dir;
    private final File nodesDir;
    private final ConcurrentMap<String, MementoFileWriterSync<ManagementNodeSyncRecord>> nodeWriters = new ConcurrentHashMap<String, MementoFileWriterSync<ManagementNodeSyncRecord>>();
    private final MementoFileWriterSync<String> masterWriter;
    private final MementoFileWriterSync<String> changeLogWriter;
    private final MementoSerializer<Object> serializer;
    private static final int MAX_SERIALIZATION_ATTEMPTS = 5;
    private volatile boolean running = true;

    public ManagementPlaneSyncRecordPersisterToMultiFile(File dir, ClassLoader classLoader, String id) {
        this.dir = (File)Preconditions.checkNotNull((Object)dir, (Object)"dir");
        XmlMementoSerializer rawSerializer = new XmlMementoSerializer((ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader"));
        this.serializer = new RetryingMementoSerializer<Object>(rawSerializer, 5);
        this.tmpSuffix = (String)Preconditions.checkNotNull((Object)id, (Object)"id") + ".tmp";
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(dir);
        this.nodesDir = new File(dir, "nodes");
        this.nodesDir.mkdir();
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(this.nodesDir);
        this.masterWriter = new MementoFileWriterSync<Object>(this.getFileForMaster(), this.serializer, this.tmpSuffix);
        this.changeLogWriter = new MementoFileWriterSync<String>(this.getFileForChangeLog(), MementoSerializer.NOOP, this.tmpSuffix);
        LOG.info("ManagementPlaneMemento-persister will use directory {}", (Object)dir);
    }

    public void stop() {
        this.running = false;
        try {
            for (MementoFileWriterSync writer : this.nodeWriters.values()) {
                try {
                    writer.waitForWriteCompleted(SHUTDOWN_TIMEOUT);
                }
                catch (TimeoutException e) {
                    LOG.warn("Timeout during shutdown, waiting for write of " + writer + "; continuing");
                }
            }
            try {
                this.masterWriter.waitForWriteCompleted(SHUTDOWN_TIMEOUT);
            }
            catch (TimeoutException e) {
                LOG.warn("Timeout during shutdown, waiting for write of " + this.masterWriter + "; continuing");
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    public File getDir() {
        return this.dir;
    }

    public ManagementPlaneSyncRecord loadSyncRecord() throws IOException {
        File[] nodeFiles;
        if (!this.running) {
            throw new IllegalStateException("Persister not running; cannot load memento from " + this.dir);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading management-plane memento from {}", (Object)this.dir);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ManagementPlaneSyncRecordImpl.Builder builder = ManagementPlaneSyncRecordImpl.builder();
        File masterFile = this.getFileForMaster();
        String masterNodeId = (String)(masterFile.exists() ? this.serializer.fromString(this.readFile(masterFile)) : null);
        if (masterNodeId == null) {
            LOG.warn("No entity-memento deserialized from file " + masterFile + "; ignoring and continuing");
        } else {
            builder.masterNodeId(masterNodeId);
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().endsWith(".tmp");
            }
        };
        for (File file : nodeFiles = this.nodesDir.listFiles(fileFilter)) {
            ManagementNodeSyncRecord memento = (ManagementNodeSyncRecord)this.serializer.fromString(this.readFile(file));
            if (memento == null) {
                LOG.warn("No manager-memento deserialized from file " + file + " (possibly just stopped?); ignoring and continuing");
                continue;
            }
            builder.node(memento);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loaded management-plane memento; took {}", (Object)Time.makeTimeStringRounded((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
        return builder.build();
    }

    public void delta(ManagementPlaneSyncRecordPersister.Delta delta) {
        if (!this.running) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Persister not running; ignoring checkpointed delta of manager-memento");
            }
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checkpointed delta of manager-memento; updating {}", (Object)delta);
        }
        for (ManagementNodeSyncRecord m : delta.getNodes()) {
            this.persist(m);
        }
        for (String id : delta.getRemovedNodeIds()) {
            this.deleteNode(id);
        }
        switch (delta.getMasterChange()) {
            case NO_CHANGE: {
                break;
            }
            case SET_MASTER: {
                this.persistMaster((String)Preconditions.checkNotNull((Object)delta.getNewMasterOrNull()));
                break;
            }
            case CLEAR_MASTER: {
                this.persistMaster(null);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state for master-change: " + delta.getMasterChange());
            }
        }
    }

    private void persistMaster(String nodeId) {
        this.masterWriter.write(nodeId);
        this.changeLogWriter.append(Time.makeDateString() + ": set master to " + nodeId + "\n");
    }

    @VisibleForTesting
    public void waitForWritesCompleted(Duration timeout) throws InterruptedException, TimeoutException {
        for (MementoFileWriterSync writer : this.nodeWriters.values()) {
            writer.waitForWriteCompleted(timeout);
        }
        this.masterWriter.waitForWriteCompleted(timeout);
    }

    private String readFile(File file) throws IOException {
        return Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
    }

    private void persist(ManagementNodeSyncRecord node) {
        MementoFileWriterSync<ManagementNodeSyncRecord> writer = this.getOrCreateNodeWriter(node.getNodeId());
        boolean fileExists = writer.exists();
        writer.write(node);
        if (!fileExists) {
            this.changeLogWriter.append(Time.makeDateString() + ": created node " + node.getNodeId() + "\n");
        }
        if (node.getStatus() == ManagementNodeState.TERMINATED || node.getStatus() == ManagementNodeState.FAILED) {
            this.changeLogWriter.append(Time.makeDateString() + ": set node " + node.getNodeId() + " status to " + node.getStatus() + "\n");
        }
    }

    private void deleteNode(String nodeId) {
        this.getOrCreateNodeWriter(nodeId).delete();
        this.changeLogWriter.append(Time.makeDateString() + ": deleted node " + nodeId + "\n");
    }

    private MementoFileWriterSync<ManagementNodeSyncRecord> getOrCreateNodeWriter(String nodeId) {
        MementoFileWriterSync writer = (MementoFileWriterSync)this.nodeWriters.get(nodeId);
        if (writer == null) {
            this.nodeWriters.putIfAbsent(nodeId, new MementoFileWriterSync<Object>(this.getFileForNode(nodeId), this.serializer, this.tmpSuffix));
            writer = (MementoFileWriterSync)this.nodeWriters.get(nodeId);
        }
        return writer;
    }

    private File getFileForNode(String nodeId) {
        return new File(this.nodesDir, nodeId);
    }

    private File getFileForMaster() {
        return new File(this.dir, "master");
    }

    private File getFileForChangeLog() {
        return new File(this.dir, "change.log");
    }
}

